<?php

namespace App\Libraries;

use CodeIgniter\Model;

class LibPaginate
{

    private $model;
    private $request;
    private $rows;
    private $page;
    private $sort;
    private $label;
    private $localFilter;

    public function __construct(Model $model, \CodeIgniter\HTTP\RequestInterface $request, string $label = 'data')
    {
        $this->model = $model;
        $this->request = $request;
        $this->label = $label;
        $this->localFilter = [];
        $this->rows = 50;
        $this->page = 1;
        $this->load();
    }

    private function load()
    {
        $this->setRows($this->request->getGetPost('length'));
        $this->setPage($this->request->getGetPost('start'));
        $this->setSort($this->request->getGetPost('sort'));
        $this->setOrder($this->request->getGetPost('order'));
    }


    public function setRows($rows)
    {
        if ($rows) {
            $this->rows = intval($rows);
        }
    }

    public function setPage($page)
    {
        if ($page) {
            $this->page = intval($page);
        }
    }

    public function useFields(array $fields)
    {
        $this->model->select(implode(",", $fields));
    }

    public function setSort($field , $force=false)
    {
        if ($force) {
            $this->sort = $field;
        } else {
            if (!empty($field) && in_array($field, $this->model->allowedFields)) {
                $this->sort = $field;
            } elseif (in_array('id', $this->model->allowedFields)) {
                $this->sort = 'id';
            }
        }
        
    }

    public function setOrder($order, $field = null)
    {
        if (!empty($field)) $this->setSort($field);

        if (!empty($order) && !empty($this->sort)) {
            $order = trim(strtolower($order));
            if ($order == "asc") {
                $this->model->orderBy($this->sort, $order);
            }
            if ($order == "desc") {
                $this->model->orderBy($this->sort, $order);
            }
        }
    }

    public function addFilter($queryField, $requestField, $type = '=')
    {
        if ($this->request->getGetPost($requestField)) {
            $this->localFilter[] = (object)[
                'field' => $queryField,
                'requestField' => $requestField,
                'value' => $this->request->getGetPost($requestField),
                'type' => $type
            ];
        }
    }

    public function addSearchFilter($queryField, $value, $type = '=')
    {
            $this->localFilter[] = (object)[
                'field' => $queryField,
                'requestField' => $queryField,
                'value' => $value,
                'type' => $type
            ];
    }

    private function filter()
    {
        foreach ($this->localFilter as $filter) {
            if ($filter->type == '=') {
                $this->model->where($filter->field, $filter->value);
            }
            if ($filter->type == 'like') {
                $this->model->like($filter->field, $filter->value);
            }
            if ($filter->type == 'null') {
                $this->model->where($filter->field, null);
            }
            if ($filter->type == 'notnull') {
                $this->model->where("{$filter->field} is not null");
            }
        }
    }
    
    private function pagination()
    {
        return (object) [
            'rows' => $this->model->pager->getTotal('default'),
            'pages' => $this->model->pager->getPageCount('default'),
            'current' => $this->model->pager->getCurrentPage('default'),
        ];
    }

    private function result()
    {
        return $this->model->paginate($this->rows, 'default', $this->page, 2);
    }

    public function getFilter()
    {
        return array_map(function ($e) {
            return (object)[
                'field' => $e->requestField,
                'value' => $e->value,
            ];
        }, $this->localFilter);
    }

    public function get()
    {
        $this->filter();
        return [
            $this->label => $this->result(),
            'pagination' => $this->pagination(),
            'filter' => $this->getFilter(),
        ];
    }
    
    public function getData()
    {
        $this->filter();
        return $this->model->findAll();
    }
}
