<?php

namespace App\Libraries;

use App\Models\RegistryModel;
use App\Models\DeliveryModel;
use App\Models\TicketModel;
use App\Models\PhotoModel;
use App\Models\DeviceModel;
use App\Models\Ihx\IhxAcessoModel;
use App\Models\Ihx\IhxIngressoModel;
use stdClass;

class TicketValidation
{
    private TicketModel $ticket;
    private RegistryModel $register;
    private DeliveryModel $delivery;
    private DeviceModel $device;
    private $rs;
    private stdClass $dataProc;
    private PhotoModel $photo;
    private IhxIngressoModel $ihx_ticket;
    private IhxAcessoModel $ihx_acesso;

    public function __construct()
    {
        $this->ticket = new TicketModel();
        $this->register = new RegistryModel();
        $this->delivery = new DeliveryModel();
        $this->photo = new PhotoModel();
        $this->device = new DeviceModel();
        $this->ihx_ticket = new IhxIngressoModel();
        $this->ihx_acesso = new IhxAcessoModel();
        $this->initDataProd();
    }

    public function validateTicket($card, $terminalId)
    {

        $this->dataProc->deviceId = $terminalId;

        $model = $this->device->find($terminalId);

        if ($model->terminal_model == 'ENTREGA') {
            return $this->validateEntregaPin($card, $model->terminal_pin, false);
        } else {
            $this->rs = $this->ticket->validaTicket($card, $terminalId);

            if ($this->rs) {
                $this->dataProc->ticketNumber = $this->rs->cartao;
                $this->dataProc->ticketId = $this->rs->id;
                $this->dataProc->eventId = $this->rs->id_evento;
                $this->dataProc->name = $this->rs->nome;
                $this->dataProc->category = $this->rs->categoria;
                $this->dataProc->hora_acesso = $this->rs->hora_acesso;
                $this->isMaster();
                $this->isActive();
                $this->isEventValid();
                $this->isTicketValid();
                if (!$this->dataProc->proccess) {
                    $this->dataProc->action = 'PS';
                    $this->registerCard();
                    $this->dataProc->proccess = true;
                }
            } else {
                $this->dataProc->ticketNumber = $card;
                $this->dataProc->action = 'CI';
                $this->registerCard();
                $this->dataProc->proccess = true;
            }
            $this->getPhoto();
            return $this->dataProc;
        }
        
    }

    public function validate($card, $pin, $viewImage = false)
    {
        $model = $this->getDeviceTerminalModel($pin);

        if ($model == 'APP' ) {
            return $this->validateTicketPin($card, $pin, $viewImage);
        }
        if ( $model == 'OUTROS') {
            $this->getPhoto();
            return $this->validateTicketPin($card, $pin, $viewImage);
        }
        if ($model == 'ENTREGA') {
            return $this->validateEntregaPin($card, $pin, $viewImage);
        }
        if ($model == 'IHX-APP') {
            return $this->validateTicketIhxPin($card, $pin, $viewImage);
        }

        $this->dataProc->ticketNumber = $card;
        $this->dataProc->action = 'CI';
        $this->dataProc->proccess = true;

        $this->dataProc->actionType = $this->register->getAction($this->dataProc->action);

        if ($viewImage) {
            $this->getPhoto();
        }

        return $this->dataProc;
    }

    public function validateTicketPin($card, $pin, $viewImage = false)
    {

        $this->rs = $this->ticket->validaTicketPin($card, $pin);
        $this->dataProc->deviceId = null;

        if ($this->rs) {
            $this->dataProc->deviceId = $this->rs->terminal_id;
            $this->dataProc->ticketNumber = $this->rs->cartao;
            $this->dataProc->ticketId = $this->rs->id;
            $this->dataProc->eventId = $this->rs->id_evento;
            $this->dataProc->eventName = $this->rs->evento;
            $this->dataProc->name = $this->rs->nome;
            $this->dataProc->category = $this->rs->categoria;
            $this->dataProc->hora_acesso = $this->rs->hora_acesso;
            $this->isMaster();
            $this->isActive();
            $this->isEventValid();
            $this->isTicketValid();
            if (!$this->dataProc->proccess) {
                $this->dataProc->action = 'PS';
                $this->registerCard();
                $this->dataProc->proccess = true;
            }
        } else {
            $this->dataProc->ticketNumber = $card;
            $this->dataProc->action = 'CI';
            $this->registerCard();
            $this->dataProc->proccess = true;
        }

        $this->dataProc->actionType = $this->register->getAction($this->dataProc->action);

        if ($viewImage) {
            $this->getPhoto();
        }

        return $this->dataProc;
    }

    public function validateEntregaPin($card, $pin, $viewImage = false)
    {

        $this->rs = $this->ticket->validaEntregaPin($card, $pin);

        $this->dataProc->deviceId = null;

        if ($this->rs) {
            $this->dataProc->deviceId = $this->rs->terminal_id;
            $this->dataProc->ticketNumber = $this->rs->cartao;
            $this->dataProc->ticketId = $this->rs->id;
            $this->dataProc->eventId = $this->rs->id_evento;
            $this->dataProc->eventName = $this->rs->evento;
            $this->dataProc->name = $this->rs->nome;
            $this->dataProc->category = $this->rs->categoria;
            $this->dataProc->hora_acesso = $this->rs->hora_acesso;
            $this->isEntregaActive();
            $this->isEntregaValid();
            if (!$this->dataProc->proccess) {
                $this->dataProc->action = 'PS';
                $this->entregaCard();
                $this->dataProc->proccess = true;
            }
        } else {
            $this->dataProc->ticketNumber = $card;
            $this->dataProc->action = 'CI';
            $this->entregaCard();
            $this->dataProc->proccess = true;
        }

        $this->dataProc->actionType = $this->delivery->getAction($this->dataProc->action);

        return $this->dataProc;
    }

    public function validateTicketIhxPin($card, $pin, $viewImage = false)
    {
        $this->ihx_ticket->transStart();
        $this->rs = $this->ihx_ticket->validaTicket($card, $pin);
        $this->dataProc->deviceId = null;

        if ($this->rs) {
            $this->dataProc->deviceId = $this->rs->deviceId;
            $this->dataProc->ticketNumber = $this->rs->ticketNumber;
            $this->dataProc->ticketId = $this->rs->ticketId;
            $this->dataProc->eventId = $this->rs->eventId;
            $this->dataProc->eventName = $this->rs->eventName;
            $this->dataProc->name =  $this->rs->name;
            $this->dataProc->category = $this->rs->category;
            $this->dataProc->hora_acesso = $this->rs->hora_acesso;
            $this->ihxIsExists();
            $this->ihxIsActive();
            $this->ihxIsTicketValid();
            if (!$this->dataProc->proccess) {
                $this->dataProc->action = 'PS';
                $this->ihxRegisterCard();
                $this->dataProc->proccess = true;
            }
        } else {
            $this->dataProc->ticketNumber = $card;
            $this->dataProc->action = 'CI';
            $this->ihxRegisterCard();
            $this->dataProc->proccess = true;
        }

        $this->dataProc->actionType = $this->register->getAction($this->dataProc->action);

        if ($viewImage) {
            $this->getPhoto();
        }

        

        $this->ihx_ticket->transComplete();

        return $this->dataProc;
    }

    private function isMaster()
    {
        if (!$this->dataProc->proccess && $this->rs->mestre == 1) {
            $this->dataProc->action = 'PS';
            $this->registerCard();
            $this->dataProc->proccess = true;
        }
    }

    private function isActive()
    {
        if (!$this->dataProc->proccess && $this->rs->situacao != 1) {
            $this->dataProc->action = 'CB';
            $this->registerCard();
            $this->dataProc->proccess = true;
        }
    }

    private function isEntregaActive()
    {
        if (!$this->dataProc->proccess && $this->rs->situacao != 1) {
            $this->dataProc->action = 'CB';
            $this->entregaCard();
            $this->dataProc->proccess = true;
        }
    }



    private function isEventValid()
    {
        if (!$this->dataProc->proccess && $this->rs->valido != 1) {
            $this->dataProc->action = 'CE';
            $this->registerCard();
            $this->dataProc->proccess = true;
        }
    }

    private function isTicketValid()
    {

        if (
            !$this->dataProc->proccess
            && $this->rs->idr_multiplo == 0
            && $this->rs->marcacao != 0
            && $this->rs->mestre != 1
        ) {
            $this->dataProc->action = 'CR';
            $this->registerCard();
            $this->dataProc->proccess = true;
        }
    }

    private function isEntregaValid()
    {

        if (
            !$this->dataProc->proccess
            && $this->rs->idr_multiplo == 0
            && $this->rs->marcacao != 0
            && $this->rs->mestre != 1
        ) {
            $this->dataProc->action = 'CR';
            $this->entregaCard();
            $this->dataProc->proccess = true;
        }
    }

    private function ihxIsExists()
    {
        if (
            !$this->dataProc->proccess
            && empty($this->rs->ticketId)
        ) {
            $this->dataProc->action = 'CI';
            $this->ihxRegisterCard();
            $this->dataProc->proccess = true;
        }
    }

    private function ihxIsActive()
    {
        if (
            !$this->dataProc->proccess
            && $this->rs->situacao != 1
        ) {
            $this->dataProc->action = 'CB';
            $this->ihxRegisterCard();
            $this->dataProc->proccess = true;
        }
    }

    private function ihxIsTicketValid()
    {
        if (
            !$this->dataProc->proccess
            && $this->rs->situacao == 1
            && $this->rs->marcacao != 0
        ) {
            $this->dataProc->action = 'CR';
            $this->ihxRegisterCard();
            $this->dataProc->proccess = true;
        }
    }

    private function registerCard()
    {
        $dateNow = date('Y-m-d H:i:s', time());
        $this->register->insert(
            [
                'cartao' => $this->dataProc->ticketNumber,
                'serial_id' => $this->register->getNextSerialId(),
                'id_pessoa' => $this->dataProc->ticketId,
                'id_evento' => $this->dataProc->eventId,
                'terminal' => $this->dataProc->deviceId,
                'data_acesso' => $dateNow,
                'hora_acesso' => null,
                'acao' => $this->dataProc->action
            ]
        );

        if($this->dataProc->action == 'PS') {
            $this->ticket->update($this->dataProc->ticketId,[
                'serial_id' => $this->ticket->getNextSerialId()
            ]);
            $this->dataProc->hora_acesso = $dateNow;
        }
    }

    private function entregaCard()
    {
        $dateNow = date('Y-m-d H:i:s', time());
        $this->delivery->insert(
            [
                'cartao' => $this->dataProc->ticketNumber,
                'serial_id' => time(),
                'id_pessoa' => $this->dataProc->ticketId,
                'id_evento' => $this->dataProc->eventId,
                'terminal' => $this->dataProc->deviceId,
                'data_acesso' => $dateNow,
                'hora_acesso' => null,
                'acao' => $this->dataProc->action
            ]
        );

        if($this->dataProc->action == 'PS') {
            $this->ticket->update($this->dataProc->ticketId,[
                'serial_id' => time()
            ]);
            $this->dataProc->hora_acesso = $dateNow;
        }
    }

    private function ihxRegisterCard()
    {
        $this->dataProc->actionType = $this->register->getAction($this->dataProc->action);
        $acessodescricao = '';
        if (!empty($this->dataProc->actionType)) {
            $acessodescricao = $this->dataProc->actionType->info;
        }
        if (!empty($this->rs->deviceId)) {

            $this->ihx_acesso->insert(
                [
                    'acessoinvalido' => 0,
                    'acessoliberado' => $this->dataProc->action == 'PS' ? 1 : 0,
                    'acessodatahora' => date('Y-m-d H:i:s'),
                    'acessodescricao' => $acessodescricao,
                    'equipamentotipoterminal' => $this->rs->equipamentotipoterminal,
                    'acessosentido' => $this->dataProc->action == 'PS' ? 'E' : 'X',
                    'acessorealizado' => $this->dataProc->action == 'PS' ? 1 : 0,
                    'acessorefeitorio' => 0,
                    'acessocontrolador' => 1,
                    'visitaid' => null,
                    'cracha' => sprintf("%'016s", $this->dataProc->ticketNumber),
                    'matricula' => 0,
                    'pessoaid' => 999999999,
                    'pessoanome' => $this->dataProc->action == 'PS' ? 'INGRESSO LIBERADO' : 'INGRESSO INVALIDO',
                    'visitante' => 1,
                    'isveiculo' => null,
                    'empresaid' => $this->rs->empresa_id,
                    'estruturaid' => $this->rs->estruturaid_id,
                    'setorid' =>  $this->rs->setor_id,
                    'empresanome' => 'GUARDI',
                    'estruturadescricao' => 'EVENTO',
                    'setordescricao' => $this->rs->setordescricao,
                    'equipamentoid' => $this->rs->deviceId,
                    'equipamentodescricao' => $this->rs->equipamentodescricao,
                    'equipamentotcpip' => $this->rs->equipamentotcpip,
                    'equipamentomacaddress' => $this->rs->equipamentomacaddress,
                    'equipamentoserverhost' => $this->rs->equipamentoserverhost,
                    'comando' => '0',
                    'str_enviado' => $this->dataProc->action == 'PS' ?  '01;02;E;05;<< E N T R A D A;INGRESSO LIBERAD;                ' :  '01;03;05;    BLOQUEADO   ;      BI-04     ;',
                    'registroonline' => 1,
                    'acessotipificacao' => null
                ]
            );

            if ($this->dataProc->action == 'PS') {
                $this->ihx_ticket->update($this->dataProc->ticketId, [
                    'utilizado' => 1
                ]);
            }
        }
    }

    private function initDataProd()
    {
        $this->dataProc = (object) [
            'action' => null,
            'ticketNumber' => null,
            'ticketId' => null,
            'deviceId' => null,
            'eventId' => null,
            'eventName' => null,
            'valid' => false,
            'photo' => null,
            'name' => null,
            'category' => null,
            'hora_acesso' => date('Y-m-d H:i:s', time()),
            'proccess' => false
        ];
    }

    private function getPhoto()
    {
        if (!$this->rs) {
            $image = file_get_contents(WRITEPATH . 'uploads/person.jpg');
        } else {
            $result = $this->photo->where('id_pessoas', intval($this->rs->id))->first();
            if ($result && $result->foto && strlen($result->foto) > 10) {
                $image = $result->foto;
            } else {
                $image = file_get_contents(WRITEPATH . 'uploads/person.jpg');
            }
        }
        $this->dataProc->photo = base64_encode($image);
    }

    public function getDeviceTerminalModel($pin)
    {
        $device = $this->device->where([
            'terminal_pin' => $pin,
            'ativo' => 1,
        ])->first();

        if (!empty($device)) {
            return $device->terminal_model;
        }
        return null;
    }
    
    public function getDeviceTerminalModelById($id)
    {
        $device = $this->device->where([
            'id' => $id,
            'ativo' => 1,
        ])->first();

        if (!empty($device)) {
            return $device->terminal_model;
        }
        return null;
    }
}
