<?php

namespace App\Libraries;

class SystemMenu
{

    private $menu = [];
    private $group = null;
    static $selected;

    public function __construct()
    {
        $this->loadMenu();
    }

    public function setGroup($grp)
    {
        $this->group = $grp;
    }

    static function setSelected($val)
    {
        Self::$selected = $val;
    }

    private function loadMenu()
    {
        $this->setMenu('Dashboard', 'Dashboard', '/dashboard', '', '', 'home');
        // $this->setMenu('Relatórios', 'Cadastros', '/dashboard/cadastros', '', '', 'caret-square-right');
        $this->setMenu('Relatórios', 'Entradas', '/dashboard/entradas', '', '', 'home');
        $this->setMenu('Administrativo', 'Parâmetros', '/app', 'api/app', 'get', 'gear');
        $this->setMenu('Administrativo', 'Usuários', '/user', 'api/backoffice/user', 'get', null);
        $this->setMenu('Usuario', 'Logout', '/auth/logout', null, 'get', 'times');
    }

    public function getSideMenu(array $permission = [])
    {
        $lista = [];

        foreach ($this->menu as $km => $vm) {
            if (!array_key_exists($vm->group, $lista)) {
                $lista[$vm->group] = [];
            }
            if (empty($vm->apiRota)) {
                $lista[$vm->group][] = $vm;
                continue;
            }

            foreach ($permission as $kp => $vp) {
                if (($vp->route === $vm->apiRota) && ($vp->method === $vm->apiMetodo)) {
                    $lista[$vm->group][] = $vm;
                }
            }

            $lista = array_filter($lista, function ($l) {
                return is_array($l) && count($l) > 0;
            });
        }
        $out = (object) [
            'menu' => $lista,
            'selected' => $this->group,
        ];
        return $out;
    }

    private function setMenu($group, $nome, $rota, $apiRota, $apiMetodo, $icon)
    {
        $this->menu[] = (object) [
            'group' => $group,
            'name' => $nome,
            'rota' => $rota,
            'apiRota' => $apiRota,
            'apiMetodo' => $apiMetodo,
            'icon' => $icon,
        ];
    }
}
