<?php

namespace App\Libraries\Sympla;

use App\Libraries\Sympla\SymplaHttp;

class SymplaApi extends SymplaHttp
{

    private int $eventApi;

    const ENDPOINT_EVENT = 'events/';

    public function setEventApi($eventApi)
    {
        $this->eventApi = $eventApi;
    }

    public function getEventApi()
    {
        return $this->eventApi;
    }

    public function getEvents()
    {
        return $this->httpGET(self::ENDPOINT_EVENT);
    }

    public function getEventById()
    {
        return $this->httpGET(self::ENDPOINT_EVENT . $this->eventApi);
    }

    public function getOrdersByEvent()
    {
        return $this->httpGET(self::ENDPOINT_EVENT . $this->eventApi . '/orders');
    }

    public function getOrderById($orderId)
    {
        return $this->httpGET(self::ENDPOINT_EVENT . $this->eventApi . '/orders/' . $orderId);
    }

    public function getOrderParticipants($orderId)
    {
        return $this->httpGET(self::ENDPOINT_EVENT . $this->eventApi . '/orders/' . $orderId . '/participants');
    }

    public function getParticipantsByEvent($params = array())
    {
        $query = '';
        if (!empty($params)) {
            $query = '?' . http_build_query($params);
        }
        return $this->httpGET(self::ENDPOINT_EVENT . $this->eventApi . '/participants' . $query);
    }

    public function getParticipantsByOrder($orderId)
    {
        return $this->httpGET(self::ENDPOINT_EVENT . $this->eventApi . '/participants/' . $orderId);
    }

    public function getParticipantsByTicket($ticket)
    {
        return $this->httpGET(self::ENDPOINT_EVENT . $this->eventApi . '/participants/ticketNumber/' . $ticket);
    }

    public function checkinByTicketCode($ticketCode)
    {
        return $this->httpPOST(
            self::ENDPOINT_EVENT .
                $this->eventApi .
                '/participants/ticketNumber/' .
                $ticketCode .
                '/checkIn'
        );
    }
    
    public function checkinByTicketId($ticketId)
    {
        return $this->httpPOST(self::ENDPOINT_EVENT . $this->eventApi . '/participants/' . $ticketId . '/checkin');
    }
}
