<?php

namespace App\Libraries;

use App\Models\TicketeiraEventoModel;
use App\Models\CategoryModel;
use App\Models\TicketModel;
use App\Models\PhotoModel;
use App\Models\EventModel;
use App\Models\RegistryModel;
use App\Models\DeliveryModel;
use App\Libraries\Ticketeria\Ticketeria;
use App\Libraries\Bora\Bora;
use CodeIgniter\CLI\CLI;
use stdClass;

class LibTicketeria
{

    private TicketeiraEventoModel $ticketeriaEvento;
    private TicketModel $ticket;
    private CategoryModel $category;
    private RegistryModel $registry;
    private DeliveryModel $delivery;
    private EventModel $event;
    private stdClass $monitor;
    private stdClass $data;
    private Ticketeria $ticketeria;
    private PhotoModel $photo;
    private Bora $bora;
    // private Ticketeria $Ticketeria;

    public function __construct()
    {
        $this->ticketeriaEvento = new TicketeiraEventoModel();
        $this->ticket = new TicketModel();
        $this->category = new CategoryModel();
        $this->registry = new RegistryModel();
        $this->delivery = new DeliveryModel();
        $this->event = new EventModel();
        $this->bora = new Bora();
        $this->ticketeria = new Ticketeria();
        $this->photo = new PhotoModel();
        // $this->ticketeria = new Ticketeria();
        $this->monitor = (object) [
            'tickets' => (object) [
                'page' => 0,
                'totalPage' => 0,
                'totalTickets' => 0,
                'lastDate' => 0,
                'has_next' => true,
                'news' => 0,
                'updated' => 0,
                'noupdated' => 0,
                'fTotal' => 0,
                'fKey' => 0,
                'number' => 0,
                'name' => null,
            ],
            'leitura' => (object) [
                'page' => 0,
                'totalPage' => 0,
                'totalTickets' => 0,
                'lastDate' => 0,
                'has_next' => true,
                'news' => 0,
                'updated' => 0,
                'noupdated' => 0,
                'fTotal' => 0,
                'fKey' => 0,
                'number' => 0,
                'name' => null,
            ],
            'checkin' => (object) [
                'key' => 0,
                'count' => 0,
                'number' => 0,
                'lista' => 0,
                'enviados' => 0
            ]
        ];
    }

    public function startSync($integrador)
    {
        $this->data = $integrador;

        $startSync = date('Y-m-d H:i:s');
        $this->ticketeriaEvento->update(
            $integrador->id,
            [
                'startSync' => $startSync,
                'endSync' => null,
                'statusSync' => 'iniciando varredura'
            ]
        );
        $this->sincCloud($integrador, 'start');
    }

   

    public function getIntegradores()
    {
        return $this->ticketeriaEvento
            ->select('
                ticketeira_evento.id,
                ticketeira.id as ticketeira_id,
                ticketeira.nome as ticketeira,
                ticketeira.modulo,
                ticketeira_evento.evento_id,
                ticketeira_evento.token,
                ticketeira_evento.identify,
                ticketeira_evento.params,
                ticketeira_evento.startSync,
                ticketeira_evento.endSync,
                ticketeira_evento.statusSync,
                ticketeira_evento.ticket_serial_id,
                ticketeira_evento.registry_serial_id,
                ticketeira_evento.entrega_serial_id
            ')
            ->join('ticketeira', 'ticketeira.id = ticketeira_evento.ticketeira_id')
            ->where([
                'ticketeira_evento.active' => 1,
                'ticketeira.ativo' => 1,
                'ticketeira.modulo' => 'ticketeria',
            ])->findAll();
    }

    public function sincCloud($integrador, $service)
    {
        CLI::write('|= iniciando ....===|');
        $this->monitor->tickets->page = 1;
        $this->monitor->tickets->news = 0;
        $this->monitor->tickets->updated = 0;
        $this->monitor->tickets->noupdated = 0;
        $this->monitor->tickets->name = 'Importa todos os registros';
        $this->display();
        $this->processaSinc();
    }

    private function processaSinc()
    {

        $this->monitor->tickets->name = 'Importa todos os registros';
        $this->ticketeria->api->setToken($this->data->token);
        $this->page();

        if ($this->monitor->tickets->has_next) {
            $this->monitor->tickets->page++;
            $this->processaSinc();
        } else {
            $this->monitor->tickets->page = 1;
            $this->monitor->tickets->page = 1;
            $this->monitor->tickets->news = 0;
            $this->monitor->tickets->updated = 0;
            $this->monitor->tickets->noupdated = 0;
            sleep(1);
        }
    }

    private function display()
    {
        $dateT = date('d/m/Y H:i:s');
        CLI::clearScreen();
        CLI::write('|=====================================================================|');
        CLI::write("|=====   {$this->monitor->tickets->name}  ====   {$dateT}   ===|", 'red', 'yellow');
        CLI::write('|=====================================================================|' . "\n");
        CLI::showProgress($this->monitor->tickets->page, $this->monitor->tickets->totalPage);
        CLI::write('|=====================================================================|' . "\n");
        CLI::write("| Page: {$this->monitor->tickets->page} de {$this->monitor->tickets->totalPage} |", 'dark_blue', 'yellow');
        CLI::write('|=====================================================================|' . "\n");
        CLI::showProgress($this->monitor->tickets->fKey, $this->monitor->tickets->fTotal);
        CLI::write("| Item da Page: {$this->monitor->tickets->fKey} |", 'dark_blue', 'yellow');
        CLI::write("| Total da Page: {$this->monitor->tickets->fTotal} |");
        CLI::write("| Number: {$this->monitor->tickets->number} |");
        CLI::write("| Novos: {$this->monitor->tickets->news} |");
        CLI::write("| Atualizados: {$this->monitor->tickets->updated} |");
        CLI::write("| Sem atualizações: {$this->monitor->tickets->noupdated} |");
        CLI::write('|=====================================================================|' . "\n");
    }

    private function page($page = 1, $last = false)
    {
        $data =  false;
        $params = [
            'page' => $this->monitor->tickets->page,
            'rows' => 2000,
            'code' => $this->data->identify,
            'serial' => $this->data->ticket_serial_id,
        ];

        try {
            $data = $this->ticketeria->api->getPerson($params);
            
        } catch (\Exception $e) {
            CLI::write("| ERROR:  - {$e->getMessage()}   ", 'dark_blue', 'red');
            $data = false;
        }

        if (!empty($data) && !empty($data->data)) {
            $pagination = $data->data->pagination;
            if (!$last) {
                $this->monitor->tickets->page = $pagination->current;
                $this->monitor->tickets->has_next = ($pagination->pages > $pagination->current);
                $this->monitor->tickets->totalPage = $pagination->pages;
                $this->monitor->tickets->totalTickets = $pagination->rows;
                $this->monitor->tickets->lastDate = date('d/m/Y H:i:s');
            }
        }

        if (!empty($data)) {
            $this->processaResponse($data->data->tickets);
        }
    }

    private function processaResponse($data)
    {
        $sts = (object) [
            'novos' => 0,
            'updates' => 0,
            'non' => 0,
        ];

        $this->monitor->tickets->fTotal = count($data);
        $ticket_serial_id = $this->data->ticket_serial_id;
        foreach ($data as $key => $item) {
            if ($item->serial > $this->data->ticket_serial_id) {
                $ticket_serial_id = (int) $item->serial;
            }

            $event = $this->event->where('id', $this->data->evento_id)->first();
            
            if (empty($event)) {
                continue;
            }

            $ticket = (object) [
                'id_evento' => $event->id,
                'id_categoria' => $this->getCategoryId($item),
                'cartao' => $item->ticket,
                'campoextra1' => $item->batchName,
                'campoextra2' => $item->funcao,
                'email' => null,
                'nome' => $item->name,
                'ticketeira_id' => $this->data->ticketeira_id,
                'ticketeira_identify' => $item->person_id,

                'ticketeira_updated_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'situacao' => 1,
                'mestre' => 0,
                'send_on' => date('Y-m-d H:i:s'),
            ];

            $resp = $this->ticket->addOrInsert($ticket, $ticket_serial_id);
            if (!$resp->exists) {
                $this->monitor->tickets->news++;
            } else {
                $this->monitor->tickets->updated++;
            }


            $image = file_get_contents($item->image_url);
            $data = [
                'id_pessoas'=> $resp->id,
                'foto' => ($image),
                'criado_em'=> date('Y-m-d H:i:s'),
                'send_on'=>null
            ];

            $image = $this->photo->where('id_pessoas', $resp->id)->first();
            if($image){
                $this->photo->update($image->id, $data);
            } else {
                $this->photo->save($data);
            }



            $this->display();
        }
        // dd($ticket_serial_id);
        if ($ticket_serial_id > $this->data->ticket_serial_id) {
            $this->ticketeriaEvento->where([
                'evento_id' => $this->data->evento_id,
                'ticketeira_id' => $this->data->ticketeira_id
            ])
                ->set(['ticket_serial_id' => $ticket_serial_id])
                ->update();
        }
    }


    private function getCategoryId($data)
    {

        $category = $this->category->where('categoria', $data->categoryname)->first();
        if (!empty($category)) {
            return $category->id;
        } else {
            return $this->category->insert([
                'categoria' => $data->categoryname,
                'idr_multiplo' => 1,
                'fluxo' => 0,
                'tipo' => $data->categorytype,
                'external_id' => null
            ]);
        }
    }
}
