<?php

namespace App\Libraries;

use App\Models\TicketModel;
use App\Models\EventModel;
use App\Models\CategoryModel;
use App\Models\RegistryModel;
use App\Models\PhotoModel;
use App\Models\FieldModel;
use stdClass;

class LibSync
{

    private TicketModel $ticket;
    private EventModel $event;
    private CategoryModel $category;
    private RegistryModel $registry;
    private PhotoModel $photo;
    private FieldModel $field;
    private array $fields;

    public function __construct()
    {
        $this->ticket = new TicketModel();
        $this->event = new EventModel();
        $this->category = new CategoryModel();
        $this->registry = new RegistryModel();
        $this->photo = new PhotoModel();
        $this->field = new FieldModel();
        $this->fields = [];
    }

    public function setAll($sync)
    {
        if (empty($sync)) {
            return null;
        }
        $rs = $this->event->first();
        if(!empty($rs)) {
            $this->eventId = $rs->id;
        }
        
        $lastSync = $sync->lastSync;
        $this->setEvent($sync->event);
        $this->setCategories($sync->category);
        $this->setFields($sync->field);
        $this->setTicket($sync);
    }
    public function getAll()
    {
        $rsEvent = $this->event->first();
        if (!empty($rsEvent)) {
            $this->eventId = $rsEvent->id;
        }

        return $this->ticket->where([
            'cartoes.id_evento'=> $this->eventId,
            'cartoes.send_on'=> null
        ])
        ->join('categorias', 'categorias.id = cartoes.id_categoria', 'left')
        ->findAll();
    }
    public function getRegister($sync)
    {
        if (empty($sync)) {
            return null;
        }
        $rs = $this->event->first();
        if (!empty($rs)) {
            $this->eventId = $rs->id;
        }
  
        $lastSync = $sync->lastSync;
        $this->setRegister($sync);
    }
    public function getImage($sync)
    {
        if (empty($sync)) {
            return null;
        }
        $rs = $this->event->first();
        if (!empty($rs)) {
            $this->eventId = $rs->id;
        }
  
        $lastSync = $sync->lastSync;
        $this->setImage($sync);
    }
   

    public function setFields($fields)
    {
        foreach ($fields as $field) {
            $this->fields[$field->id] = $field->name;
            if (!$this->field->where('external_id', $field->id)->first()) {
                $this->field->insert(
                    [
                        'name' => $category->name,
                        'campo' => 0,
                        'external_id' => $field->id
                    ]
                );
            }
        }
    }

    public function setEvent($event)
    {
        if (!$this->event->findAll()) {
            return $this->event->insert(
                [
                    'evento' => $event->name,
                    'local' => $event->local,
                    'data_inicio' => $event->start_date,
                    'data_fim' => $event->end_date,
                    'idr_cadastrado' => 0,
                    'idr_passagem' => 0,
                    'qtd_livre' => 0,
                    'qtd_midia1' => 0,
                    'qtd_midia2' => 0,
                    'qtd_midia3' => 0,
                    'qtd_midia4' => 0
                ]
            );
        }
        return null;
    }

    public function setCategories($categories)
    {
        foreach ($categories as $category) {
            if (!$this->category->where('external_id', $category->id)->first()) {
                $this->category->insert(
                    [
                        'categoria' => $category->name,
                        'idr_multiplo' => 0,
                        'fluxo' => 0,
                        'external_id' => $category->id
                    ]
                );
            }
        }
    }

    public function setTicket($sync)
    {
        foreach ($sync->ticket as $ticket) {
            $rs = $this->ticket->where('servidor_id', $ticket->id)->first();
            $field = $this->getFields($ticket->fields);
            if (!$rs) {
                $this->ticket->insert(
                    [
                        'servidor_id' => $ticket->id,
                        'id_evento' => $this->eventId,
                        'id_user' => null,
                        'id_categoria' => $this->getLocalCategory($ticket->category_id),
                        'cartao' => $ticket->cod,
                        'nome' => $field->nome,
                        'email' => $field->email,
                        'rg' => $field->rg,
                        'cpf' => $field->cpf,
                        'campoextra1' => $field->campoextra1,
                        'campoextra2' => $field->campoextra2,
                        'situacao' => $ticket->active,
                        'mestre' => $ticket->multipass,
                        'remote_id' => $ticket->id,
                        'send_on' => $ticket->updated_at,
                        'parent_id' => null
                    ]
                );
            } else {
                if ($rs->send_on == $ticket->updated_at) {
                    continue;
                }
                $this->ticket->update($rs->id, [
                    'id_categoria' => $this->getLocalCategory($ticket->category_id),
                    'cartao' => $ticket->cod,
                    'nome' => $field->nome,
                    'email' => $field->email,
                    'rg' => $field->rg,
                    'cpf' => $field->cpf,
                    'campoextra1' => $field->campoextra1,
                    'campoextra2' => $field->campoextra2,
                    'situacao' => $ticket->active,
                    'send_on' => $ticket->updated_at
                ]);
            }
        }
    }
    public function setRegister($sync)
    {
        $status = [
            1 => 'PS',
            2 => 'CI',
            3 => 'CB',
            4 => 'CR',
        ];

        foreach ($sync->data as $register) {
            $localRegister = $this->registry->where('remote_id', $register->id)->orWhere([
                'cartao' => $register->cod,
                'data_acesso' => $register->reading_at
            ])->first();
            if (!$localRegister) {
                $rs = $this->ticket->where([
                   'id_evento' => $this->eventId,
                   'cartao' => $register->cod
                ])->first();
                if ($rs) {
                    $this->registry->insert(
                    [
                        'id_pessoa' => $rs->id,
                        'id_evento' => $rs->id_evento,
                        'cartao' => $register->cod,
                        'data_acesso' => $register->reading_at,
                        'hora_acesso' => $register->reading_at,
                        'acao' => $status[$register->status_id],
                        'terminal' => $register->device_id,
                        'giro' => 0,
                        'remote_id' => $register->id
                    ]);
                }
            }
        }
    }
    public function setImage($sync)
    {
        foreach ($sync->data->images as $image) {
            $localImage = $this->photo->join('cartoes', 'cartoes.id = fotos.id_pessoas')->where([
                'cartoes.cartao'=> $image->cod,
                'criado_em' => $image->created_on
            ])->first();
            if (!$localImage) {
                $rs = $this->ticket->where([
                   'id_evento' => $this->eventId,
                   'cartao' => $image->cod
                ])->first();
                if ($rs && !empty($image->base64)) {
                    $photoimage = str_replace('data:image/jpeg;base64,', '', $image->base64);
                    $photoimage = str_replace('data:image/webp;base64,', '', $photoimage);
                    $photoimage = str_replace('data:image/png;base64,', '', $photoimage);
                    $this->photo->insert(
                    [
                        'id_pessoas' => $rs->id,
                        'foto' => base64_decode($photoimage),
                        'foto_mini',
                        'fotostr' => $image->base64,
                        'image',
                        'send_on' =>$image->created_on,
                        'criado_em' => $image->created_on
                    ]);
                }
            }
        }
    }

    private function getFields($ticketField)
    {
        $data = (object)[
            'nome' => null,
            'email' => null,
            'rg' => null,
            'cpf' => null,
            'campoextra1' => null,
            'campoextra2' => null,
        ];
        foreach ($ticketField as $value) {
            if (array_key_exists($value->field_id, $this->fields)) {
                $nomeCampo = $this->fields[$value->field_id];
                if ($nomeCampo == 'nome') {
                    $data->nome = $value->value;
                }
                if ($nomeCampo == 'email') {
                    $data->email = $value->value;
                }
                if ($nomeCampo == 'rg') {
                    $data->rg = $value->value;
                }
                if ($nomeCampo == 'cpf') {
                    $data->cpf = $value->value;
                }
                if ($nomeCampo == 'campoextra1') {
                    $data->campoextra1 = $value->value;
                }
                if ($nomeCampo == 'campoextra2') {
                    $data->campoextra2 = $value->value;
                }
            }
        }

        return $data;
    }

    private function getLocalCategory($remoteCategory)
    {
        $rs = $this->category->where('external_id', $remoteCategory)->first();
        if ($rs) {
            return $rs->id;
        }
        return null;
    }
}
