<?php
/*
 Create by Fernando Almeida<nando.falou@gmail.com>
*/
namespace App\Libraries;

class LibResponseJson {

    private $apiResult;
    private $apiError;

    public function __construct() {
        $this->apiResult = (object) [
                    "status" => true,
                    "message" => null
        ];
        $this->apiError = [];
    }

    public function setError($msg) {
        $this->apiError[] = $msg;
    }

    public function hasError() {
        if (!empty($this->apiError)) {
            return true;
        }
        return false;
    }

    public function setResult($result, $named = 'data') {
        $this->apiResult->{$named} = $result;
    }
    
    public function getError() {
        if ($this->hasError()) {
            return $this->apiError[0];
        } else {
            return false;
        }
    }

    public function getApiResult() {
        if ($this->hasError()) {
            $this->apiResult->status = false;
            $this->apiResult->message = $this->apiError[0];
        } else {
            $this->apiResult->status = true;
            $this->apiResult->message = null;
        }
        return $this->apiResult;
    }

}
