<?php

namespace App\Libraries;

use stdClass;

class LibJSDB
{

    private $path;
    private $data;
    private $jsonPrettyPrint;

    public function __construct($dbName, $jsonPrettyPrint = false)
    {
        $this->path = WRITEPATH . "uploads/{$dbName}.json";
        $this->jsonPrettyPrint = $jsonPrettyPrint;
        $this->init();
    }

    public function getData(array $where = null)
    {
        $rs = [];
        foreach ($this->data as $v) {
            if (!empty($where)) {
                $temp = $this->compareKeys($where, $v);
                if($temp) {
                    $rs[] = $temp;
                }
            } else {
                $rs[] = $v;
            }
        }

        return $rs;
    }

    public function getFirst(array $where = null)
    {
        $rs = [];
        foreach ($this->data as $v) {
            if (!empty($where)) {
                $temp = $this->compareKeys($where, $v);
                if($temp) {
                    $rs[] = $temp;
                }
            } else {
                $rs[] = $v;
            }
        }

        return !empty($rs)?$rs[0]:null;
    }

    public function insert($data) {
        $this->data[]=$data;
        $this->save();
    }

    public function updateData($where, $data) {
        foreach ($this->data as $v) {
            $temp = $this->compareKeys($where, $v);
            if($temp) {
                $v = $data;
            }
        }
        $this->save();
    }

    public function createOrUpdate($where, $data) {
        $is=false;
        foreach ($this->data as $k=>$v) {
            $temp = $this->compareKeys($where, $v);
            if($temp) {
                $this->data[$k]=$data;
                $is=true;
            }
        }
        
        
        if(!$is){
            $this->data[]=$data;
        }

        $this->save();
    }

    public function remove($where) {
        foreach ($this->data as $k => $v) {
            $temp = $this->compareKeys($where, $v);
            if($temp) {
                // array_splice($this->data, 1, 1)
                unset($this->data[$k]);
            }
        }
        $this->save();
    }

    private function init()
    {
        if (is_file($this->path)) {
            $this->data = json_decode(file_get_contents($this->path));
        } else {
            $this->data = [];
        }
    }

    private function compareKeys($where, $line)
    {
        foreach ($where as $k => $v) {
            if (property_exists($line, $k) && $line->$k == $v) {
                return $line;
            }
        }
        return null;
    }

    private function save() {
        if ($this->jsonPrettyPrint) {
            $data = json_encode($this->data, JSON_PRETTY_PRINT);
        } else {
            $data = json_encode($this->data);
        }
        file_put_contents($this->path, $data);
    }
}
