<?php

namespace App\Libraries;

use App\Models\TicketeiraEventoModel;
use App\Models\CategoryModel;
use App\Models\TicketModel;
use App\Models\EventModel;
use App\Models\RegistryModel;
use App\Models\DeliveryModel;
use App\Libraries\Sympla\Sympla;
use App\Libraries\Bora\Bora;
use CodeIgniter\CLI\CLI;
use stdClass;

class LibIntegrador
{

    private TicketeiraEventoModel $ticketeriaEvento;
    private Sympla $sympla;
    private TicketModel $ticket;
    private CategoryModel $category;
    private RegistryModel $registry;
    private DeliveryModel $delivery;
    private EventModel $event;
    private stdClass $monitor;
    private stdClass $data;
    private Bora $bora;

    public function __construct()
    {
        $this->ticketeriaEvento = new TicketeiraEventoModel();
        $this->ticket = new TicketModel();
        $this->category = new CategoryModel();
        $this->registry = new RegistryModel();
        $this->delivery = new DeliveryModel();
        $this->sympla = new Sympla();
        $this->event = new EventModel();
        $this->bora = new Bora();
        $this->monitor = (object) [
            'tickets' => (object) [
                'page' => 0,
                'totalPage' => 0,
                'totalTickets' => 0,
                'lastDate' => 0,
                'has_next' => true,
                'news' => 0,
                'updated' => 0,
                'noupdated' => 0,
                'fTotal' => 0,
                'fKey' => 0,
                'number' => 0,
                'name' => null,
            ],
            'checkin' => (object) [
                'key' => 0,
                'count' => 0,
                'number' => 0,
                'lista' => 0,
                'enviados' => 0
            ]
        ];
    }

    public function startSync($integrador)
    {
        $this->data = $integrador;
        $startSync = date('Y-m-d H:i:s');
        $this->ticketeriaEvento->update(
            $integrador->id,
            [
                'startSync' => $startSync,
                'endSync' => null,
                'statusSync' => 'iniciando varredura'
            ]
        );
        $this->sincSimpla($integrador, 'start');
    }

    public function startNewsSync($integrador)
    {
        $this->data = $integrador;
        $startSync = date('Y-m-d H:i:s');
        $this->ticketeriaEvento->update(
            $integrador->id,
            [
                'startSync' => $startSync,
                'endSync' => null,
                'statusSync' => 'iniciando varredura'
            ]
        );
        $this->sincSimpla($integrador, 'end');
    }

    public function checkinSinc($integrador)
    {
        $this->data = $integrador;
        $startSync = date('Y-m-d H:i:s');
        $this->ticketeriaEvento->update(
            $integrador->id,
            [
                'startSync' => $startSync,
                'endSync' => null,
                'statusSync' => 'iniciando checkin'
            ]
        );
        $this->sincSimplaCheckin($integrador);
    }

    public function getIntegradores()
    {
        return $this->ticketeriaEvento
            ->select('
                ticketeira_evento.id,
                ticketeira.id as ticketeira_id,
                ticketeira.nome as ticketeira,
                ticketeira.modulo,
                ticketeira_evento.evento_id,
                ticketeira_evento.token,
                ticketeira_evento.identify,
                ticketeira_evento.params,
                ticketeira_evento.startSync,
                ticketeira_evento.endSync,
                ticketeira_evento.statusSync
            ')
            ->join('ticketeira', 'ticketeira.id = ticketeira_evento.ticketeira_id')
            ->where([
                'ticketeira_evento.active' => 1,
                'ticketeira.ativo' => 1
            ])->findAll();
    }

    public function sincSimpla($integrador, $service)
    {
        CLI::write('|= iniciando ....===|');
        $this->sympla = new Sympla();
        $this->sympla->api->setToken($integrador->token);
        $this->sympla->api->setEventApi($integrador->identify);

        $this->monitor->tickets->page = 1;
        $this->monitor->tickets->news = 0;
        $this->monitor->tickets->updated = 0;
        $this->monitor->tickets->noupdated = 0;
        $this->monitor->tickets->name = 'Importa todos os registros';
        $this->display();
        if ($service == 'start') {
            $this->processaSympla();
        }

        if ($service == 'end') {
            $this->getLast();
        }
    }

    public function sincSimplaCheckin($integrador)
    {
        CLI::write('|= iniciando ....===|');
        $this->sympla = new Sympla();
        $this->sympla->api->setToken($integrador->token);
        $this->sympla->api->setEventApi($integrador->identify);

        $this->monitor->checkin->key = 0;
        $this->monitor->checkin->count = 0;
        $this->monitor->checkin->number = 0;
        $this->monitor->checkin->lista = 0;
        $this->monitor->checkin->enviado = 0;
        $this->displayChekin();

        $this->processaSymplaCheckin($integrador);
    }

    private function processaSympla()
    {

        $this->monitor->tickets->name = 'Importa todos os registros';
        $this->page();

        if ($this->monitor->tickets->has_next) {
            $this->monitor->tickets->page++;
        } else {
            $this->monitor->tickets->page = 1;
            $this->monitor->tickets->page = 1;
            $this->monitor->tickets->news = 0;
            $this->monitor->tickets->updated = 0;
            $this->monitor->tickets->noupdated = 0;
            sleep(0.5);
        }

        $this->processaSympla();
    }

    private function processaSymplaCheckin($integrador)
    {

        $this->monitor->checkin->name = 'Checkin * ';

        $limit = 300;
        $register = $this->registry->getUnsendedRegister($integrador->ticketeira_id, $limit);
        $rs = $this->registry->getCount($integrador->ticketeira_id);
        if (!empty($rs)) {
            $this->monitor->checkin->lista = $rs->qtd;
        }

        $dateNow = date('d/m/Y H:i:s');
        $this->monitor->checkin->count = count($register);
        if (!empty($register)) {
            $this->sendRegister($register);
        } else {
            $this->monitor->checkin->number = ' -- ';
            $this->monitor->checkin->key = 0;
            $this->monitor->checkin->count = 0;
            $this->monitor->checkin->lista = 0;
            $this->displayChekin();
        }
        sleep(2);
        $this->processaSymplaCheckin($integrador);
    }

    public function sendRegister($list)
    {
        foreach ($list as $key => $register) {
            $this->monitor->checkin->key = $key + 1;
            $this->monitor->checkin->number = $register->ticketeira_identify;

            try {
                $request = $this->sympla->api->checkinByTicketCode($register->ticketeira_identify);
            } catch (\Exception $e) {
                CLI::write("| ERROR:  - {$e->getMessage()}   ", 'dark_blue', 'red');
                $request = false;
            }

            if ($request) {
                if (is_object($request) && property_exists($request, 'data')) {
                    $this->registry->update($register->id, ['send_on' => date('Y-m-d H:i:s')]);
                    $this->monitor->checkin->enviados++;
                } else if (is_object($request) && property_exists($request, 'code') && $request->code === 113) {
                    $this->registry->update($register->id, ['send_on' => date('Y-m-d H:i:s')]);
                    $this->monitor->checkin->enviados++;
                }
            }
            $this->displayChekin();
        }
    }

    public function getLast()
    {
        $this->monitor->tickets->page = 1;
        $this->monitor->tickets->name = 'Importa registros novos';
        $this->page(1, true);

        $this->monitor->tickets->page = 1;
        $this->monitor->tickets->news = 0;
        $this->monitor->tickets->updated = 0;
        $this->monitor->tickets->noupdated = 0;

        sleep(1);

        $this->getLast();
    }

    private function display()
    {
        $dateT = date('d/m/Y H:i:s');
        CLI::clearScreen();
        CLI::write('|=====================================================================|');
        CLI::write("|=====   {$this->monitor->tickets->name}  ====   {$dateT}   ===|", 'red', 'yellow');
        CLI::write('|=====================================================================|' . "\n");
        CLI::showProgress($this->monitor->tickets->page, $this->monitor->tickets->totalPage);
        CLI::write('|=====================================================================|' . "\n");
        CLI::write("| Page: {$this->monitor->tickets->page} de {$this->monitor->tickets->totalPage} |", 'dark_blue', 'yellow');
        CLI::write('|=====================================================================|' . "\n");
        CLI::showProgress($this->monitor->tickets->fKey, $this->monitor->tickets->fTotal);
        CLI::write("| Item da Page: {$this->monitor->tickets->fKey} |", 'dark_blue', 'yellow');
        CLI::write("| Total da Page: {$this->monitor->tickets->fTotal} |");
        CLI::write("| Number: {$this->monitor->tickets->number} |");
        CLI::write("| Novos: {$this->monitor->tickets->news} |");
        CLI::write("| Atualizados: {$this->monitor->tickets->updated} |");
        CLI::write("| Sem atualizações: {$this->monitor->tickets->noupdated} |");
        CLI::write('|=====================================================================|' . "\n");
    }

    private function displayChekin()
    {
        $dateT = date('d/m/Y H:i:s');
        CLI::clearScreen();
        CLI::write('|=====================================================================|');
        CLI::write("|=====  Checkin Sympla ====  {$dateT}  =======|", 'red', 'yellow');
        CLI::write('|=====================================================================|' . "\n");
        CLI::showProgress($this->monitor->checkin->key, $this->monitor->checkin->count);
        CLI::write('|=====================================================================|' . "\n");
        CLI::write("| Number: {$this->monitor->checkin->number} |");
        CLI::write("| Item: {$this->monitor->checkin->key} de {$this->monitor->checkin->count} |");
        CLI::write("| Na fila: {$this->monitor->checkin->lista} |");
        CLI::write("| Total enviados: {$this->monitor->checkin->enviados} |");
        CLI::write('|=====================================================================|' . "\n");
    }

    private function page($page = 1, $last = false)
    {
        $data =  false;
        $params = [
            'page' => $this->monitor->tickets->page,
            'page_size' => 200,
            'cancelled_filter' => 'include',
        ];

        if ($last) {
            $params['field_sort'] = 'order_updated_date';
            $params['sort'] = 'DESC';
            try {
                $data = $this->sympla->api->getParticipantsByEvent($params);
            } catch (\Exception $e) {
                CLI::write("| ERROR:  - {$e->getMessage()}   ", 'dark_blue', 'red');
                $data = false;
            }
            $this->monitor->tickets->page = 1;
        } else {

            try {
                $data = $this->sympla->api->getParticipantsByEvent($params);
            } catch (\Exception $e) {
                CLI::write("| ERROR:  - {$e->getMessage()}   ", 'dark_blue', 'red');
                $data = false;
            }
            if (!empty($data)) {
                $pagination = $data->pagination;
                if (!$last) {
                    $this->monitor->tickets->page = $pagination->page;
                    $this->monitor->tickets->has_next = $pagination->has_next;
                    $this->monitor->tickets->totalPage = $pagination->total_page;
                    $this->monitor->tickets->totalTickets = $pagination->quantity;
                    $this->monitor->tickets->lastDate = date('d/m/Y H:i:s');
                }
            }
        }
        if (!empty($data)) {
            $this->processaDadosSympla($data->data);
        }
    }

    private function processaDadosSympla($data)
    {
        $sts = (object) [
            'novos' => 0,
            'updates' => 0,
            'non' => 0,
        ];

        $this->monitor->tickets->fTotal = count($data);
        foreach ($data as $key => $item) {
            $dataAc = $this->addCustonForm($item);
            $this->monitor->tickets->fKey = $key + 1;
            $this->monitor->tickets->number = $dataAc->access_code;
            $status = 0;
            if (property_exists($item, 'order_status')) {
                $status = $item->order_status == 'A' ? 1 : 0;
            }
            $ticket = (object) [
                'id_evento' => $this->data->evento_id,
                'id_categoria' => $dataAc->sector_id,
                'cartao' => $dataAc->access_code,
                'campoextra1' => $item->order_id,
                'campoextra2' => $item->ticket_name,
                'email' => $item->email,
                'nome' => trim((string) $item->first_name . ' ' . $item->last_name),
                'ticketeira_id' => $this->data->ticketeira_id,
                'ticketeira_identify' => $item->ticket_num_qr_code,
                'ticketeira_values' => json_encode($item),
                'ticketeira_updated_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'situacao' => $status,
                'mestre' => 0,
                // 'utilizado' => $item->checkin[0]->check_in ? 1 : 0,
                'send_on' => date('Y-m-d H:i:s'),
            ];

            $resp = $this->ticket->addOrInsert($ticket);
            if (!$resp->exists) {
                $this->monitor->tickets->news++;
            } else {
                $this->monitor->tickets->updated++;
            }
            // if (!$resp) {
            //     $this->monitor->tickets->noupdated++;
            // }

            if ($item->checkin[0]->check_in) {
                foreach ($item->checkin as $checkin) {
                    if ($checkin->check_in) {
                        $this->registry->addOnlyRegistry(
                            $resp->id,
                            $checkin->check_in_date
                        );
                    }
                }
            }
            $this->display();
        }
    }

    private function addCustonForm($item)
    {

        $dados = (object) [
            'sector_id' => null,
            'access_code' => null,
            'presentation_time' => null,
        ];

        $forms = $item->custom_form;

        if (!empty($form)) {
            foreach ($forms as $form) {
                if ($form->name === 'sector_name') {
                    $dados->sector_id = $this->category->getOrAdd($form->value);
                }
                if ($form->name === 'access_code') {
                    $dados->access_code = $form->value;
                }
                if ($form->name === 'presentation_time') {
                    $dados->presentation_time = $form->value;
                }
            }
        }

        if (empty($dados->sector_id)) {
            $dados->sector_id = $this->category->getOrAdd($item->ticket_name);
        }

        if (empty($dados->access_code)) {
            $dados->access_code = $item->ticket_num_qr_code;
        }

        if (empty($dados->presentation_time)) {
            $dados->presentation_time = date('Y-m-d H:i:s');
        }

        return $dados;
    }

    public function sendToBora()
    {
        $events = $this->event->findAll();
        if (!empty($events)) {
            foreach ($events as $event) {
                if (!empty($event->code)) {
                    $this->checkinSincBora($event);
                }
            }
        }
    }

    public function checkinSincBora($event)
    {
        $this->bora->api->setToken('c7311677-48ad-4d57-a427-47e27c339154');
        $this->bora->api->setEventApi($event->code);

        $this->processaBoraCheckin($event);
        $this->processaBoraEntrega($event);
    }

    private function processaBoraCheckin($event)
    {

        CLI::write('|= iniciando envio de checkin ===| '.$event->id. ' -('.$event->code.') ' . $event->evento);
        $this->monitor->checkin->name = 'Checkin * ';

        $limit = 3000;

        $register = $this->registry
            ->where([
                'id_evento' => $event->id,
                'acao' => 'PS'
            ])
            ->where('hora_acesso IS NULL', null, false)
            ->orderBy('data_acesso', 'desc')
            ->findAll($limit);

        if (!empty($register)) {
            CLI::write('|= enviando ' . count($register));
            $this->sendBoraRegister($register);
        } else {
            return null;
        }
        CLI::write('|= continuando..===| ');
        // $this->processaBoraCheckin($event);
    }

    private function processaBoraEntrega($event)
    {

        CLI::write('|= iniciando entrega ===| '.$event->id. ' -('.$event->code.') ' . $event->evento);
        $this->monitor->checkin->name = 'Entrega * ';

        $limit = 3000;

        $delivery = $this->delivery
            ->where([
                'id_evento' => $event->id,
                'acao' => 'PS'
            ])
            ->where('hora_acesso IS NULL', null, false)
            ->orderBy('data_acesso', 'desc')
            ->findAll($limit);
        
        if (!empty($delivery)) {
            CLI::write('|= enviando: ' . count($delivery));
            $this->sendBoraDelivery($delivery);
        } else {
            return null;
        }
        CLI::write('|= continuando..===| ');
        // $this->processaBoraCheckin($event);
    }

    public function sendBoraRegister($list)
    {
        $tickets = [];
        foreach ($list as $key => $register) {
            $tickets[] = (object)[
                'ticketNumber' => $register->cartao,
                'checkinDate' => $register->data_acesso,
            ];
        }
        $obj = (object) [
            'tickets' => $tickets
        ];
        try {
            $request = $this->bora->api->checkingBatch($obj);
        } catch (\Exception $e) {
            CLI::write("| ERROR:  - {$e->getMessage()}   ", 'dark_blue', 'red');
            $request = false;
        }

        if ($request) {
            if (is_object($request) && property_exists($request, 'data')) {
                $checkin = $request->data->checkin;
                $erros = $request->data->erros;

                foreach ($request->data->checkin as $checkin) {
                    $this->registry->where([
                        'cartao' => $checkin->ticketNumber,
                        'data_acesso' => $checkin->checkinDate,
                    ])
                        ->set(['hora_acesso' => $checkin->checkinDate])
                        ->update();
                }

                foreach ($request->data->erros as $erros) {
                    if ($erros->checkin == true) {
                        $this->registry
                            ->where([
                                'cartao' => $erros->ticketNumber,
                                'data_acesso' => $erros->checkinDate,
                            ])
                            ->set(['hora_acesso' => $erros->checkinDate])
                            ->update();
                    }
                }
            }
        }
    }

    public function sendBoraDelivery($list)
    {
        $tickets = [];
        foreach ($list as $key => $register) {
            $tickets[] = (object)[
                'ticketNumber' => $register->cartao,
                'checkinDate' => $register->data_acesso,
            ];
        }
        $obj = (object) [
            'tickets' => $tickets
        ];
        try {
            $request = $this->bora->api->deliveryBatch($obj);

        } catch (\Exception $e) {
            CLI::write("| ERROR:  - {$e->getMessage()}   ", 'dark_blue', 'red');
            $request = false;
        }

        if ($request) {
            if (is_object($request) && property_exists($request, 'data')) {
                $checkin = $request->data->checkin;
                $erros = $request->data->erros;

                foreach ($request->data->checkin as $checkin) {
                    $this->registry->where([
                        'cartao' => $checkin->ticketNumber,
                        'data_acesso' => $checkin->checkinDate,
                    ])
                        ->set(['hora_acesso' => $checkin->checkinDate])
                        ->update();
                }

                foreach ($request->data->erros as $erros) {
                    if ($erros->checkin == true) {
                        $this->delivery
                            ->where([
                                'cartao' => $erros->ticketNumber,
                                'data_acesso' => $erros->checkinDate,
                            ])
                            ->set(['hora_acesso' => $erros->checkinDate])
                            ->update();
                    }
                }
            }
        }
    }
}
