<?php

namespace App\Libraries;

use App\Models\TicketModel;
use App\Models\EventModel;
use App\Models\RegistryModel;
use App\Models\CategoryModel;
use App\Models\PhotoModel;
use App\Models\GroupItemModel;
use App\Models\UserModel;
use App\Models\ImportModel;
use App\Models\ImportCategoryModel;

use stdClass;
use CodeIgniter\CLI\CLI;

class LibImportCredenciart
{

    private TicketModel $ticket;
    private EventModel $event;
    private CategoryModel $category;
    private RegistryModel $register;
    private PhotoModel $photo;
    private GroupItemModel $grupoItem;
    private UserModel $user;
    private ImportModel $import;
    private ImportCategoryModel $importCategory;

    public function __construct()
    {
        $this->ticket = new TicketModel();
        $this->event = new EventModel();
        $this->category = new CategoryModel();
        $this->register = new RegistryModel();
        $this->photo = new PhotoModel();
        $this->grupoItem = new GroupItemModel();
        $this->user = new UserModel();
        $this->import = new ImportModel();
        $this->importCategory = new ImportCategoryModel();
    }

    public function hasFile()
    {
        return $file = $this->import->where([
            'processado' => 'N',
            'ticketeira_id' => 2,
            'import_data' => null,
        ])->first();
    }

    public function importarArquivo($importFile)
    {
        $this->import->update($importFile->id, [
            'import_data' => 'start'
        ]);

        $fileText = WRITEPATH . '/' . $importFile->filetext;
        $lines = 0;
        if (is_file($fileText)) {
            $files = new \SplFileObject($fileText);
            while ($files->valid()) $files->fgets();
            $lines = ($files->key());
        }

        $file = fopen($fileText, "r");
        $spl = (object) [
            'index' => 0,
            'active' => 0,
            'inactive' => 0,
            'proccess' => 0,
        ];

        // name;image;company;code;access;prints;type;createdBy;createdDate;status


        while (($filedata = fgetcsv($file, 1000, ";")) !== FALSE) {

            if (
                is_array($filedata)
                && $spl->index > 0
                && count($filedata) >= 9
                && !empty($filedata[3])
            ) {
                $spl->active++;

                // CLI::write("| {$spl->index} - {$filedata[3]}   ", 'dark_blue', 'red'); 
                $data = [
                    'name' => $filedata[0],
                    'image' => $filedata[1],
                    'company' => $filedata[2],
                    'code' => $filedata[3],
                    'access' => $filedata[4],
                    'prints' => $filedata[5],
                    'type' => $filedata[6],
                    'createdBy' => $filedata[7],
                    'createdDate' => $filedata[8],
                    'status' => $filedata[9],
                ];

                CLI::clearScreen();
                CLI::showProgress($spl->index, $lines);
                CLI::write('|=====================================================================|');
                CLI::write("| UPDATE: tickets {$filedata[3]} | {$filedata[0]}      |", 'dark_blue', 'yellow');
                CLI::write('|=====================================================================|');

                CLI::write('|=====================================================================|');

                if ($this->updateTicket($data)) {
                    $spl->proccess++;
                }
            } else {
                $spl->inactive++;
            }
            $spl->index++;
        }
        fclose($file);

        $this->import->update($importFile->id, [
            'import_data' => 'finish',
            'processado' => 'Y'
        ]);

        return $spl;
    }

    private function updateTicket($arData)
    {
        $sts = false;
        $ticket = $this->ticket->where([
            'cartao' => $arData['code']
        ])->first();


        if ($ticket) {

            if (
                strcmp((string) $arData['name'], (string) $ticket->nome) != 0 ||
                strcmp((string) $arData['company'], (string) $ticket->campoextra1) != 0 ||
                strcmp((string) $arData['type'], (string) $ticket->campoextra2) != 0
            ) {
                // **name;image;**company; **code;access;prints;type;createdBy;createdDate;status
                $data = [
                    'nome' => $arData['name'],
                    'campoextra1' => $arData['company'],
                    'campoextra2' => $arData['type'],
                    'updated_at' => date('Y-m-d H:i:s'),
                    'send_on' => null,
                ];

                try {
                    $this->ticket->update($ticket->id, $data);
                    $sts = true;
                } catch (\Exception $e) {
                    CLI::write("| ERROR:  - {$e->getMessage()}   ", 'dark_blue', 'red');
                    $sts = false;
                }
            }

            if (!empty($arData['image'])) {
                try {
                    $this->updateImage($ticket, $arData['image']);
                } catch (\Exception $e) {
                    CLI::write("| ERROR IMAGE:  - {$e->getMessage()}   ", 'dark_blue', 'red');
                    $sts = false;
                }
            }

        } else {
            $sts = false;
        }
        return $sts;
    }

    private function updateImage($ticket, $b64Image)
    {
        $image = str_replace('data:image/jpeg;base64,', '', $b64Image);
        $image = str_replace('data:image/png;base64,', '', $image);
        $image = str_replace('data:image/webp;base64,', '', $image);

        $data = [
            'id_pessoas' => $ticket->id,
            'foto' => base64_decode($image),
            'send_on' => null
        ];

        $ticketImage = $this->photo->where('id_pessoas', $ticket->id)->first();
        if ($ticketImage) {
            $this->photo->update($ticketImage->id, $data);
        } else {
            $this->photo->save($data);
        }
    }
}
