<?php

namespace App\Libraries;
use App\Models\PhotoModel;
use App\Models\TicketModel;

use stdClass;

class LibImage
{

    private PhotoModel $photo;
    private TicketModel $ticket;
    
    public function __construct()
    {
        $this->photo = new PhotoModel();
        $this->ticket = new TicketModel();
    }

    public function getImage($ticketId)
    {
        $result = $this->ticket->find((int)$ticketId);
        
        if ($result) {
            $rsPhoto = $this->photo->where('id_pessoas', $result->id)->first();
            if ($rsPhoto && !empty($rsPhoto->foto)) {
                return base64_encode($rsPhoto->foto);
            }
        }

        return null;
    }

    public function saveUrlImage($ticketId, $linkImage)
    {
        $client = \Config\Services::curlrequest();
        $response = $client->request('GET', $linkImage);
        $bin = $this->content($response);
       
        if (!empty($bin)) {
            return $this->saveBase64Image(
                $ticketId,
                base64_encode($bin)
            );
        }
    }

    public function saveBase64Image($ticketId, $base64Image)
    {
        $result = $this->ticket->find((int)$ticketId);
        
        if ($result && !empty($base64Image)) {
            $image = $this->getImageFromBase64($base64Image);

            $data = [
                'id_pessoas'=> $result->id,
                'foto' => base64_decode($image),
                'send_on'=>null
            ];

            $rsPhoto = $this->photo->where('id_pessoas', $result->id)->first();

            if ($rsPhoto) {
                $this->photo->update($rsPhoto->id, $data);
            } else {
                $this->photo->save($data);
            }

            return true;
        }
        return false;
    }

    private function getImageFromBase64($base64encode)
    {
        if (strstr($base64encode, 'data:image/gif')) {
            $base64encode= (str_replace('data:image/gif;base64,', '', $base64encode));
        }

        if (strstr($base64encode, 'data:image/png')) {
            $base64encode = (str_replace('data:image/png;base64,', '', $base64encode));
        }

        if (strstr($base64encode, 'data:image/jpeg')) {
            $base64encode = (str_replace('data:image/jpeg;base64,', '', $base64encode));
        }

        if (strstr($base64encode, 'data:image/webp')) {
            $base64encode = (str_replace('data:image/webp;base64,', '', $base64encode));
        }

        return $base64encode;
    }

    public function content($request)
    {
        $body = '';
        $encoding = trim($request->getHeaderLine('Content-Encoding'));
        
        if ($encoding === 'gzip') {
            $body = gzdecode($request->getBody());
        } else {
            $body = $request->getBody();
        }
        
        $type = trim($request->getHeaderLine('Content-Type'));
        if (strpos($type, 'json')) {
            $body = json_decode($body);
        }
        return $body;
    }
}