<?php

namespace App\Libraries;

use App\Models\TicketModel;
use App\Models\DeviceModel;
use App\Models\RegistryModel;
use App\Models\TicketeiraEventoModel;
use App\Models\Ihx\IhxIngressoModel;
use App\Models\Ihx\IhxEventoModel;
use App\Models\Ihx\IhxRotaModel;
use App\Models\Ihx\IhxTipoIngressoModel;
use App\Models\Ihx\IhxAcessoModel;
use App\Libraries\Sympla\Sympla;
use App\Libraries\Bora\Bora;
use CodeIgniter\Database\RawSql;
use CodeIgniter\CLI\CLI;
use stdClass;

class LibIhxIntegrador
{

    private TicketModel $oneTicket;
    private IhxAcessoModel $ihx_acesso;
    private RegistryModel $oneRegistry;
    private TicketeiraEventoModel $ticketeriaEvento;
    private IhxTipoIngressoModel $tipoIngresso;
    private Sympla $sympla;
    private Bora $bora;
    private IhxIngressoModel $ticket;
    private IhxEventoModel $event;
    private IhxRotaModel $rotaIngresso;
    private DeviceModel $device;
    private stdClass $monitor;
    private int $eventId;
    private stdClass $data;
    private stdClass $integrador;
    private array $rota;
    private array $category;
    private int $limit;
    private int $integradorId;

    public function __construct()
    {
        $this->oneTicket = new TicketModel();
        $this->oneRegistry = new RegistryModel();
        $this->ticketeriaEvento = new TicketeiraEventoModel();
        $this->event = new IhxEventoModel();
        $this->tipoIngresso = new IhxTipoIngressoModel();
        $this->ticket = new IhxIngressoModel();
        $this->rotaIngresso = new IhxRotaModel();
        $this->ihx_acesso = new IhxAcessoModel();
        $this->device = new DeviceModel();
        $this->sympla = new Sympla();
        $this->bora = new Bora();
        $this->rota = [];
        $this->category = [];
        $this->limit = 5000;
        $this->monitor = (object) [
            'tickets' => (object) [
                'page' => 0,
                'totalPage' => 0,
                'totalTickets' => 0,
                'lastDate' => 0,
                'has_next' => true,
                'news' => 0,
                'updated' => 0,
                'noupdated' => 0,
                'fTotal' => 0,
                'fKey' => 0,
                'number' => 0,
                'name' => null,
            ],
            'checkin' => (object) [
                'key' => 0,
                'count' => 0,
                'number' => 0,
                'lista' => 0,
                'enviados' => 0
            ]
        ];

        $this->eventId = $this->event->getFirstId();
    }

    public function startSync($integrador)
    {
        $this->data = $integrador;
        $startSync = date('Y-m-d H:i:s');
        $this->integradorId = $integrador->id;
             $this->ticketeriaEvento->update(
            $integrador->id,
            [
                'startSync' => $startSync,
                'endSync' => null,
                'statusSync' => 'iniciando varredura'
            ]
        );
              $this->sincOnline($integrador, 'start');
    }

    public function startNewsSync($integrador)
    {
        $this->data = $integrador;
        $startSync = date('Y-m-d H:i:s');
        $this->integradorId = $integrador->id;
        $this->ticketeriaEvento->update(
            $integrador->id,
            [
                'startSync' => $startSync,
                'endSync' => null,
                'statusSync' => 'iniciando varredura'
            ]
        );
        $this->sincOnline($integrador, 'end');
    }

    public function checkinSinc($integrador)
    {
        $this->data = $integrador;
        $startSync = date('Y-m-d H:i:s');
        $this->ticketeriaEvento->update(
            $integrador->id,
            [
                'startSync' => $startSync,
                'endSync' => null,
                'statusSync' => 'iniciando checkin'
            ]
        );
        $this->sincOnlineCheckin($integrador);
    }

    public function getIntegradores()
    {
        return $this->ticketeriaEvento
            ->select('
                ticketeira_evento.id,
                ticketeira.id as ticketeira_id,
                ticketeira.nome as ticketeira,
                ticketeira.modulo,
                eventos.data_inicio,
                ticketeira_evento.evento_id,
                ticketeira_evento.token,
                ticketeira_evento.identify,
                ticketeira_evento.params,
                ticketeira_evento.startSync,
                ticketeira_evento.endSync,
                ticketeira_evento.statusSync
            ')
            ->join('ticketeira', 'ticketeira.id = ticketeira_evento.ticketeira_id')
            ->join('eventos', 'eventos.id = ticketeira_evento.evento_id')
            ->where([
                'ticketeira_evento.active' => 1,
                'ticketeira.ativo' => 1
            ])->findAll();
    }

    public function sincOnline($integrador, $service)
    {
        $this->integrador = $integrador;

        CLI::write('|= iniciando ....==| ' . $this->integrador->ticketeira . ' ====');

        if ($this->integrador->modulo == 'boratickets') {
            $this->bora->api->setToken($integrador->token);
            $this->bora->api->setEventApi($integrador->identify);
        }

        if ($this->integrador->modulo == 'sympla') {
            $this->sympla->api->setToken($integrador->token);
            $this->sympla->api->setEventApi($integrador->identify);
        }
        $this->monitor->tickets->page = 1;
        $this->monitor->tickets->news = 0;
        $this->monitor->tickets->updated = 0;
        $this->monitor->tickets->noupdated = 0;
        $this->monitor->tickets->name = 'Importa todos os registros';
        $this->display();
        if ($service == 'start') {
            $this->ticket->iniciaSts();
            $this->processaOnline(true);
        }

        if ($service == 'end') {
            $this->getLast();
        }
    }

    public function sincOnlineCheckin($integrador)
    {
        $this->integrador = $integrador;
        CLI::write('|= iniciando ....===| ' . $this->integrador->modulo);
        sleep(3);
        if ($this->integrador->modulo == 'boratickets') {
            $this->bora->api->setToken($integrador->token);
            $this->bora->api->setEventApi($integrador->identify);
        }

        if ($this->integrador->modulo == 'sympla') {
            $this->sympla->api->setToken($integrador->token);
            $this->sympla->api->setEventApi($integrador->identify);
        }

        $this->monitor->checkin->key = 0;
        $this->monitor->checkin->count = 0;
        $this->monitor->checkin->number = 0;
        $this->monitor->checkin->lista = 0;
        $this->monitor->checkin->enviado = 0;
        $this->displayChekin();

        $this->processaOnlineCheckin($integrador);
    }

    private function processaOnline($started = false)
    {

        if($started) {
            $this->ticket->iniciaSts();
        }

        $this->monitor->tickets->name = 'Importa todos os registros';
        $this->page();

        if ($this->monitor->tickets->has_next) {
            $this->monitor->tickets->page++;
        } else {
            if (!$started) {
                $this->ticket->finalizaSts();
            }
            $started = true;
            $this->monitor->tickets->page = 1;
            $this->monitor->tickets->page = 1;
            $this->monitor->tickets->news = 0;
            $this->monitor->tickets->updated = 0;
            $this->monitor->tickets->noupdated = 0;
            sleep(1);
            return false;
        }

        $this->processaOnline(false);
    }

    private function processaOnlineCheckin($integrador)
    {

        $this->monitor->checkin->name = 'Checkin * ';

        $limit = 300;

        $register = $this->ticket
            ->where(['utilizado' => 1, 'evt_sympla_sended_on' => null])
            ->where('evt_sympla_id IS NOT NULL', null, false)
            ->findAll($limit);

        $rs = $this->ticket
            ->select(
                'count(DISTINCT id) as qtd'
            )
            ->where(['utilizado' => 1, 'evt_sympla_sended_on' => null])
            ->where('evt_sympla_id IS NOT NULL', null, false)
            ->get()->getFirstRow();

        if (!empty($rs)) {
            $this->monitor->checkin->lista = $rs->qtd;
        }

        $dateNow = date('d/m/Y H:i:s');

        $this->monitor->checkin->count = count($register);
        if (!empty($register)) {
            $this->sendRegister($register);
        } else {
            $this->monitor->checkin->number = ' -- ';
            $this->monitor->checkin->key = 0;
            $this->monitor->checkin->count = 0;
            $this->monitor->checkin->lista = 0;
            $this->displayChekin();
        }
        sleep(2);
        $this->processaOnlineCheckin($integrador);
    }

    public function sendRegister($list)
    {
        foreach ($list as $key => $register) {
            $this->monitor->checkin->key = $key + 1;
            $this->monitor->checkin->number = $register->evt_sympla_ticket_number;

            if ($this->integrador->modulo == 'boratickets') {
                try {
                    $request = $this->bora->api->checkinByTicketCode($register->evt_sympla_ticket_number);
                } catch (\Exception $e) {
                    CLI::write("| ERROR:  - {$e->getMessage()}   ", 'dark_blue', 'red');
                    $request = false;
                }
            }

            if ($this->integrador->modulo == 'sympla') {
                try {
                    $request = $this->sympla->api->checkinByTicketCode($register->evt_sympla_ticket_number);
                } catch (\Exception $e) {
                    CLI::write("| ERROR:  - {$e->getMessage()}   ", 'dark_blue', 'red');
                    $request = false;
                }
            }

            if ($request) {
                if (is_object($request) && property_exists($request, 'data')) {
                    $this->ticket->update($register->id, ['evt_sympla_sended_on' => date('Y-m-d H:i:s')]);
                    $this->monitor->checkin->enviados++;
                } else if (is_object($request) && property_exists($request, 'code') && $request->code === 113) {
                    $this->ticket->update($register->id, ['evt_sympla_sended_on' => date('Y-m-d H:i:s')]);
                    $this->monitor->checkin->enviados++;
                }
            }

            $this->displayChekin();
        }
    }

    public function getLast()
    {
        $this->monitor->tickets->page = 1;
        $this->monitor->tickets->name = 'Importa registros novos';
        $this->page(1, true);

        $this->monitor->tickets->page = 1;
        $this->monitor->tickets->news = 0;
        $this->monitor->tickets->updated = 0;
        $this->monitor->tickets->noupdated = 0;

        // sleep(1);

        // $this->getLast();
    }

    private function display()
    {
        $dateT = date('d/m/Y H:i:s');
        CLI::clearScreen();
        CLI::write('|=====================================================================|');
        CLI::write("|=====  {$this->integradorId} | {$this->monitor->tickets->name}  ====   {$dateT}   ===|", 'red', 'yellow');
        CLI::write('|=====================================================================|' . "\n");
        CLI::showProgress($this->monitor->tickets->page, $this->monitor->tickets->totalPage);
        CLI::write('|=====================================================================|' . "\n");
        CLI::write("| Page: {$this->monitor->tickets->page} de {$this->monitor->tickets->totalPage} |", 'dark_blue', 'yellow');
        CLI::write('|=====================================================================|' . "\n");
        CLI::showProgress($this->monitor->tickets->fKey, $this->monitor->tickets->fTotal);
        CLI::write("| Item da Page: {$this->monitor->tickets->fKey} |", 'dark_blue', 'yellow');
        CLI::write("| Total da Page: {$this->monitor->tickets->fTotal} |");
        CLI::write("| Number: {$this->monitor->tickets->number} |");
        CLI::write("| Novos: {$this->monitor->tickets->news} |");
        CLI::write("| Atualizados: {$this->monitor->tickets->updated} |");
        CLI::write("| Sem atualizações: {$this->monitor->tickets->noupdated} |");
        CLI::write('|=====================================================================|' . "\n");
    }

    private function displayChekin()
    {
        $dateT = date('d/m/Y H:i:s');
        CLI::clearScreen();
        CLI::write('|=====================================================================|');
        CLI::write("|=====  Checkin Sympla ====  {$dateT}  =======|", 'red', 'yellow');
        CLI::write('|=====================================================================|' . "\n");
        CLI::showProgress($this->monitor->checkin->key, $this->monitor->checkin->count);
        CLI::write('|=====================================================================|' . "\n");
        CLI::write("| Number: {$this->monitor->checkin->number} |");
        CLI::write("| Item: {$this->monitor->checkin->key} de {$this->monitor->checkin->count} |");
        CLI::write("| Na fila: {$this->monitor->checkin->lista} |");
        CLI::write("| Total enviados: {$this->monitor->checkin->enviados} |");
        CLI::write('|=====================================================================|' . "\n");
    }

    private function page($page = 1, $last = false)
    {
        $data =  false;

        $tpage = 200;
        if ($this->integrador->modulo == 'boratickets') {
            $tpage = 1000;
        }

        $params = [
            'page' => $this->monitor->tickets->page,
            'page_size' => $tpage,
            'cancelled_filter' => 'include',
        ];

        if ($last) {
            $params['field_sort'] = 'order_updated_date';
            $params['sort'] = 'DESC';
            if ($this->integrador->modulo == 'boratickets') {
                try {
                    $data = $this->bora->api->getParticipantsByEvent($params);
                } catch (\Exception $e) {
                    CLI::write("| ERROR:  - {$e->getMessage()}   ", 'dark_blue', 'red');
                    $data = false;
                }
            }
            if ($this->integrador->modulo == 'sympla') {
                try {
                    $data = $this->sympla->api->getParticipantsByEvent($params);
                } catch (\Exception $e) {
                    CLI::write("| ERROR:  - {$e->getMessage()}   ", 'dark_blue', 'red');
                    $data = false;
                }
            }

            $this->monitor->tickets->page = 1;
        } else {

            if ($this->integrador->modulo == 'boratickets') {
                try {
                    $data = $this->bora->api->getParticipantsByEvent($params);
                } catch (\Exception $e) {
                    CLI::write("| ERROR:  - {$e->getMessage()}   ", 'dark_blue', 'red');
                    $data = false;
                }
            }
            if ($this->integrador->modulo == 'sympla') {
                try {
                    $data = $this->sympla->api->getParticipantsByEvent($params);
                } catch (\Exception $e) {
                    CLI::write("| ERROR:  - {$e->getMessage()}   ", 'dark_blue', 'red');
                    $data = false;
                }
            }

            if (!empty($data)) {
                $pagination = $data->pagination;
                if (!$last) {
                    $this->monitor->tickets->page = $pagination->page;
                    $this->monitor->tickets->has_next = $pagination->has_next;
                    $this->monitor->tickets->totalPage = $pagination->total_page;
                    $this->monitor->tickets->totalTickets = $pagination->quantity;
                    $this->monitor->tickets->lastDate = date('d/m/Y H:i:s');
                }
            }
        }
        if (!empty($data)) {
            $this->processaDadosOnline($data->data);
        }
    }

    private function processaDadosOnline($data)
    {
        $sts = (object) [
            'novos' => 0,
            'updates' => 0,
            'non' => 0,
        ];

        $this->monitor->tickets->fTotal = count($data);
        foreach ($data as $key => $item) {
            $dataAc = $this->addCustonForm($item);
            if (empty($dataAc->area_id)) {
                $dataAc->area_id = $this->addRotaArray($item->ticket_name);
            }
            if (empty($dataAc->area_name)) {
                $dataAc->area_name = $item->ticket_name;
            }

            $this->monitor->tickets->fKey = $key + 1;
            $this->monitor->tickets->number = $dataAc->access_code;
            $status = 0;
            if (property_exists($item, 'order_status')) {
                $status = $item->order_status == 'A' ? 1 : 0;
            }

            $ticket = (object) [
                'evento_id' => $this->eventId,
                'codigoingresso' => $dataAc->access_code,
                'evt_sympla_ticket_number' => $item->ticket_num_qr_code,
                'evt_sympla_sended_on' => null,
                'evt_sympla_id' => $item->id,
                'area_id' => $dataAc->area_id,
                'tipoingresso_id' => $this->addCategoriArray($dataAc->area_name),
                'acessotipocontrolador' => 8,
                'dtevento' => $dataAc->presentation_time,
                'utilizado' => $item->checkin[0]->check_in ? 1 : 0,
                'ativo' => $status,
                'lote' => trim((string) $item->order_id),
                'identificacao' => trim((string) $item->first_name . ' ' . $item->last_name),
                'coletar' => 0,
                'sts_import' => 1,
            ];

            $resp = $this->ticket->addOrInsert($ticket);
               if ($resp == 1) {
                $this->monitor->tickets->news++;
            } else {
                $this->monitor->tickets->updated++;
            }

            $this->display();
        }
    }

    private function addCustonForm($item)
    {

        $dados = (object) [
            'area_id' => null,
            'area_name' => null,
            'access_code' => $item->ticket_num_qr_code,
            'presentation_time' => null
        ];

        $forms = $item->custom_form;

        if (!empty($forms)) {
            foreach ($forms as $form) {
                if ($form->name === 'sector_name') {
                    $dados->area_id = $this->addRotaArray($form->value);
                    $dados->area_name = $form->value;
                }
                if ($form->name === 'access_code') {
                    $dados->access_code = $form->value;
                }
                if ($form->name === 'presentation_time') {
                    $dados->presentation_time = $form->value;
                }
            }
        }

        if (empty($dados->access_code)) {
            $dados->access_code = $item->ticket_num_qr_code;
        }

        if (empty($dados->area_id)) {
            $dados->area_id = $this->addRotaArray('UNICO');
            $dados->area_name = 'UNICO';
        }

        if (empty($dados->presentation_time)) {
            $dados->presentation_time = date('Y-m-d H:i:s', strtotime($this->integrador->data_inicio));
        }

        return $dados;
    }

    private function addCategoriArray($valor)
    {
        $idx = array_search($valor, array_column($this->category, 'descricao'));
        if ($idx === false) {
            $id = $this->tipoIngresso->addTipo($valor);
            $this->category[] = (object) [
                'id' => $id,
                'descricao' => $valor,
            ];
            return $id;
        } else {
            return $this->category[$idx]->id;
        }
    }

    private function addRotaArray($valor)
    {
        $idx = array_search($valor, array_column($this->rota, 'rotadescricao'));
        if ($idx === false) {
            $id = $this->rotaIngresso->addRota($valor);
            $this->rota[] = (object) [
                'id' => $id,
                'rotadescricao' => $valor,
            ];
            return $id;
        } else {
            return $this->rota[$idx]->id;
        }
    }

    public function sinc()
    {
        $this->oneToIhxTickets();
        //$this->oneToIhxRegister();
        //$this->ihxToOneRegister();

        $db = \Config\Database::connect('default');
        $db->query('update marcacao, cartoes set 
                    marcacao.id_pessoa = cartoes.id 
                    where marcacao.cartao = cartoes.cartao');

        $this->sinc();
    }

    public function leitura()
    {
        //$this->oneToIhxTickets();
        $this->oneToIhxRegister();
        $this->ihxToOneRegister();

        $db = \Config\Database::connect('default');
        $db->query('update marcacao, cartoes set 
                    marcacao.id_pessoa = cartoes.id 
                    where marcacao.cartao = cartoes.cartao');

        $this->leitura();
    }

    private function ihxToOneRegister()
    {
        $limit = $this->limit;
        $where = [
            'acessorealizado' => 1
        ];

        $qtd = $this->ihx_acesso
            ->select(
                'count(DISTINCT id) as qtd'
            )
            ->where($where)
            ->get()->getFirstRow();
        $pages = (int) ($qtd->qtd / $limit) + 1;

        for ($t = 0; $t < $pages; $t++) {
            $offset = ($t) * $limit;

            $cart = $this->ihx_acesso
                ->where($where)
                ->orderBy('id', 'desc')
                ->limit($limit, $offset)
                ->get()->getResult();

            $this->monitor->checkin->key = $t;
            $this->monitor->checkin->count = $pages;
            $this->displaySinc('ENVIANDO LEITURAS');

            foreach ($cart as $key => $registry) {
                $cracha = ltrim($registry->cracha, '0');
                $this->monitor->checkin->enviados = $key;
                $this->monitor->checkin->number = $cracha;
                $this->displaySinc('ENVIANDO LEITURAS');

                $rawSQL = "TRIM(LEADING '0' FROM '{$cracha}') = TRIM(LEADING '0' FROM cartao)";
                // ->where(new RawSql('now() BETWEEN eventos.data_inicio and eventos.data_fim'))
                $ticket = $this->oneTicket
                ->where(new RawSql($rawSQL ))
                ->first();

                $terminal = $this->device
                    ->where('terminal_pin', $registry->equipamentoid)
                    ->first();

                if (!empty($ticket)) {
                    $oneRegistry = [
                        'id_evento' => $ticket->id_evento,
                        'cartao' => $ticket->cartao,
                        'id_pessoa' => $ticket->id,
                        'data_acesso' => $registry->acessodatahora,
                        'acao' => $registry->acessoliberado == 1 ? 'PS' : 'CB',
                        'terminal' => !empty($terminal) ? $terminal->id:null,
                        'giro' => 'E'
                    ];
                    
                    $resp = $this->oneRegistry->where([
                        'cartao' => $oneRegistry['cartao'],
                        'data_acesso' => $oneRegistry['data_acesso'],
                        'acao' => $oneRegistry['acao']
                    ])->first();

                    if (empty($resp)) {
                        $this->oneRegistry->insert($oneRegistry);
                    }
                }
            }
            $this->displaySinc('ENVIANDO LEITURAS');
        }
    }

    private function oneToIhxRegister()
    {
        $limit = $this->limit;
        $qtd = $this->oneRegistry
            ->select(
                'count(DISTINCT id) as qtd'
            )
            ->where('acao', 'PS')
            ->get()->getFirstRow();
        $pages = (int) ($qtd->qtd / $limit) + 1;

        for ($t = 0; $t < $pages; $t++) {
            $offset = ($t) * $limit;

            $cart = $this->oneRegistry
                ->select('
                    marcacao.id ,
                    marcacao.serial_id ,
                    marcacao.id_pessoa ,
                    marcacao.id_evento ,
                    marcacao.cartao ,
                    marcacao.data_acesso ,
                    marcacao.acao ,
                    marcacao.terminal,
                    terminal.terminal_pin
                ')
                ->join('terminal', 'terminal.id = marcacao.terminal', 'left')
                ->orderBy('marcacao.id', 'asc')
                ->where('marcacao.acao', 'PS')
                ->groupBy('marcacao.id')
                ->limit($limit, $offset)
                ->get()->getResult();

            $this->monitor->checkin->key = $t;
            $this->monitor->checkin->count = $pages;
            $this->displaySinc('BAIXANDO LEITURAS');
		
            $acessodescricao = 'Acesso permitido para entrada';
            foreach ($cart as $key => $registry) {
				$this->displaySinc('BAIXANDO LEITURAS');
                $this->monitor->checkin->enviados = $key;
                $this->monitor->checkin->number = $registry->cartao;
                $cracha = sprintf("%'016s", $registry->cartao);
                
                $rs = $this->ihx_acesso->where([
                    'acessodatahora' => $registry->data_acesso,
                    'acessoliberado' => 1,
                    'cracha' => $cracha
                ])->first();
                
                $tt = $this->ticket->like('codigoingresso' ,$cracha)->first();
				if (!empty($tt)) {
					$this->ticket->update($tt->id, ['utilizado' => 1]);
				}
				
                if (empty($rs)) {
                    $this->monitor->checkin->enviados = $key;
                    $this->monitor->checkin->number = $registry->cartao;
                    $this->displaySinc('BAIXANDO LEITURAS');
                    $this->ihx_acesso->insert(
                        [
                            'acessoinvalido' => 0,
                            'acessoliberado' => 1,
                            'acessodatahora' => $registry->data_acesso,
                            'acessodescricao' => $acessodescricao,
                            'equipamentotipoterminal' => 'CATRACA',
                            'acessosentido' => 'E',
                            'acessorealizado' => 1,
                            'acessorefeitorio' => 0,
                            'acessocontrolador' => 1,
                            'visitaid' => null,
                            'cracha' => $cracha,
                            'matricula' => 0,
                            'pessoaid' => 999999999,
                            'pessoanome' => 'INGRESSO LIBERADO',
                            'visitante' => 1,
                            'isveiculo' => null,
                            'empresaid' => 1,
                            'estruturaid' => 1,
                            'setorid' =>  !empty($registry->terminal_pin) ? $registry->terminal_pin : '200',
                            'empresanome' => 'GUARDI',
                            'estruturadescricao' => 'EVENTO',
                            'setordescricao' => !empty($registry->terminal_pin) ? $registry->terminal_pin : '200',
                            'equipamentoid' => !empty($registry->terminal_pin) ? $registry->terminal_pin : '200',
                            'equipamentodescricao' => !empty($registry->terminal_pin) ? $registry->terminal_pin : '200',
                            'equipamentotcpip' => '127.0.0.1',
                            'equipamentomacaddress' => '127.0.0.1',
                            'equipamentoserverhost' => '127.0.0.1',
                            'comando' => '0',
                            'str_enviado' => '01;02;E;05;<< E N T R A D A;INGRESSO LIBERAD;                ',
                            'registroonline' => 1,
                            'acessotipificacao' => null
                        ]
                    );
                }
            }
        }
    }

    private function oneToIhxTickets()
    {
        $limit = $this->limit;
        $qtd = $this->oneTicket
            ->select(
                'count(DISTINCT id) as qtd'
            )
            ->get()->getFirstRow();
        $pages = (int) ($qtd->qtd / $limit) + 1;

        for ($t = 0; $t < $pages; $t++) {
            $offset = ($t) * $limit;
            $cart = $this->oneTicket->getDataIhx()
                ->orderBy('cartoes.id', 'asc')
                ->limit($limit, $offset)
                ->get()->getResult();

            $this->monitor->checkin->key = $t;
            $this->monitor->checkin->count = $pages;
            $this->displaySinc('BAIXANDO TICKETS');
            foreach ($cart as $key => $ingresso) {
                $this->monitor->checkin->enviados = $key;
                $this->monitor->checkin->number = $ingresso->codigoingresso;
                $area_id = $this->addRotaArray($ingresso->categoria);
                $tipoingresso_id = $this->addCategoriArray($ingresso->categoria);

                $ticket = (object) [
                    'evento_id' => $this->eventId,
                    'codigoingresso' => $ingresso->codigoingresso,
                    'area_id' => $area_id,
                    'tipoingresso_id' => $tipoingresso_id,
                    'acessotipocontrolador' => 8,
                    'dtevento' => date('Y-m-d', strtotime($ingresso->data_inicio)),
                    'utilizado' => !empty($ingresso->data_acesso) ? 1 : 0,
                    'ativo' => $ingresso->ativo,
                    'lote' => trim((string) $ingresso->nome),
                    'coletar' => 0,
                ];
                // inserir ou não
                // $idTicket = $this->ticket->merge($ticket);,
				
				$rsi = $this->ticket->where(['codigoingresso' => $ticket->codigoingresso])->first();
				$update = [];
				if (!empty($rsi)) {
					if ($ticket->utilizado == 1 && $rsi->utilizado != 1) {
						$update[] = ['utilizado' => 1];
						$this->ticket->update($rsi->id,['utilizado' => 1]);
					}

					if ((int) $ticket->ativo != (int) $rsi->ativo) {
						$update[] = ['ativo' => (int) $rsi->ativo];
						$this->ticket->update($rsi->id,['ativo' => $rsi->ativo]);
					}

				} else {
					$this->ticket->insert($ticket);
			
				}
                $this->displaySinc('BAIXANDO TICKETS');
            }
        }
		
    }

    private function displaySinc($title = null)
    {
        $dateT = date('d/m/Y H:i:s');
        CLI::clearScreen();
        CLI::write('|=====================================================================|');
        CLI::write("|=====  {$title}: {$dateT}  ========================|", 'red', 'yellow');
        CLI::write('|=====================================================================|' . "\n");
        CLI::showProgress($this->monitor->checkin->key, $this->monitor->checkin->count);
        CLI::write('|=====================================================================|' . "\n");
        CLI::write("| Number: {$this->monitor->checkin->number} |");
        CLI::write("| Item: {$this->monitor->checkin->enviados} de {$this->limit} |");
        CLI::write('|=====================================================================|' . "\n");
    }
}
