<?php

namespace App\Libraries;

use App\Models\TicketeiraEventoModel;
use App\Models\CategoryModel;
use App\Models\TicketModel;
use App\Models\EventModel;
use App\Models\RegistryModel;
use App\Models\DeliveryModel;
use App\Libraries\Cloudid\Cloudid;
use App\Libraries\Bora\Bora;
use CodeIgniter\CLI\CLI;
use stdClass;

class LibCloud
{

    private TicketeiraEventoModel $ticketeriaEvento;
    private TicketModel $ticket;
    private CategoryModel $category;
    private RegistryModel $registry;
    private DeliveryModel $delivery;
    private EventModel $event;
    private stdClass $monitor;
    private stdClass $data;
    private Cloudid $cloudid;
    private Bora $bora;
    // private Cloudid $cloudid;

    public function __construct()
    {
        $this->ticketeriaEvento = new TicketeiraEventoModel();
        $this->ticket = new TicketModel();
        $this->category = new CategoryModel();
        $this->registry = new RegistryModel();
        $this->delivery = new DeliveryModel();
        $this->event = new EventModel();
        $this->bora = new Bora();
        // $this->cloudid = new Cloudid();
        $this->monitor = (object) [
            'tickets' => (object) [
                'page' => 0,
                'totalPage' => 0,
                'totalTickets' => 0,
                'lastDate' => 0,
                'has_next' => true,
                'news' => 0,
                'updated' => 0,
                'noupdated' => 0,
                'fTotal' => 0,
                'fKey' => 0,
                'number' => 0,
                'name' => null,
            ],
            'leitura' => (object) [
                'page' => 0,
                'totalPage' => 0,
                'totalTickets' => 0,
                'lastDate' => 0,
                'has_next' => true,
                'news' => 0,
                'updated' => 0,
                'noupdated' => 0,
                'fTotal' => 0,
                'fKey' => 0,
                'number' => 0,
                'name' => null,
            ],
            'checkin' => (object) [
                'key' => 0,
                'count' => 0,
                'number' => 0,
                'lista' => 0,
                'enviados' => 0
            ]
        ];
    }

    public function startSync($integrador)
    {
        $this->data = $integrador;

        $startSync = date('Y-m-d H:i:s');
        $this->ticketeriaEvento->update(
            $integrador->id,
            [
                'startSync' => $startSync,
                'endSync' => null,
                'statusSync' => 'iniciando varredura'
            ]
        );
        $this->sincCloud($integrador, 'start');
    }

    public function checkinSinc($integrador)
    {
        $this->data = $integrador;
        $startSync = date('Y-m-d H:i:s');
        $this->ticketeriaEvento->update(
            $integrador->id,
            [
                'startSync' => $startSync,
                'endSync' => null,
                'statusSync' => 'iniciando checkin'
            ]
        );
        $this->sincCloudCheckin($integrador);
    }

    public function checkinSincPost($integrador)
    {
        $this->data = $integrador;
        $startSync = date('Y-m-d H:i:s');
        $this->ticketeriaEvento->update(
            $integrador->id,
            [
                'startSync' => $startSync,
                'endSync' => null,
                'statusSync' => 'baixando marcacoes'
            ]
        );
        $this->downloadCloudCheckin($integrador);
    }

    public function importa($eventId)
    {
        $this->bora->api->setToken('c7311677-48ad-4d57-a427-47e27c339154');
        $this->bora->api->setEventApi($eventId);
        $data = $this->bora->api->download();
        $csv =  $path = WRITEPATH . "uploads/import_{$eventId}.csv";

        if(file_exists($csv)) {
            delete_files($csv);
        }

        if (!write_file($csv, $data)) {
            CLI::write('--- Unable to write the file -- '.$csv );

        } else {
            $len = strlen($data);
            CLI::write("--- File written!-- {$csv} - {$len} bytes");
        }

        $data = null;
        unset($this->bora);
        unset($data);
        if(!file_exists($csv)) {
            return;
        }
        $handle = fopen($csv, "r");
        $serialId = $this->ticket->getNextSerialId();
        $arId = 0;
        $class = new  stdClass();
        CLI::write('--- start sinc ---- '.$csv );
        while (($row = fgetcsv($handle, 10000, ";")) != FALSE) //get row vales
        {
            if($row[0]=='id') {
                continue;
            }
            $serialId = time();
            $item = (object) [
                "id" => $row[0],
                "serial_id" => $row[1],
                "eventCode" => $row[2],
                "category_id" => $row[3],
                "category" => $row[4],
                "categoryCode" => $row[5],
                "category_type" => $row[6],
                "category_fluxo" => $row[7],
                "category_idr_multiplo" => $row[8],
                "event" => $row[9],
                "event_local" => $row[10],
                "event_start" => $row[11],
                "event_end" => $row[12],
                "event_extra1" => $row[13],
                "event_extra2" => $row[14],
                "ticket_number" => $row[15],
                "name" => $row[16],
                "email" => $row[17],
                "document_rg" => $row[18],
                "document_cpf" => $row[19],
                "status" => $row[20],
                "extrafield_1" => $row[21],
                "extrafield_2" => $row[22],
                "updated_at" => $row[23],
                "master" => $row[24],
                "check_in_date" => $row[25],
                "delivery_in_date" => $row[26]
            ];

            $eventId = $this->getEventId($item);

            $ticket = (object) [
                'id_evento' => $eventId,
                'serial_id' => $serialId,
                'id_categoria' => $this->getCategoryId($item),
                'cartao' => $item->ticket_number,
                'campoextra1' => $item->extrafield_1,
                'campoextra2' => $item->extrafield_2,
                'email' => $item->email,
                'nome' => $item->name,
                'ticketeira_id' => null,
                'ticketeira_identify' => $item->ticket_number,
                'ticketeira_updated_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'situacao' => $item->status,
                'mestre' => $item->master,
                'send_on' => date('Y-m-d H:i:s'),
            ];

            $resp = $this->ticket->addOrInsert($ticket, $serialId);

            // adiciona marcação de ticket
            if(!empty($resp->id) && !empty($item->check_in_date)) {
                $registry = $this->registry->where([
                    'cartao' => $item->ticket_number,
                    'acao' => 'PS',
                    'data_acesso' => date('Y-m-d H:i:s', strtotime($item->check_in_date))
                ])->first();
                if(empty($registry)) {
                    $this->registry->insert([
                        'serial_id' => $serialId,
                        'id_pessoa' => $resp->id,
                        'id_evento' => $eventId,
                        'cartao' => $item->ticket_number,
                        'data_acesso' => $item->check_in_date,
                        'acao' => 'PS',
                        'terminal' => null,
                        'giro' => null,
                        'remote_id' => null,
                        'send_on' => date('Y-m-d H:i:s', time())
                    ]);
                }
            }

            // adiciona marcação de entrega
            if(!empty($resp->id) && !empty($item->delivery_in_date)) {
                $delivery = $this->delivery->where([
                    'cartao' => $item->ticket_number,
                    'acao' => 'PS',
                    'data_acesso' => date('Y-m-d H:i:s', strtotime($item->delivery_in_date))
                ])->first();
                if(empty($delivery)) {
                    $this->delivery->insert([
                        'serial_id' => $serialId,
                        'id_evento' => $eventId,
                        'cartao' => $item->ticket_number,
                        'data_acesso' => $item->delivery_in_date,
                        'acao' => 'PS',
                        'terminal' => null,
                        'giro' => null,
                        'remote_id' => null,
                        'send_on' => date('Y-m-d H:i:s', time())
                    ]);
                }
            }
        }
    }

    public function getIntegradores()
    {
        return $this->ticketeriaEvento
            ->select('
                ticketeira_evento.id,
                ticketeira.id as ticketeira_id,
                ticketeira.nome as ticketeira,
                ticketeira.modulo,
                ticketeira_evento.evento_id,
                ticketeira_evento.token,
                ticketeira_evento.identify,
                ticketeira_evento.params,
                ticketeira_evento.startSync,
                ticketeira_evento.endSync,
                ticketeira_evento.statusSync,
                ticketeira_evento.ticket_serial_id,
                ticketeira_evento.registry_serial_id,
                ticketeira_evento.entrega_serial_id
            ')
            ->join('ticketeira', 'ticketeira.id = ticketeira_evento.ticketeira_id')
            ->where([
                'ticketeira_evento.active' => 1,
                'ticketeira.ativo' => 1
            ])->findAll();
    }

    public function sincCloud($integrador, $service)
    {
        CLI::write('|= iniciando ....===|');
        $this->cloudid = new Cloudid();

        $this->monitor->tickets->page = 1;
        $this->monitor->tickets->news = 0;
        $this->monitor->tickets->updated = 0;
        $this->monitor->tickets->noupdated = 0;
        $this->monitor->tickets->name = 'Importa todos os registros';
        $this->display();
        if ($service == 'start') {
            $this->processaSinc();
        }

        if ($service == 'end') {
            $this->getLast();
        }
    }

    public function downloadCloudCheckin($integrador)
    {
        CLI::write('|= iniciando ....===|');
        $this->cloudid = new Cloudid();

        $this->monitor->leitura->page = 1;
        $this->monitor->leitura->news = 0;
        $this->monitor->leitura->updated = 0;
        $this->monitor->leitura->noupdated = 0;
        $this->monitor->leitura->name = 'Importa todas as marcações';
        $this->displayLeitura();
        $this->baixaLeituras();
    }

    public function sincCloudCheckin($integrador)
    {
        CLI::write('|= iniciando ....===|');
        $this->cloudid = new Cloudid();
        $this->monitor->checkin->key = 0;
        $this->monitor->checkin->count = 0;
        $this->monitor->checkin->number = 0;
        $this->monitor->checkin->lista = 0;
        $this->monitor->checkin->enviado = 0;
        $this->displayChekin();
        $this->processaSincCheckin($integrador);

        $this->monitor->checkin->key = 0;
        $this->monitor->checkin->count = 0;
        $this->monitor->checkin->number = 0;
        $this->monitor->checkin->lista = 0;
        $this->monitor->checkin->enviado = 0;
        $this->displayDelivery();
        $this->processaSincDelivery($integrador);

        // $this->sincCloudCheckin($integrador);
    }

    private function processaSinc()
    {

        $this->monitor->tickets->name = 'Importa todos os registros';
        $this->page();

        if ($this->monitor->tickets->has_next) {
            $this->monitor->tickets->page++;
            $this->processaSinc();
        } else {
            $this->monitor->tickets->page = 1;
            $this->monitor->tickets->page = 1;
            $this->monitor->tickets->news = 0;
            $this->monitor->tickets->updated = 0;
            $this->monitor->tickets->noupdated = 0;
            sleep(1);
        }
    }

    private function baixaLeituras()
    {

        $this->monitor->leitura->name = 'Importa todos os registros';
        $this->downloadPage();

        if ($this->monitor->leitura->has_next) {
            $this->monitor->leitura->page++;
            $this->baixaLeituras();
        } else {
            $this->monitor->leitura->page = 1;
            $this->monitor->leitura->page = 1;
            $this->monitor->leitura->news = 0;
            $this->monitor->leitura->updated = 0;
            $this->monitor->leitura->noupdated = 0;
            sleep(1);
        }
       
        $this->baixarDelivery();
        
    }

    private function baixarDelivery()
    {

        $this->monitor->leitura->name = 'Importa todas as entregas';
       
        $this->downloadPageEntrega();

        if ($this->monitor->leitura->has_next) {
            $this->monitor->leitura->page++;
            $this->baixarDelivery();
        } else {
            $this->monitor->leitura->page = 1;
            $this->monitor->leitura->page = 1;
            $this->monitor->leitura->news = 0;
            $this->monitor->leitura->updated = 0;
            $this->monitor->leitura->noupdated = 0;
            sleep(1);
        }
        
    }

    private function processaSincCheckin($integrador)
    {

        $this->monitor->checkin->name = 'Checkin * ';

        $limit = 2000;
        $register = $this->registry->getUnsendedRegister($integrador->ticketeira_id, $limit);
        $rs = $this->registry->getCount($integrador->ticketeira_id);
        $qtdTotal = 0;
        if (!empty($rs)) {
            $this->monitor->checkin->lista = $rs->qtd;
            $qtdTotal = $rs->qtd;
        }

        $dateNow = date('d/m/Y H:i:s');
        $this->monitor->checkin->count = count($register);
        if (!empty($register)) {
            $this->sendRegister($register);
        } else {
            $this->monitor->checkin->number = ' -- ';
            $this->monitor->checkin->key = 0;
            $this->monitor->checkin->count = 0;
            $this->monitor->checkin->lista = 0;
            $this->displayChekin();
        }
        sleep(1);
        if($qtdTotal > 0) {
            $this->processaSincCheckin($integrador); 
        }
        // $this->processaSincCheckin($integrador);
    }

    private function processaSincDelivery($integrador)
    {

        $this->monitor->checkin->name = 'Entrega * ';

        $limit = 2000;
        $delivery = $this->delivery->getUnsendedRegister($integrador->ticketeira_id, $limit);
        //dd($delivery);
        $rs = $this->delivery->getCount($integrador->ticketeira_id);

        $qtdTotal = 0;
        if (!empty($rs)) {
            $this->monitor->checkin->lista = $rs->qtd;
            $qtdTotal = $rs->qtd;
        }

        $dateNow = date('d/m/Y H:i:s');
        $this->monitor->checkin->count = count($delivery);
        if (!empty($delivery)) {
            $this->sendEntrega($delivery);
        } else {
            $this->monitor->checkin->number = ' -- ';
            $this->monitor->checkin->key = 0;
            $this->monitor->checkin->count = 0;
            $this->monitor->checkin->lista = 0;
            $this->displayDelivery();
        }
        sleep(1);
        if($qtdTotal > 0) {
            $this->processaSincDelivery($integrador); 
        }
    }

    public function sendRegister($list)
    {
        $items = [];
        foreach ($list as $v) {
            $items[] = (array) $v;
        }
        $request = $this->cloudid->api->checkin($items);

        foreach ($request as $key => $register) {
            $this->monitor->checkin->key = $key + 1;
            $this->monitor->checkin->number = $register->ticket_number;
            $this->registry->update($register->id, ['send_on' => date('Y-m-d H:i:s')]);
            $this->monitor->checkin->enviados++;
            $this->displayChekin();
        }
    }

    public function sendEntrega($list)
    {
        $items = [];
        foreach ($list as $v) {
            $items[] = (array) $v;
        }
        $request = $this->cloudid->api->delivery($items);
        dd($request);
        foreach ($request as $key => $delivery) {
            $this->monitor->checkin->key = $key + 1;
            $this->monitor->checkin->number = $delivery->ticket_number;
            $this->delivery->update($delivery->id, ['send_on' => date('Y-m-d H:i:s')]);
            $this->monitor->checkin->enviados++;
            $this->displayDelivery();
        }
    }

    public function getLast()
    {
        $this->monitor->tickets->page = 1;
        $this->monitor->tickets->name = 'Importa registros novos';
        $this->page(1, true);

        $this->monitor->tickets->page = 1;
        $this->monitor->tickets->news = 0;
        $this->monitor->tickets->updated = 0;
        $this->monitor->tickets->noupdated = 0;

        sleep(1);

        $this->getLast();
    }

    private function display()
    {
        $dateT = date('d/m/Y H:i:s');
        CLI::clearScreen();
        CLI::write('|=====================================================================|');
        CLI::write("|=====   {$this->monitor->tickets->name}  ====   {$dateT}   ===|", 'red', 'yellow');
        CLI::write('|=====================================================================|' . "\n");
        CLI::showProgress($this->monitor->tickets->page, $this->monitor->tickets->totalPage);
        CLI::write('|=====================================================================|' . "\n");
        CLI::write("| Page: {$this->monitor->tickets->page} de {$this->monitor->tickets->totalPage} |", 'dark_blue', 'yellow');
        CLI::write('|=====================================================================|' . "\n");
        CLI::showProgress($this->monitor->tickets->fKey, $this->monitor->tickets->fTotal);
        CLI::write("| Item da Page: {$this->monitor->tickets->fKey} |", 'dark_blue', 'yellow');
        CLI::write("| Total da Page: {$this->monitor->tickets->fTotal} |");
        CLI::write("| Number: {$this->monitor->tickets->number} |");
        CLI::write("| Novos: {$this->monitor->tickets->news} |");
        CLI::write("| Atualizados: {$this->monitor->tickets->updated} |");
        CLI::write("| Sem atualizações: {$this->monitor->tickets->noupdated} |");
        CLI::write('|=====================================================================|' . "\n");
    }

    private function displayLeitura()
    {
        $dateT = date('d/m/Y H:i:s');
        CLI::clearScreen();
        CLI::write('|=====================================================================|');
        CLI::write("|=====   {$this->monitor->leitura->name}  ====   {$dateT}   ===|", 'red', 'yellow');
        CLI::write('|=====================================================================|' . "\n");
        CLI::showProgress($this->monitor->leitura->page, $this->monitor->leitura->totalPage);
        CLI::write('|=====================================================================|' . "\n");
        CLI::write("| Page: {$this->monitor->leitura->page} de {$this->monitor->leitura->totalPage} |", 'dark_blue', 'yellow');
        CLI::write('|=====================================================================|' . "\n");
        CLI::showProgress($this->monitor->leitura->fKey, $this->monitor->leitura->fTotal);
        CLI::write("| Item da Page: {$this->monitor->leitura->fKey} |", 'dark_blue', 'yellow');
        CLI::write("| Total da Page: {$this->monitor->leitura->fTotal} |");
        CLI::write("| Number: {$this->monitor->leitura->number} |");
        CLI::write("| Novos: {$this->monitor->leitura->news} |");
        CLI::write('|=====================================================================|' . "\n");
    }

    private function displayChekin()
    {
        $dateT = date('d/m/Y H:i:s');
        CLI::clearScreen();
        CLI::write('|=====================================================================|');
        CLI::write("|=====  Checkin Cloudid ====  {$dateT}  =======|", 'red', 'yellow');
        CLI::write('|=====================================================================|' . "\n");
        CLI::showProgress($this->monitor->checkin->key, $this->monitor->checkin->count);
        CLI::write('|=====================================================================|' . "\n");
        CLI::write("| Number: {$this->monitor->checkin->number} |");
        CLI::write("| Item: {$this->monitor->checkin->key} de {$this->monitor->checkin->count} |");
        CLI::write("| Na fila: {$this->monitor->checkin->lista} |");
        CLI::write("| Total enviados: {$this->monitor->checkin->enviados} |");
        CLI::write('|=====================================================================|' . "\n");
    }

    private function displayDelivery()
    {
        $dateT = date('d/m/Y H:i:s');
        CLI::clearScreen();
        CLI::write('|=====================================================================|');
        CLI::write("|=====  Entrega Cloudid ====  {$dateT}  =======|", 'red', 'yellow');
        CLI::write('|=====================================================================|' . "\n");
        CLI::showProgress($this->monitor->checkin->key, $this->monitor->checkin->count);
        CLI::write('|=====================================================================|' . "\n");
        CLI::write("| Number: {$this->monitor->checkin->number} |");
        CLI::write("| Item: {$this->monitor->checkin->key} de {$this->monitor->checkin->count} |");
        CLI::write("| Na fila: {$this->monitor->checkin->lista} |");
        CLI::write("| Total enviados: {$this->monitor->checkin->enviados} |");
        CLI::write('|=====================================================================|' . "\n");
    }

    private function page($page = 1, $last = false)
    {
        $data =  false;
        $params = [
            'page' => $this->monitor->tickets->page,
            'rows' => 2000,
            'code' => $this->data->identify,
            'serial_id' => $this->data->ticket_serial_id,
        ];


        try {
            $data = $this->cloudid->api->getTickets($params);
        } catch (\Exception $e) {
            CLI::write("| ERROR:  - {$e->getMessage()}   ", 'dark_blue', 'red');
            $data = false;
        }

        if (!empty($data) && !empty($data->data)) {
            $pagination = $data->data->pagination;
            if (!$last) {
                $this->monitor->tickets->page = $pagination->current;
                $this->monitor->tickets->has_next = ($pagination->pages > $pagination->current);
                $this->monitor->tickets->totalPage = $pagination->pages;
                $this->monitor->tickets->totalTickets = $pagination->rows;
                $this->monitor->tickets->lastDate = date('d/m/Y H:i:s');
            }
        }

        if (!empty($data)) {
            $this->processaResponse($data->data->tickets);
        }
    }

    private function downloadPage($page = 1, $last = false)
    {
        $data =  false;
        $params = [
            'page' => $this->monitor->leitura->page,
            'rows' => 2000,
            'code' => $this->data->identify,
            'serial_id' => $this->data->registry_serial_id,
        ];


        try {
            $data = $this->cloudid->api->getRegistry($params);
        } catch (\Exception $e) {
            CLI::write("| ERROR:  - {$e->getMessage()}   ", 'dark_blue', 'red');
            $data = false;
        }

        if (!empty($data) && !empty($data->data)) {
            $pagination = $data->data->pagination;
            if (!$last) {
                $this->monitor->leitura->page = $pagination->current;
                $this->monitor->leitura->has_next = ($pagination->pages > $pagination->current);
                $this->monitor->leitura->totalPage = $pagination->pages;
                $this->monitor->leitura->totalTickets = $pagination->rows;
                $this->monitor->leitura->lastDate = date('d/m/Y H:i:s');
            }
        }

        if (!empty($data)) {
            $this->processaLeitura($data->data->registers);
        }
    }

    private function downloadPageEntrega($page = 1, $last = false)
    {
        $data =  false;
        $params = [
            'page' => $this->monitor->leitura->page,
            'rows' => 2000,
            'code' => $this->data->identify,
            'serial_id' => $this->data->entrega_serial_id,
        ];


        try {
            $data = $this->cloudid->api->getDelivery($params);
        } catch (\Exception $e) {
            CLI::write("| ERROR:  - {$e->getMessage()}   ", 'dark_blue', 'red');
            $data = false;
        }
        
        if (!empty($data) && !empty($data->data)) {
            $pagination = $data->data->pagination;
            if (!$last) {
                $this->monitor->leitura->page = $pagination->current;
                $this->monitor->leitura->has_next = ($pagination->pages > $pagination->current);
                $this->monitor->leitura->totalPage = $pagination->pages;
                $this->monitor->leitura->totalTickets = $pagination->rows;
                $this->monitor->leitura->lastDate = date('d/m/Y H:i:s');
            }
        }

        if (!empty($data)) {
            $this->processaEntrega($data->data->delivery);
        }
    }

    private function processaEntrega($data)
    {
        $sts = (object) [
            'novos' => 0,
            'updates' => 0,
            'non' => 0,
        ];

        $this->monitor->leitura->fTotal = count($data);
        $entrega_serial_id = $this->data->entrega_serial_id;
        foreach ($data as $key => $item) {

            if ($item->serial_id > $this->data->entrega_serial_id) {
                $entrega_serial_id = (int) $item->serial_id;
            }

            $event = $this->event->where('id', $this->data->evento_id)->first();
            if (empty($event)) {
                continue;
            }

            $ticket = $this->ticket->where([
                'cartao' => $item->ticket_number,
                'id_evento' => $event->id
            ])->first();
            
            $entrega = [
                'serial_id' => $item->serial_id,
                'id_evento' => $event->id,
                'cartao' => $item->ticket_number,
                'data_acesso' => $item->access_date,
                'acao' => $item->action,
                'terminal' => $item->terminal,
                'giro' => $item->giro,
                'remote_id' => $item->id,
                'send_on' => !empty($item->send_on) ? $item->send_on : date('Y-m-d H:i:s', time())
            ];
            if (!empty($ticket)) {
                $entrega['id_pessoa'] = $ticket->id;
            }

            $resp = $this->delivery->where([
                'cartao' => $entrega['cartao'],
                'data_acesso' => $entrega['data_acesso'],
                'acao' => $entrega['acao']
            ])->first();

            if (empty($resp)) {
                $this->monitor->leitura->news++;
                $this->delivery->insert($entrega);
            } else {
                $this->monitor->leitura->updated++;
            }

            $this->displayLeitura();
        }

        if ($entrega_serial_id > $this->data->entrega_serial_id) {
            $this->ticketeriaEvento->where([
                'evento_id' => $this->data->evento_id,
                'ticketeira_id' => $this->data->ticketeira_id
            ])
                ->set(['entrega_serial_id' => $entrega_serial_id])
                ->update();
        }
    }

    private function processaLeitura($data)
    {
        $sts = (object) [
            'novos' => 0,
            'updates' => 0,
            'non' => 0,
        ];

        $this->monitor->leitura->fTotal = count($data);
        $registry_serial_id = $this->data->registry_serial_id;
        foreach ($data as $key => $item) {

            if ($item->serial_id > $this->data->registry_serial_id) {
                $registry_serial_id = (int) $item->serial_id;
            }

            $event = $this->event->where('id', $this->data->evento_id)->first();
            if (empty($event)) {
                continue;
            }

            $ticket = $this->ticket->where([
                'cartao' => $item->ticket_number,
                'id_evento' => $event->id
            ])->first();

            $registry = [
                'serial_id' => $item->serial_id,
                'id_evento' => $event->id,
                'cartao' => $item->ticket_number,
                'data_acesso' => $item->access_date,
                'acao' => $item->action,
                'terminal' => $item->terminal,
                'giro' => $item->giro,
                'remote_id' => $item->id,
                'send_on' => !empty($item->send_on) ? $item->send_on : date('Y-m-d H:i:s', time())
            ];
            if (!empty($ticket)) {
                $registry['id_pessoa'] = $ticket->id;
            }

            $resp = $this->registry->where([
                'cartao' => $registry['cartao'],
                'data_acesso' => $registry['data_acesso'],
                'acao' => $registry['acao']
            ])->first();

            if (empty($resp)) {
                $this->monitor->leitura->news++;
                $this->registry->insert($registry);
            } else {
                $this->monitor->leitura->updated++;
            }

            $this->displayLeitura();
        }

        if ($registry_serial_id > $this->data->registry_serial_id) {
            $this->ticketeriaEvento->where([
                'evento_id' => $this->data->evento_id,
                'ticketeira_id' => $this->data->ticketeira_id
            ])
                ->set(['registry_serial_id' => $registry_serial_id])
                ->update();
        }
    }

    private function processaResponse($data)
    {
        $sts = (object) [
            'novos' => 0,
            'updates' => 0,
            'non' => 0,
        ];

        $this->monitor->tickets->fTotal = count($data);
        $ticket_serial_id = $this->data->ticket_serial_id;
        foreach ($data as $key => $item) {
            if ($item->serial_id > $this->data->ticket_serial_id) {
                $ticket_serial_id = (int) $item->serial_id;
            }
            $event = $this->event->where('code', $item->eventCode)->first();
            if (empty($event)) {
                continue;
            }

            $ticket = (object) [
                'id_evento' => $this->getEventId($item),
                'id_categoria' => $this->getCategoryId($item),
                'cartao' => $item->ticket_number,
                'campoextra1' => $item->extrafield_1,
                'campoextra2' => $item->extrafield_2,
                'email' => $item->email,
                'nome' => $item->name,
                'ticketeira_id' => $this->data->ticketeira_id,
                'ticketeira_identify' => $item->ticket_number,
                // 'ticketeira_values' => json_encode($item),
                'ticketeira_updated_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'situacao' => $item->status,
                'mestre' => $item->master,
                'send_on' => date('Y-m-d H:i:s'),
            ];

            $resp = $this->ticket->addOrInsert($ticket, $ticket_serial_id);
            if (!$resp->exists) {
                $this->monitor->tickets->news++;
            } else {
                $this->monitor->tickets->updated++;
            }

            $this->display();
        }
        // dd($ticket_serial_id);
        if ($ticket_serial_id > $this->data->ticket_serial_id) {
            $this->ticketeriaEvento->where([
                'evento_id' => $this->data->evento_id,
                'ticketeira_id' => $this->data->ticketeira_id
            ])
                ->set(['ticket_serial_id' => $ticket_serial_id])
                ->update();
        }
    }

    private function getEventId($data)
    {
        $event = $this->event->where('code', $data->eventCode)->first();
        if (!empty($event)) {
            return $event->id;
        } else {
            return $this->event->insert([
                'evento' => $data->event,
                'local' => $data->event_local,
                'code' => $data->eventCode,
                'data_inicio' => $data->event_start,
                'data_fim' => $data->event_end,
                'campos_obri' => null,
                'campoextra1' => $data->event_extra1,
                'campoextra2' => $data->event_extra2,
                'idr_cadastrado' => null,
                'idr_passagem' => null,
                'qtd_livre' => 0,
                'qtd_midia1' => 0,
                'qtd_midia2' => 0,
                'qtd_midia3' => 0,
                'qtd_midia4' => 0
            ]);
        }
    }

    private function getCategoryId($data)
    {
        $category = $this->category->where('code', $data->categoryCode)->first();
        if (!empty($category)) {
            return $category->id;
        } else {
            $category = $this->category->where('categoria', $data->category)->first();
            if (!empty($category)) {
                return $category->id;
            } else {
                return $this->category->insert([
                    'code' => $data->categoryCode,
                    'categoria' => $data->category,
                    'idr_multiplo' => $data->category_idr_multiplo,
                    'fluxo' => $data->category_fluxo,
                    'tipo' => $data->category_type,
                    'external_id' => $data->category_id
                ]);
            }
        }
    }
}
