<?php

namespace App\Libraries;

use App\Libraries\CloudidApi\CloudidApi;

class LibCacheList
{

    private $expireTime;
    private $cache;
    private CloudidApi $api;

    public function __construct(CloudidApi $api)
    {
        $this->api = $api;
        $this->expireTime = 60 * 10;
        $this->cache = \Config\Services::cache();
        //$this->cache->clean();
    }

    public function getDepartamentos()
    {

        $cache = 'departamentos';
        $output = [];
        if ($this->cache->get($cache)) {
            $data = $this->api->departamento->getList(['rows'=>0,'page'=>0,'order' => 'asc', 'sort' => 'nome']);
            if ($data && property_exists($data, 'data') && property_exists($data->data, 'departamentos')) {
                $this->cache->save($cache, $data, $this->expireTime);
            }
        } else {
            $data = $this->cache->get($cache);
        }
        
        if ($data && property_exists($data, 'data') && property_exists($data->data, 'departamentos')) {
            foreach ($data->data->departamentos as $value) {
                $output[] = (object)[
                    'id' => $value->id,
                    'name' => $value->nome,
                ];
            }
        }

        return (object) $output;
    }

    public function getDestinoFinal()
    {
        $cache = 'destinofinal';
        $output = [];

        if (!$data = $this->cache->get($cache)) {
            $data = $this->api->destinoFinal->getList(['order' => 'asc', 'sort' => 'destino']);
            if ($data && property_exists($data, 'destino_final')) {
                $this->cache->save($cache, $data, $this->expireTime);
            }
        }

        if ($data && property_exists($data, 'destino_final')) {
            foreach ($data->destino_final as $value) {
                $output[] = (object)[
                    'id' => $value->id,
                    'name' => $value->destino,
                ];
            }
        }

        return (object) $output;
    }
    public function getTipoDocumento()
    {
        $cache = 'tipodocumento';
        $output = [];

        if (!$data = $this->cache->get($cache)) {
            $data = $this->api->tipoDocumento->getList(['order' => 'asc', 'sort' => 'nome']);
            if ($data && property_exists($data, 'tipo_documento')) {
                $this->cache->save($cache, $data, $this->expireTime);
            }
        }

        if ($data && property_exists($data, 'tipo_documento')) {
            foreach ($data->tipo_documento as $value) {
                $output[] = (object)[
                    'id' => $value->id,
                    'name' => $value->nome,
                ];
            }
        }

        return (object) $output;
    }
    public function getFaseArquivamento()
    {
        $cache = 'fasearquivamento';
        $output = [];

        if (!$data = $this->cache->get($cache)) {
            $data = $this->api->faseArquivamento->getList(['order' => 'asc', 'sort' => 'nome']);
            if ($data && property_exists($data, 'fase_arquivamento')) {
                $this->cache->save($cache, $data, $this->expireTime);
            }
        }

        if ($data && property_exists($data, 'fase_arquivamento')) {
            foreach ($data->fase_arquivamento as $value) {
                $output[] = (object)[
                    'id' => $value->id,
                    'name' => $value->nome,
                ];
            }
        }

        return (object) $output;
    }
    public function getDocumentoCaixa()
    {
        $cache = 'documentocaixa';
        $output = [];

        if (!$data = $this->cache->get($cache)) {
            $data = $this->api->documentoCaixa->getList(['order' => 'asc', 'sort' => 'nome']);
            if ($data && property_exists($data, 'documento_caixa')) {
                $this->cache->save($cache, $data, $this->expireTime);
            }
        }

        if ($data && property_exists($data, 'documento_caixa')) {
            foreach ($data->documento_caixa as $value) {
                $output[] = (object)[
                    'id' => $value->id,
                    'name' => $value->identificacao,
                ];
            }
        }

        return (object) $output;
    }

    public function clear($item)
    {
        $this->cache->delete($item);
    }

    public function clearAll()
    {
        $this->cache->clean();
    }
}
