<?php

namespace App\Libraries;

use \Firebase\JWT\JWT;
use \Firebase\JWT\Key;
use App\Models\UserModel;
use CodeIgniter\API\ResponseTrait;

class LibAuth
{
    use ResponseTrait;

    protected $model;
    private $db;
    static $user;
    static $auth;

    public function __construct()
    {
        $this->model = new UserModel();
        $this->db = \Config\Database::connect();
    }

    public function authValidate($request)
    {
        $headers = $request->getServer('HTTP_AUTHORIZATION');
        if (!empty($headers)) {
            if (preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
                $beaver =  $matches[1];
                return 'Beaver';
            } else {
                return 'Basic';
            }
        }
        return null;
    }

    private function getHttpAuth($request)
    {
        $dados = (object) [
            'PHP_AUTH_USER' => $request->getServer('PHP_AUTH_USER'),
            'PHP_AUTH_PW' => $request->getServer('PHP_AUTH_PW'),
            'PHP_AUTH_DIGEST' => $request->getServer('PHP_AUTH_DIGEST'),
            'HTTP_AUTHORIZATION' => $request->getServer('HTTP_AUTHORIZATION')
        ];

        if (!empty($dados->HTTP_AUTHORIZATION)) {
            list($dados->PHP_AUTH_USER, $dados->PHP_AUTH_PW) = explode(':', base64_decode(substr($dados->HTTP_AUTHORIZATION, 6)));
        }

        return $dados;
    }

    public function getLoginAuth($request)
    {
        $dados = $this->getHttpAuth($request);
        Self::$user= $this->userLogin($dados->PHP_AUTH_USER, $dados->PHP_AUTH_PW);
    }


    public function getBearer($request)
    {
        $headers = $request->getServer('HTTP_AUTHORIZATION');
        if (!empty($headers)) {
            if (preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
                return $matches[1];
            }
        }
        return null;
    }

    public function getAppByJwt($bearer)
    {

        $secret_key = file_get_contents(WRITEPATH . 'keys/jwtRS256.key');
        try {
            $decoded = JWT::decode($bearer, new Key($secret_key, 'HS256'));
        } catch (\Exception $e) {
            $decoded = null;
        }

        if ($decoded) {
            return $decoded->data;
        }
        return null;
    }

    static function getAuth()
    {
        if (!empty(Self::$user)) {
            return (object) [
                'id' => Self::$user->id,
                'name' => Self::$user->nome_completo,
                'login' => Self::$user->login,
            ];
        }
        return null;
    }

    public function userLogin($login, $password)
    {
        if(empty($login) || empty($password)){
            return null;
        }

        $user = $this->model->where(['login' => $login, 'ativo' => 'Y','senha' => md5($password), 'Ncadastro' => '1'])->first();
        if ($user) {
			
			$issuedat_claim = time();
			$user->usertoken = $this->registerToken($user, $password, $issuedat_claim);
			$user->expireAt = $issuedat_claim + 3660;
			return $user;
           
        }

        return null;
    }


    public function userValidate($auth)
    {
        $user = $this->userLogin($auth->login, $auth->password);
        if ($user) {
            return $user;
        }

        return false;
    }


    private function registerToken($user, $pass, $issuedat_claim)
    {
        $secret_key = file_get_contents(WRITEPATH . 'keys/jwtRS256.key');

        $token = [
            'iss' => "ONE_SERVER",
            'aud' =>  "ONE_AUDIENCE",
            'iat' => $issuedat_claim,
            'nbf' => $issuedat_claim,
            'exp' => $issuedat_claim + (24 * 3660),
            'data' => [
                'id' => $user->id,
                'name' => $user->nome_completo,
                'login' => $user->login,
                'password' => $pass,
            ]
        ];

        return JWT::encode($token, $secret_key, 'HS256');
    }
}
