<?php

namespace App\Libraries;

use App\Models\RegistryModel;
use App\Models\TicketModel;
use CodeIgniter\API\ResponseTrait;
use CodeIgniter\Database\RawSql;

class GraphicData
{
    use ResponseTrait;

    private RegistryModel $registry;
    private TicketModel $ticket;
    private $db;

    public function __construct()
    {
        $this->registry = new RegistryModel();
        $this->ticket = new TicketModel();
        $this->db = \Config\Database::connect();
    }

    public function getTicketPerTime()
    {

        return $this->registry->select(
            "count(distinct cartoes.id) as qtd,
            date_format(marcacao.data_acesso, '%d/%m') as day,
            hour(marcacao.data_acesso) as hour"
        )->join('cartoes', 'cartoes.id = marcacao.id_pessoa', 'inner')
        ->join('categorias', 'categorias.id = cartoes.id_categoria', 'inner')
        ->join('eventos', 'eventos.id = cartoes.id_evento', 'inner')
        ->where([
            'marcacao.acao' => 'PS',
            'categorias.tipo' => 'TICKET'
        ])->orderBy('marcacao.data_acesso', 'desc')
        ->limit(24);
        // old version
        return $this->db->query(
            "select
                count(distinct cartoes.id) as qtd,
                date_format(marcacao.data_acesso, '%d/%m') as day,
                hour(marcacao.data_acesso) as hour
            from marcacao
            left join cartoes
                on cartoes.id = marcacao.id_pessoa
            left join categorias
                on categorias.id = cartoes.id_categoria
            left join eventos
                on eventos.id = cartoes.id_evento
            where categorias.tipo = 'TICKET'
                and marcacao.acao = 'PS'
                and now() BETWEEN eventos.data_inicio and eventos.data_fim
            group by date_format(marcacao.data_acesso, '%Y%M%d'), hour(marcacao.data_acesso)
            order by marcacao.id desc
            limit 24"
        )->getResultObject();
    }

    public function getReentryPerTime()
    {
        return $this->registry->select(
            "count(distinct marcacao.id) as qtd,
            date_format(marcacao.data_acesso, '%d/%m') as day,
            hour(marcacao.data_acesso) as hour"
        )->join('cartoes', 'cartoes.id = marcacao.id_pessoa', 'inner')
        ->join('categorias', 'categorias.id = cartoes.id_categoria', 'inner')
        ->join('eventos', 'eventos.id = cartoes.id_evento', 'inner')
        ->where([
            'marcacao.acao' => 'PS',
            'categorias.tipo' => 'CREDENCIADO'
        ])->groupBy("date_format(marcacao.data_acesso, '%Y%M%d'), hour(marcacao.data_acesso)")
        ->orderBy('marcacao.data_acesso', 'desc')
        ->limit(24);

        return $this->db->query(
            "select
                count(distinct marcacao.id) as qtd,
                date_format(marcacao.data_acesso, '%d/%m') as day,
                hour(marcacao.data_acesso) as hour
            from marcacao
            left join cartoes
                on cartoes.id = marcacao.id_pessoa
            left join categorias
                on categorias.id = cartoes.id_categoria
            left join eventos
                on eventos.id = cartoes.id_evento
            where categorias.tipo = 'CREDENCIADO'
                and marcacao.acao = 'PS'
                and now() BETWEEN eventos.data_inicio and eventos.data_fim
            group by date_format(marcacao.data_acesso, '%Y%M%d'), hour(marcacao.data_acesso)
            order by marcacao.id desc
            limit 24"
        );
    }

    public function getReentryColabPerTime()
    {
        return $this->registry->select(
            "count(distinct marcacao.id) as qtd,
            date_format(marcacao.data_acesso, '%d/%m') as day,
            hour(marcacao.data_acesso) as hour"
        )->join('cartoes', 'cartoes.id = marcacao.id_pessoa', 'inner')
        ->join('categorias', 'categorias.id = cartoes.id_categoria', 'inner')
        ->join('eventos', 'eventos.id = cartoes.id_evento', 'inner')
        ->where([
            'marcacao.acao' => 'PS',
            'categorias.tipo' => 'COLABORADOR'
        ])->groupBy("date_format(marcacao.data_acesso, '%Y%M%d'), hour(marcacao.data_acesso)")
        ->orderBy('marcacao.data_acesso', 'desc')
        ->limit(24);

        return $this->db->query(
            "select
                count(distinct marcacao.id) as qtd,
                date_format(marcacao.data_acesso, '%d/%m') as day,
                hour(marcacao.data_acesso) as hour
            from marcacao
            left join cartoes
                on cartoes.id = marcacao.id_pessoa
            left join categorias
                on categorias.id = cartoes.id_categoria
            left join eventos
                on eventos.id = cartoes.id_evento
            where categorias.tipo = 'COLABORADOR'
                and marcacao.acao = 'PS'
                and now() BETWEEN eventos.data_inicio and eventos.data_fim
            group by date_format(marcacao.data_acesso, '%Y%M%d'), hour(marcacao.data_acesso)
            order by marcacao.id desc
            limit 24"
        )->getResultObject();
    }

    public function 
    getRegistryLidos()
    {
        return $this->registry->select("
            count(DISTINCT cartoes.id) as qtd,
            count(DISTINCT case when categorias.tipo = 'TICKET' then cartoes.id end) as tickets,
            count(DISTINCT case when categorias.tipo = 'CREDENCIADO' then cartoes.id end) as credenciados,
            count(DISTINCT case when categorias.tipo = 'COLABORADOR' then cartoes.id end) as colaborador
        ")->join('cartoes', 'cartoes.id = marcacao.id_pessoa')
        ->join('categorias', 'categorias.id = cartoes.id_categoria')
        ->join('eventos', 'eventos.id = cartoes.id_evento')
        ->where(new RawSql('now() BETWEEN eventos.data_inicio and eventos.data_fim'))
        ->where('marcacao.acao', 'PS')
        ->get()->getFirstRow();
    }

    public function getTicketsTotal()
    {
        return $this->ticket->select("
            count(DISTINCT cartoes.id) as qtd,
            count(DISTINCT case when categorias.tipo = 'TICKET' and cartoes.situacao = 1 then cartoes.id end) as tickets,
            count(DISTINCT case when categorias.tipo = 'CREDENCIADO' and cartoes.situacao = 1 then cartoes.id end) as credenciados,
            count(DISTINCT case when categorias.tipo = 'COLABORADOR' and cartoes.situacao = 1 then cartoes.id end) as colaborador,
            count(DISTINCT case when categorias.tipo = 'TICKET' and cartoes.situacao != 1 then cartoes.id end) as tickets_block,
            count(DISTINCT case when categorias.tipo = 'CREDENCIADO' and cartoes.situacao != 1 then cartoes.id end) as credenciados_block,
            count(DISTINCT case when categorias.tipo = 'COLABORADOR' and cartoes.situacao != 1 then cartoes.id end) as colaborador_block
        ")
        ->join('eventos', 'eventos.id = cartoes.id_evento')
        ->join('categorias', 'categorias.id = cartoes.id_categoria')
        ->where(new RawSql('now() BETWEEN eventos.data_inicio and eventos.data_fim'))
        ->get()->getFirstRow();
    }

    public function getSynthTickets()
    {
        return $this->ticket->select("
            categorias.id,
            categorias.categoria,
            categorias.tipo,
            count(distinct cartoes.id) as tickets,
            count(DISTINCT case when cartoes.situacao = 1 then cartoes.id end) as tickets_ativos,
            count(DISTINCT case when cartoes.situacao != 1 then cartoes.id end) as tickets_bloqueados,
            count(DISTINCT case when marcacao.id is not null then cartoes.id end) as tickets_lido_unico,
            count(DISTINCT case when entrega.id is not null then cartoes.id end) as entrega_lido
        ")
        ->join('categorias', 'categorias.id = cartoes.id_categoria', 'inner')
        ->join('eventos', 'eventos.id = cartoes.id_evento', 'inner')
        ->join('marcacao', "marcacao.id_pessoa = cartoes.id and marcacao.acao = 'PS'", 'left')
        ->join('entrega', "entrega.id_pessoa = cartoes.id and entrega.acao = 'PS'", 'left')
        ->groupBy('categorias.id')
        ->orderBy('categorias.tipo, categorias.categoria');

        
        return $this->db->query(
            "select
            categorias.id,
            categorias.categoria,
            categorias.tipo,
            count(distinct cartoes.id) as tickets,
            count(DISTINCT case when cartoes.situacao = 1 then cartoes.id end) as tickets_ativos,
            count(DISTINCT case when cartoes.situacao != 1 then cartoes.id end) as tickets_bloqueados,
            count(DISTINCT case when marcacao.id is not null then cartoes.id end) as tickets_lido_unico,
            count(DISTINCT case when entrega.id is not null then cartoes.id end) as entrega_lido
        from cartoes
        left join categorias on categorias.id = cartoes.id_categoria
        left join eventos on eventos.id = cartoes.id_evento
        left join marcacao on marcacao.id_pessoa = cartoes.id
            and marcacao.acao = 'PS'
        left join entrega on entrega.id_pessoa = cartoes.id
            and entrega.acao = 'PS'
        -- where now() BETWEEN eventos.data_inicio and eventos.data_fim
        group by categorias.id
        order by categorias.tipo, categorias.categoria;")->getResultObject();
    }


    public function getSynthTicketsUnx()
    {
        return $this->ticket->select("
            categorias.id,
            categorias.categoria,
            categorias.tipo,
            count(distinct cartoes.id) as tickets,
            count(DISTINCT case when cartoes.situacao = 1 then cartoes.id end) as tickets_ativos,
            count(DISTINCT case when cartoes.situacao != 1 then cartoes.id end) as tickets_bloqueados,
            count(DISTINCT case when marcacao.id is not null then cartoes.id end) as tickets_lido
        ")
        ->join('categorias', 'categorias.id = cartoes.id_categoria')
        ->join('eventos', 'eventos.id = cartoes.id_evento')
        ->join('marcacao', "marcacao.id_pessoa = cartoes.id and marcacao.acao = 'PS'")
        ->where(new RawSql('now() BETWEEN eventos.data_inicio and eventos.data_fim'))
        ->groupBy('categorias.id')
        ->orderBy('categorias.tipo')
        ->orderBy('categorias.categoria')
        ->get()->getResultObject();
    }

}
