<?php

namespace App\Libraries\Cloudid;

use App\Libraries\Cloudid\CloudidHttp;

class CloudidApi extends CloudidHttp
{

    private int $eventApi;

    const ENDPOINT_EVENT = 'event/';
    const ENDPOINT_TICKET = 'ticket/';
    const ENDPOINT_REGISTRY = 'registry/';

    public function getEvents()
    {
        return $this->httpGET(self::ENDPOINT_EVENT);
    }

    public function getEventByCode($code)
    {
        return $this->httpGET(self::ENDPOINT_EVENT . $code);
    }

    public function getTicketByTicketId($id)
    {
        return $this->httpGET(self::ENDPOINT_TICKET . '/' . $id);
    }

    public function getTickets($params = array())
    {
        $query = '';
        if (!empty($params)) {
            $query = '?' . http_build_query($params);
        }
        return $this->httpGET('ticket' . $query);
    }

    public function getRegistry($params = array())
    {
        $query = '';
        if (!empty($params)) {
            $query = '?' . http_build_query($params);
        }
        return $this->httpGET('registry' . $query);
    }

    public function getDelivery($params = array())
    {
        $query = '';
        if (!empty($params)) {
            $query = '?' . http_build_query($params);
        }
        return $this->httpGET('delivery' . $query);
    }

    public function checkin(array $tickets)
    {
        return $this->httpPOST(
            'registry', $tickets);
    }

    public function delivery(array $tickets)
    {
        return $this->httpPOST(
            'delivery', $tickets);
    }

}
