<?php

namespace App\Libraries;
use \Firebase\JWT\JWT;
use \Firebase\JWT\Key;
use App\Models\UserModel;

class AuthUser {

    private $session;
    private $user;
    private $model;

    public function __construct() {
        $this->session = \Config\Services::session();
        $this->model = new UserModel();
    }

    public function login($login, $pass) {
        $rs = $this->model->where([
            'login'=>$login,
            'senha'=>md5($pass),
            'Nadm'=>1
        ])->first();
        if($rs) {
            $this->setUser($rs);
            return true;
        }
        // $this->clearUser();
        return false;
    }

    public function setUser($login) {
        $this->modelUser();
        if (property_exists($login, 'id')) {
            $this->user->id = $login->id;
        }
        if (property_exists($login, 'login')) {
            $this->user->login = $login->login;
        }
        if (property_exists($login, 'nome_completo')) {
            $this->user->name = $login->nome_completo;
            $this->user->firstname = ucfirst(strtolower(strtok($login->nome_completo . ' ', " ")));
        }
        $this->user->last_login = date('Y-m-d H:i:s');
        $this->session->set('user', $this->user);
    }

    public function clearUser() {
        $this->session->destroy();
        $this->modelUser();
    }

    public function getUser() {
        if ($this->logged()) {
            return (object) $this->session->get('user');
        }
        return null;
    }
    public function logged() {
        $user = $this->session->get('user');
        if (!empty($user) && is_object($user) && property_exists($user, 'id') && !empty($user->id)) {
            return true;
        }
        return false;
    }

    public function getUserId() {
        return (int) $this->session->get('id');
    }

    public function setFlashdata($type, $message) {
        $this->session->setFlashdata($type, $message);
    }
    private function modelUser() {
        $this->user = (object) [
                    "id" => null,
                    "login" => null,
                    "name" => null,
                    "firstname" => null,
        ];
    }

}
