<?php

if (!function_exists('formatTelefone')) {

    function formatTelefone($value) {
        $phone = preg_replace("/\D/", '', $value);
        //99 9999-9999
        if (strlen($phone) === 8) {
            return preg_replace("/(\d{4})(\d{4})/", "\$1-\$2", $phone);
        }
        if (strlen($phone) === 9) {
            return preg_replace("/(\d{5})(\d{4})/", "\$1-\$2", $phone);
        }
        if (strlen($phone) === 10) {
            return preg_replace("/(\d{2})(\d{4})(\d{4})/", "(\$1) \$2-\$3", $phone);
        }

        if (strlen($phone) === 11) {
            return preg_replace("/(\d{2})(\d{5})(\d{4})/", "(\$1) \$2-\$3", $phone);
        }

        if (strlen($phone) === 12) {
            return preg_replace("/(\d{2})(\d{2})(\d{4})(\d{4})/", "\+\$1 (\$2) \$3-\$4", $phone);
        }

        if (strlen($phone) === 13) {
            return preg_replace("/(\d{2})(\d{2})(\d{5})(\d{4})/", "+\$1 (\$2) \$3-\$4", $phone);
        }
    }

}

if (!function_exists('getLink')) {

    function getLink($data) {
        if (preg_match("/^https:\/\//", $data)) {
            return $data;
        } else {
            return base_url() . "/{$data}";
        }
    }

}

if (!function_exists('getRealIPAddr')) {

    function getRealIPAddr() {
        //check ip from share internet
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            $ip = $_SERVER['HTTP_CLIENT_IP'];
        }
        //to check ip is pass from proxy
        elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } else {
            $ip = $_SERVER['REMOTE_ADDR'];
        }

        return $ip;
    }

}

if (!function_exists('resizeImageB64')) {

    function resizeImageB64($image_b64, $x, $y) {
        ob_start();

        $image = base64_decode($image_b64);
        $canvas = @imagecreatetruecolor($x, $y);
        $image_desc = imagecreatefromstring($image);
        $img_largura = imagesx($image_desc);
        $img_altura = imagesy($image_desc);
        //$size = getimagesize($urlImage);
        $fileImage = $image;
        $ori_x = $img_largura;
        $ori_y = $img_altura;
        // regra de 3 para imagem centro
        $ny = ($ori_y * $y) / $ori_x;
        $total = $ny;

        $meio = ($y - $total) / 2;
        // regra de 3 para imagem blur
        $nxb = ($ori_x * $x) / $ori_y;
        //echo $btotal;exit();
        $bmeio = ($nxb - $x) / 2;
        $blur_image = imagecreatefromstring($fileImage);
        imagefilter($blur_image, IMG_FILTER_CONTRAST, 50);
        imagefilter($blur_image, IMG_FILTER_BRIGHTNESS, 60);
        for ($i = 1; $i < 10; $i++) {
            imagefilter($blur_image, IMG_FILTER_GAUSSIAN_BLUR);
            //imagefilter($blur_image, IMG_FILTER_GRAYSCALE);
        }
        imagefilter($blur_image, IMG_FILTER_SMOOTH, 5);
        imagefilter($blur_image, IMG_FILTER_SELECTIVE_BLUR);
        imagecopyresampled($canvas, $blur_image, 0, 0, $bmeio, 0, $nxb, $x, $ori_x, $ori_y);

        $current_image = imagecreatefromstring($fileImage);
        imagecopyresampled($canvas, $current_image, 0, $meio, 0, 0, $y, $total, $ori_x, $ori_y);
        //header('Content-Type: image/png');
        imagepng($canvas);
        //imagewebp($canvas);
        $saida = ob_get_contents();
        ob_end_clean();
        //@ob_end_flush();
        $img = base64_encode($saida);
        return $img;
    }

}
if (!function_exists('convertToWebp')) {

    function convertToWebp($image_b64) {
        ob_start();

        $fileImage = base64_decode($image_b64);
        $blur_image = imagecreatefromstring($fileImage);
        imagewebp($blur_image);
        $saida = ob_get_contents();
        ob_end_clean();

        $img = base64_encode($saida);
        return $img;
    }

}

if (!function_exists('mask')) {

    function mask($mask, $val) {
        $maskared = '';
        $k = 0;
        for ($i = 0; $i <= strlen($mask) - 1; $i++) {
            if ($mask[$i] == '#') {
                if (isset($val[$k]))
                    $maskared .= $val[$k++];
            } else {
                if (isset($mask[$i]))
                    $maskared .= $mask[$i];
            }
        }
        return $maskared;
    }

}

if (!function_exists('toReal')) {

    function toReal($number) {
        return number_format($number, 2, ',', '.');
    }

}

if (!function_exists('clear_special_character')) {

    function clear_special_character($value) {
        $value = preg_replace("/[^a-zA-Z0-9]/", "", $value);
        return $value;
    }

}


if (!function_exists('toAscii')) {

    function toAscii($str, $replace = array(), $delimiter = '-') {
        setlocale(LC_ALL, 'en_US.UTF8');
        if (!empty($replace)) {
            $str = str_replace((array) $replace, ' ', $str);
        }
        $clean = iconv('UTF-8', 'ASCII//TRANSLIT', $str);
        $clean = preg_replace("/[^a-zA-Z0-9\/_|+ -]/", '', $clean);
        $clean = strtolower(trim($clean, '-'));
        $clean = preg_replace("/[\/_|+ -]+/", $delimiter, $clean);
        return $clean;
    }

}

if (!function_exists('toLower')) {

    function toLower($msg) {
        $str = mb_strtolower($msg);
        return strtolower($str);
    }

}

if (!function_exists('GetNomeLink')) {

    function GetNomeLink($string) {
        $string = strtolower(trim($string));
        $string = str_replace(" ", "-", $string);
        $string = str_replace("]", "-", $string);
        $string = str_replace("[", "-", $string);
        return RemoveAcentos($string);
    }

}


if (!function_exists('RemoveAcentos')) {

    function RemoveAcentos($string, $tag = false) {
        $string = tirarAcentos($string);
        $string = tirarAcentos2($string);
        $string = iconv("UTF-8", "ASCII//TRANSLIT", $string);

        if ($tag) {
            $acentos = array("'", '"', ".", "(", ")", "{", "}", "!", "?", "/"
                , "\\", "+", "*", "&", "%", "$", "#", "@"
                , ":", ";", "º", "ª", "|", "¨", "´", "`", "~", "^");
        } else {
            $acentos = array("'", '"', ",", ".", "(", ")", "{", "}", "!", "?", "/"
                , "\\", "+", "*", "&", "%", "$", "#", "@"
                , ":", ";", "º", "ª", "|", "¨", "´", "`", "~", "^");
        }

        foreach ($acentos as $key => $value) {
            $string = str_replace($value, "", $string);
        }
        return $string;
    }

}

if (!function_exists('tirarAcentos')) {

    function tirarAcentos($string) {
        return preg_replace(array("/(á|à|ã|â|ä)/", "/(Á|À|Ã|Â|Ä)/", "/(é|è|ê|ë)/", "/(É|È|Ê|Ë)/", "/(í|ì|î|ï)/", "/(Í|Ì|Î|Ï)/", "/(ó|ò|õ|ô|ö)/", "/(Ó|Ò|Õ|Ô|Ö)/", "/(ú|ù|û|ü)/", "/(Ú|Ù|Û|Ü)/", "/(ñ)/", "/(Ñ)/"), explode(" ", "a A e E i I o O u U n N"), $string);
    }

}
if (!function_exists('tirarAcentos2')) {

    function tirarAcentos2($string) {
        $comAcentos = array('à', 'á', 'â', 'ã', 'ä', 'å', 'ç', 'è', 'é', 'ê', 'ë', 'ì', 'í', 'î', 'ï', 'ñ', 'ò', 'ó', 'ô', 'õ', 'ö', 'ù', 'ü', 'ú', 'ÿ', 'À', 'Á', 'Â', 'Ã', 'Ä', 'Å', 'Ç', 'È', 'É', 'Ê', 'Ë', 'Ì', 'Í', 'Î', 'Ï', 'Ñ', 'Ò', 'Ó', 'Ô', 'Õ', 'Ö', 'O', 'Ù', 'Ü', 'Ú');
        $semAcentos = array('a', 'a', 'a', 'a', 'a', 'a', 'c', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'i', 'n', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'y', 'A', 'A', 'A', 'A', 'A', 'A', 'C', 'E', 'E', 'E', 'E', 'I', 'I', 'I', 'I', 'N', 'O', 'O', 'O', 'O', 'O', '0', 'U', 'U', 'U');
        return str_replace($comAcentos, $semAcentos, $string);
    }

}