<?php

namespace App\Controllers\User;

use App\Controllers\BaseController;
use App\Models\UserModel;
use App\Entities\UserEntity;

class User extends BaseController {

    private UserEntity $user;

    public function __construct()
    {
        $this->model = new UserModel();
        $this->user = new UserEntity();
    }

    public function initController($request, $response, $logger)
    {
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);
        if (!$this->authUser->logged()) {
            return redirect()->route("auth/signin");
        }
    }

    public function index() {
        $this->addOnView('users', $this->model->findAll());
        return view('user/index', $this->getViewData());
    }

    public function add()
    {
        $this->addOnView('usuario', $this->user);
        return view('user/edit', $this->getViewData());
    }

    public function edit($id)
    {
        $url = previous_url() ?? base_url();
        $result = $this->model->find((int)$id);
        if ($result) {
            $this->user->fill((array)$result);
            $this->addOnView('usuario', $result);
            return view('user/edit', $this->getViewData());
        } else {
            $this->authUser->setFlashdata('error', 'Usuário inválido');
            return redirect()->to($url);
        }
    }

    public function addsave()
    {
        $this->user->fill($this->request->getPost());
        
        $url = previous_url() ?? base_url();
        if(!empty($this->user->pass) && $this->user->pass != $this->user->pass2) {
            $this->authUser->setFlashdata('error', 'Senhas não são iguais');
            return redirect()->to($url);
        }
        $this->user->ativo = $this->user->ativo==1?'Y':'N';
        $update = $this->model->insert($this->user->toArray());

        if (!empty($update)) {
            $this->model->setPassword($update, $this->user->pass);
            $this->authUser->setFlashdata('success', 'Usuário criado com sucesso');
            return redirect()->to('/user');
        } else {
            $this->authUser->setFlashdata('error', $update->message);
            return redirect()->to($url);
        }
    }

    public function save($id)
    {
        $url = previous_url() ?? base_url();
        $this->user->fill($this->request->getPost());
        $this->user->id = $id;

        if(!empty($this->user->pass) && $this->user->pass != $this->user->pass2) {
            $this->authUser->setFlashdata('error', 'Senhas não são iguais');
            return redirect()->to($url);
        }
        $this->user->ativo = $this->user->ativo==1?'Y':'N';

        $result = $this->model->save($this->user->toArray());
        if ($result ) {
            if(!empty($this->user->pass)){
                $this->model->setPassword($this->user->id, $this->user->pass);
            }
            $this->authUser->setFlashdata('success', 'Usuário atualizado com sucesso');
            return redirect()->to('/user');
        } else {
            $this->authUser->setFlashdata('error', 'usero inválido');
            return redirect()->to($url);
        }
    }

}
