<?php

namespace App\Controllers\Report;

use App\Controllers\BaseController;
use App\Models\TicketModel;
use App\Models\EventModel;
use App\Models\CategoryModel;
use App\Models\PhotoModel;
use App\Models\RegistryModel;
use App\Models\DeliveryModel;
use App\Libraries\LibPaginate;

class Report extends BaseController {

    private EventModel $event;
    private CategoryModel $category;
    private TicketModel $ticket;
    private PhotoModel $photo;
    private RegistryModel $registry;
    private DeliveryModel $delivery;

    public function __construct()
    {
        $this->model = new TicketModel();
        $this->event = new EventModel();
        $this->category = new CategoryModel();
        $this->photo = new PhotoModel();
        $this->registry = new RegistryModel();
        $this->delivery = new DeliveryModel();
    }

    public function initController($request, $response, $logger)
    {
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);
        if (!$this->authUser->logged()) {
            return redirect()->route("auth/signin");
        }
    }

    public function registry() {
        $this->addOnView('events', $this->event->findAll());
        $this->addOnView('categories', $this->category->findAll());
        $this->addOnView('types', $this->category->getTypes());
        $this->addOnView('title', 'Relatório de acessos');
        $this->addOnView('sub', 'registry');
        return view('report/registry', $this->getViewData());
    }

    public function delivery() {
        $this->addOnView('events', $this->event->findAll());
        $this->addOnView('categories', $this->category->findAll());
        $this->addOnView('types', $this->category->getTypes());
        $this->addOnView('title', 'Relatório de entregas');
        $this->addOnView('sub', 'delivery');
        return view('report/registry', $this->getViewData());
    }

    public function registryData()
    {
        $data = [];
        $orders = [
            'cartoes.id_evento',
            'categorias.tipo',
            'cartoes.id_categoria',
            'cartoes.cartao',
            'cartoes.nome',
            'cartoes.situacao',
            'cartoes.mestre',
            'terminal.terminal_pin',
            '10',
            '',
        ];
       
        $busca = $this->request->getGet('search');
        
        $model = $this->defaultRep();

        if ($busca && $busca['value']) {
            $qry = trim($busca['value']);
            $model->where(" concat(cartoes.cartao,cartoes.id,ifnull(cartoes.nome,''),terminal.terminal_pin,ifnull(cartoes.rg,''), ifnull(cartoes.cpf,''),ifnull(cartoes.email,'')) like '%$qry%'");
        }

        $pagination = new LibPaginate($model, $this->request, 'data', $orders);

        $pagination->addFilter('cartoes.id_evento', 'event', '=');
        $pagination->addFilter('cartoes.id_categoria', 'category', '=');
    
        if ($this->request->getGetPost('situacao') == 1 || $this->request->getGetPost('situacao')  == '0') {
            $pagination->addFilter('cartoes.situacao', 'situacao', '=');
        }

        if ($this->request->getGetPost('master') == 1 || $this->request->getGetPost('master')  == '0') {
            $pagination->addFilter('cartoes.mestre', 'master', '=');
        }
        
        
        $pagination->addFilter('categorias.tipo', 'type', '=');

        $getLista = (object) $pagination->get();
        $lista = $getLista->data;
        
        $data['recordsTotal'] = $getLista->pagination->rows;
        $data['recordsFiltered'] = $getLista->pagination->rows;
        $data['pagination'] = $getLista->pagination->pages;
        $data['data'] = [];
        foreach ($lista as $value) {
            if ($value->situacao==1) {
                $txSituacao = "<span class=\"badge bg-success\">Ativo</span>";
            } else {
                $txSituacao = "<span class=\"badge bg-danger\">Bloqueado</span>";
            }
            $txMestre="";
            if ($value->mestre==1) {
                $txMestre = "<span class=\"badge bg-info\">Mestre</span>";
            }
      
            $linkEdit = base_url() . "/ticket/{$value->id}";
            $btg = "<a href=\"{$linkEdit}\" class=\"btn btn-sm rounded-circle btn-primary btn-soft mb-2\" data-id=\"{$value->id}\"  data-toggle=\"tooltip\" data-placement=\"top\" title=\"Ir\" ><i class=\"fi fi-menu-dots\"></i></a> ";
            $groupButton = "<div class=\"btn-group\" role=\"group\" aria-label=\"Opções\">{$btg}</dvi>";
            $situacao = "<div class=\"ms-3\">{$txSituacao}</div>";
            $mestre = "<div class=\"ms-3\"><small class=\"d-block\">{$txMestre}</small></div>";
            $data['data'][] = [
                $value->evento,
                $value->tipo,
                $value->categoria,
                $value->cartao,
                $value->nome,
                $situacao,
                $mestre,
                $value->terminal_pin,
                $value->access,
                $groupButton,
            ];
        }
        return $this->response->setJSON($data);
    }

    public function deliveryData()
    {
        $data = [];
        $orders = [
            'cartoes.id_evento',
            'categorias.tipo',
            'cartoes.id_categoria',
            'cartoes.cartao',
            'cartoes.nome',
            'cartoes.situacao',
            'cartoes.mestre',
            'terminal.terminal_pin',
            '9',
            '',
        ];
       
        $busca = $this->request->getGet('search');
        
        $model = $this->defaultEntregaRep();

        if ($busca && $busca['value']) {
            $qry = trim($busca['value']);
            $model->where(" concat(cartoes.cartao,cartoes.id,ifnull(cartoes.nome,''),terminal_pin,ifnull(cartoes.rg,''), ifnull(cartoes.cpf,''),ifnull(cartoes.email,'')) like '%$qry%'");
        }

        $pagination = new LibPaginate($model, $this->request, 'data', $orders);

        $pagination->addFilter('cartoes.id_evento', 'event', '=');
        $pagination->addFilter('cartoes.id_categoria', 'category', '=');
    
        if ($this->request->getGetPost('situacao') == 1 || $this->request->getGetPost('situacao')  == '0') {
            $pagination->addFilter('cartoes.situacao', 'situacao', '=');
        }

        if ($this->request->getGetPost('master') == 1 || $this->request->getGetPost('master')  == '0') {
            $pagination->addFilter('cartoes.mestre', 'master', '=');
        }
        
        
        $pagination->addFilter('categorias.tipo', 'type', '=');

        $getLista = (object) $pagination->get();
        $lista = $getLista->data;
        
        $data['recordsTotal'] = $getLista->pagination->rows;
        $data['recordsFiltered'] = $getLista->pagination->rows;
        $data['pagination'] = $getLista->pagination->pages;
        $data['data'] = [];
        foreach ($lista as $value) {
            if ($value->situacao==1) {
                $txSituacao = "<span class=\"badge bg-success\">Ativo</span>";
            } else {
                $txSituacao = "<span class=\"badge bg-danger\">Bloqueado</span>";
            }
            $txMestre="";
            if ($value->mestre==1) {
                $txMestre = "<span class=\"badge bg-info\">Mestre</span>";
            }
      
            $linkEdit = base_url() . "/ticket/{$value->id}";
            $btg = "<a href=\"{$linkEdit}\" class=\"btn btn-sm rounded-circle btn-primary btn-soft mb-2\" data-id=\"{$value->id}\"  data-toggle=\"tooltip\" data-placement=\"top\" title=\"Ir\" ><i class=\"fi fi-menu-dots\"></i></a> ";
            $groupButton = "<div class=\"btn-group\" role=\"group\" aria-label=\"Opções\">{$btg}</dvi>";
            $situacao = "<div class=\"ms-3\">{$txSituacao}</div>";
            $mestre = "<div class=\"ms-3\"><small class=\"d-block\">{$txMestre}</small></div>";
            $data['data'][] = [
                $value->evento,
                $value->tipo,
                $value->categoria,
                $value->cartao,
                $value->nome,
                $situacao,
                $mestre,
                $value->terminal_pin,
                $value->access,
                $groupButton,
            ];
        }
        return $this->response->setJSON($data);
    }

    public function expo()
    {
        $model = $this->defaultRep();

        $pagination = new LibPaginate($model, $this->request, 'data');
        
        $pagination->addFilter('cartoes.id_evento', 'event', '=');
        $pagination->addFilter('cartoes.id_categoria', 'category', '=');
    
        if ($this->request->getGetPost('master') == 1 || $this->request->getGetPost('master')  == '0') {
            $pagination->addFilter('cartoes.mestre', 'master', '=');
        }
        
        $pagination->addFilter('categorias.tipo', 'type', '=');
        $pagination->setRows('100000000000');

        $getLista = (object) $pagination->get();
        $lista=[];
        $lista[]=(object) [
            'evento',
            'tipo',
            'categoria',
            'cartao',
            'nome',
            'email',
            'rg',
            'cpf',
            'campoextra1',
            'campoextra2',
            'create_time',
            'updated_at',
            'credenciado_em',
            'situacao',
            'mestre',
            'terminal_pin',
            'access',
            'first_access',
            'last_access',
        ];
        foreach ($getLista->data as $data) {
            $lista[]=(object) [
                'evento' => $data->evento,
                'tipo' => $data->tipo,
                'categoria' => $data->categoria,
                'cartao' => $data->cartao,
                'nome' => $data->nome,
                'email' => $data->email,
                'rg' => $data->rg,
                'cpf' => $data->cpf,
                'campoextra1' => $data->campoextra1,
                'campoextra2' => $data->campoextra2,
                'create_time' => $data->create_time,
                'updated_at' => $data->updated_at,
                'credenciado_em' => $data->credenciado_em,
                'situacao' => $data->situacao=='1'?'Ativo':'bloqueado',
                'mestre' => $data->mestre=='1'?'sim':'não',
                'terminal' => $data->terminal_pin,
                'access' => (int)$data->access,
                'first_access' => date('d/m/Y H:i:s', strtotime((string) $data->first_access)),
                'last_access' => date('d/m/Y H:i:s', strtotime((string) $data->last_access)),
            ];
        }
        
        return $this->response->setJSON($lista);
    }

    public function deliveryExpo()
    {
        $model = $this->defaultEntregaRep();

        $pagination = new LibPaginate($model, $this->request, 'data');
        
        $pagination->addFilter('cartoes.id_evento', 'event', '=');
        $pagination->addFilter('cartoes.id_categoria', 'category', '=');
    
        if ($this->request->getGetPost('master') == 1 || $this->request->getGetPost('master')  == '0') {
            $pagination->addFilter('cartoes.mestre', 'master', '=');
        }
        
        $pagination->addFilter('categorias.tipo', 'type', '=');
        $pagination->setRows('100000000000');

        $getLista = (object) $pagination->get();
        $lista=[];
        $lista[]=(object) [
            'evento',
            'tipo',
            'categoria',
            'cartao',
            'nome',
            'situacao',
            'mestre',
            'terminal_pin',
            'access',
            'first_access',
            'last_access',
        ];
        foreach ($getLista->data as $data) {
            $lista[]=(object) [
                'evento' => $data->evento,
                'tipo' => $data->tipo,
                'categoria' => $data->categoria,
                'cartao' => $data->cartao,
                'nome' => $data->nome,
                'situacao' => $data->situacao=='1'?'Ativo':'bloqueado',
                'mestre' => $data->mestre=='1'?'sim':'não',
                'terminal' => $data->terminal_pin,
                'access' => (int)$data->access,
                'first_access' => date('d/m/Y H:i:s', strtotime((string) $data->first_access)),
                'last_access' => date('d/m/Y H:i:s', strtotime((string) $data->last_access)),
            ];
        }
        
        return $this->response->setJSON($lista);
    }

    private function defaultRep()
    {
        return $this->model->select("
                cartoes.id,
                cartoes.cartao,
                cartoes.nome,
                cartoes.email,
                cartoes.rg,
                cartoes.cpf,
                cartoes.campoextra1,
                cartoes.campoextra2,
                cartoes.create_time,
                cartoes.updated_at,
                cartoes.credenciado_em,
                eventos.evento,
                categorias.tipo,
                categorias.categoria,
                cartoes.situacao,
                cartoes.mestre,
                terminal.terminal_pin,
                count(distinct case when marcacao.acao = 'PS' then marcacao.id end) as access,
                min(case when marcacao.acao = 'PS' then marcacao.data_acesso end) as first_access,
                max(case when marcacao.acao = 'PS' then marcacao.data_acesso end) as last_access
            ")
        ->join('eventos', 'eventos.id = cartoes.id_evento', 'left')
        ->join('categorias', 'categorias.id = cartoes.id_categoria', 'left')
        ->join('marcacao', 'marcacao.id_pessoa = cartoes.id', 'left')
        ->join('terminal', 'terminal.id = marcacao.terminal', 'left')
        ->groupBy('cartoes.id')
        ->where('marcacao.id is not null');
    }

    private function defaultEntregaRep()
    {
        return $this->model->select("
                cartoes.id,
                cartoes.cartao,
                cartoes.nome,
                eventos.evento,
                categorias.tipo,
                categorias.categoria,
                cartoes.situacao,
                cartoes.mestre,
                terminal.terminal_pin,
                count(distinct case when entrega.acao = 'PS' then entrega.id end) as access,
                min(case when entrega.acao = 'PS' then entrega.data_acesso end) as first_access,
                max(case when entrega.acao = 'PS' then entrega.data_acesso end) as last_access
            ")
        ->join('eventos', 'eventos.id = cartoes.id_evento', 'left')
        ->join('categorias', 'categorias.id = cartoes.id_categoria', 'left')
        ->join('entrega', 'entrega.id_pessoa = cartoes.id', 'left')
        ->join('terminal', 'terminal.id = entrega.terminal', 'left')
        ->groupBy('cartoes.id')
        ->where('entrega.id is not null');
    }

}
