<?php

namespace App\Controllers\Monitor;

use App\Controllers\BaseController;
use App\Models\RegistryModel;
use App\Models\DeviceModel;
use App\Models\PhotoModel;
use App\Models\EventModel;
use App\Libraries\GraphicData;
use App\Libraries\LibJSDB;


class Monitor extends BaseController {

    private RegistryModel $registry;
    private DeviceModel $device;
    private PhotoModel $photo;
    private EventModel $event;
    private LibJSDB $json;
    private GraphicData $graphic;

    public function __construct()
    {
        $this->registry = new RegistryModel();
        $this->device = new DeviceModel();
        $this->photo = new PhotoModel();
        $this->json = new LibJSDB('monitor', true);
        $this->graphic = new GraphicData();
        $this->event = new EventModel();
    }

    public function index()
    {
        $this->addOnView('devices', $this->device->getDevicesCredenciados());
        return view('monitor/index', $this->getViewData());
    }

    public function device($id)
    {
        $this->addOnView('device', $this->device->find($id));
        return view('monitor/monitor', $this->getViewData());
    }

    public function acesso()
    {
        return $this->response->setJSON(
            $this->registry->getMonitor($this->request->getGet('id'))
        );
    }

    public function publico()
    {
        return view('monitor/publico', $this->getViewData());
    }

    public function publicopida()
    {
        return view('monitor/publicopida', $this->getViewData());
    }

    public function review($id = null)
    {
        $getSync = $this->graphic->getSynthTickets();
        if(!empty($id)) {
            $getSync->where('eventos.id', $id);
        }
        $this->addOnView('eventos',  $this->event->findAll());
        $this->addOnView('dataSynth',  $getSync->findAll());
        return view('monitor/review', $this->getViewData());
    }

    public function reviewdata($id=null)
    {
        $resume = $this->graphic->getSynthTickets();
        if(!empty($id)) {
            $resume->where('eventos.id', $id);
        }
        return $this->response->setJSON($resume->findAll());
    }

    public function graphic($id=null)
    {
        $data =(object) [
            'ticket' => $this->getTickes($id)
        ];

        return $this->response->setJSON($data);
    }

    public function state()
    {
        $gets = $this->request->getGet();
        $max = null;
        if(array_key_exists('max', $gets)) {
            $max = $gets['max'];
        }
        $data = (object) [
            'status'=> true,
            'total'=>0,
            'max'=>$max,
            'lastDate'=>date('d/m/Y H:i:s')
        ];

        $rs = $this->registry->getPublico($gets);
        if ($rs) {
            $data->total = $rs->qtd;

            if(!empty($max)) {
                $temp = 0;
                if($rs->qtd > ($max * 0.33) ) {
                    $temp = (int) $rs->qtd - ($max * 0.10);
                }

                if($rs->qtd > ($max * 0.5) ) {
                    $temp = (int) $rs->qtd - ($max * 0.15);
                }

                if($rs->qtd > ($max * 0.75) ) {
                    $temp = (int) $rs->qtd - ($max * 0.20);
                }

                if($rs->qtd > ($max ) ) {
                    $temp = (int) $max;
                }

                $data->total = $temp;
            }
        }
        
        return $this->response->setJSON($data);
    }
    
    public function photo($id)
    {
        $result = $this->photo->where('id_pessoas', intval($id))->first();

        if ($result && $result->foto && strlen($result->foto) > 10) {
            $image = $result->foto;
        } else {
            $image = file_get_contents(WRITEPATH . 'uploads/person.jpg');
        }
        
        $this->response->setHeader('Cache-Control', 'no-cache')
        ->appendHeader('Content-Type', 'image/jpeg');
        echo $image;
    }

    private function getTickes($id=null)
    {
        $resume = $this->graphic->getSynthTickets();
        if(!empty($id)) {
            $resume->where('eventos.id', $id);
        }

        return $this->proccessData(
            $resume->findAll()
        );
    }

    private function proccessData($requestData)
    {
        $data = [];
        foreach ($requestData as $d) {
            //if ( $d->tipo == 'TICKET') {
                $data[]=(object) [
                    "x" => $d->categoria,
                    "y" => $d->tickets_lido_unico
                ];
            //}
        }
        return $data;
    }

    private function configModel($dbConfig = null) {
        return (object)[
            'id' => 1,
            'event_id' => is_object($dbConfig) && property_exists($dbConfig, 'event_id') ? $dbConfig->event_id : null,
            'event_hash' => is_object($dbConfig) && property_exists($dbConfig, 'event_hash') ? $dbConfig->event_hash : null,
            'clientHash' => is_object($dbConfig) && property_exists($dbConfig, 'clientHash') ? $dbConfig->clientHash : null,
            'sync_id' => is_object($dbConfig) && property_exists($dbConfig, 'sync_id') ? $dbConfig->sync_id : null,
            'sync_register_id' => is_object($dbConfig) && property_exists($dbConfig, 'sync_register_id') ? $dbConfig->sync_register_id : null,
            'sync_image_id' => is_object($dbConfig) && property_exists($dbConfig, 'sync_image_id') ? $dbConfig->sync_image_id : null,
            'host' => is_object($dbConfig) && property_exists($dbConfig, 'host') ? $dbConfig->host : 'api.ws.cloudid.com.br',
            'port' => is_object($dbConfig) && property_exists($dbConfig, 'port') ? $dbConfig->port : '9002',
        ];
    }

}
