<?php

namespace App\Controllers\Integration;

use App\Controllers\BaseController;
use App\Models\TicketeiraEventoModel;
use App\Models\TicketeiraModel;
use App\Models\EventModel;
use App\Entities\TicketeiraEventoEntity;

class Integration extends BaseController
{

    private TicketeiraModel $ticketeira;
    private EventModel $event;
    private TicketeiraEventoEntity $integration;

    public function __construct()
    {
        $this->model = new TicketeiraEventoModel();
        $this->integration = new TicketeiraEventoEntity();
        $this->ticketeira = new TicketeiraModel();
        $this->event = new EventModel();
    }

    public function initController($request, $response, $logger)
    {
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);
        if (!$this->authUser->logged()) {
            return redirect()->route("auth/signin");
        }
    }

    public function index()
    {
        $this->addOnView('ticketeiras', $this->model->getAllDetails());
        return view('integration/index', $this->getViewData());
    }

    public function add()
    {
        $this->addOnView('integration', $this->integration);
        $this->addOnView('ticketeiras', $this->ticketeira->findAll());
        $this->addOnView('events', $this->event->findAll());
        return view('integration/edit', $this->getViewData());
    }

    public function edit($id)
    {
        $url = previous_url() ?? base_url();
        $result = $this->model->find($id);
        if ($result) {
            $this->addOnView('integration', $result);
            $this->addOnView('ticketeiras', $this->ticketeira->findAll());
            $this->addOnView('events', $this->event->findAll());
            return view('integration/edit', $this->getViewData());
        } else {
            $this->authUser->setFlashdata('error', 'Integração inválida');
            return redirect()->to($url);
        }
    }

    public function addsave()
    {
        $this->integration->fill($this->request->getPost());
        $this->integration->active = $this->integration->active == '1' ? '1' : '0';
        $url = previous_url() ?? base_url();
        $update = $this->model->save($this->integration->toArray());
        if (!empty($update)) {
            $this->authUser->setFlashdata('success', 'Integração criada com sucesso');
            return redirect()->to('/integration');
        } else {
            $this->authUser->setFlashdata('error', $update->message);
            return redirect()->to($url);
        }
    }

    public function save($id)
    {
        $url = previous_url() ?? base_url();
        $this->integration->fill($this->request->getPost());
        $this->integration->id = $id;
        $this->integration->active = $this->integration->active == '1' ? '1' : '0';
        
        $result = $this->model->save($this->integration->toArray());
        if ($result) {
            $this->authUser->setFlashdata('success', 'Integração atualizada com sucesso');
            return redirect()->to('/integration');
        } else {
            $this->authUser->setFlashdata('error', 'Integração inválida');
            return redirect()->to($url);
        }
    }

}
