<?php

namespace App\Controllers\Event;

use App\Controllers\BaseController;
use App\Libraries\LibJSDB;
use App\Models\TicketModel;
use App\Models\EventModel;
use App\Models\CategoryModel;
use App\Libraries\SyncApi\SyncApi;
use App\Libraries\LibSync;

class Sync extends BaseController
{

    private LibJSDB $json;
    private SyncApi $syncApi;
    private LibSync $lsync;
    private TicketModel $ticket;
    private EventModel $event;
    private CategoryModel $category;

    public function __construct()
    {
        $this->json = new LibJSDB('sync', true);
        $this->ticket = new TicketModel();
        $this->event = new EventModel();
        $this->category = new CategoryModel();
        $this->syncApi = new SyncApi();
        $this->lsync = new LibSync();
    }

    public function initController($request, $response, $logger)
    {
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);
        if (!$this->authUser->logged()) {
            return redirect()->route("auth/signin");
        }
    }

    public function config()
    {
        $sync = $this->json->getFirst();
        $config = $this->configModel($sync);
        $this->addOnView('sync', $config);
        return view('sync/config', $this->getViewData());
    }
    public function startsync()
    {
        $sync = $this->json->getFirst();
        $config = $this->configModel($sync);
        $this->addOnView('sync', $config);
        return view('sync/start', $this->getViewData());
    }
    public function syncconfig()
    {
        $sync = $this->json->getFirst();
        $config = $this->configModel($sync);
        return $this->response->setJSON($config);
    }
    public function saveConfig()
    {
        $data=[
            'id'=> 1,
            'event_id'=> (int) $this->request->getPost('event_id'),
            'event_hash'=> $this->request->getPost('event_hash'),
            'clientHash'=> $this->request->getPost('clientHash'),
            'host'=> $this->request->getPost('host'),
            'port'=> (int) $this->request->getPost('port'),
            'sync_id'=> (int) $this->request->getPost('sync_id'),
            'sync_register_id'=> (int) $this->request->getPost('sync_register_id'),
            'sync_image_id'=> (int) $this->request->getPost('sync_image_id')
        ];
        $this->json->createOrUpdate(['id'=>1] ,$data);
        $this->authUser->setFlashdata('success', "Atualizado com sucesso.");
        return redirect()->to('manage/sync');
    }
    public function syncevent()
    {
        $config = $this->configModel($this->json->getFirst());
        $this->setSyncAttr($config);
        $data = $this->syncApi->sync->getAll($config->sync_id);
        $this->lsync->setAll($data->sync);
        $config->sync_id = $data->sync->lastSync;
        $this->json->createOrUpdate(['id'=>1] ,$config);
    }
    public function syncsendevent()
    {
        $config = $this->configModel($this->json->getFirst());
        $tickets = $this->lsync->getAll();
        $data = [];
        if (!$tickets) {
            foreach ($tickets as $ticket) {
                $data[] =(object) [
                    "event_id" => $config->event_id,
                    "cod" => $ticket->cartao,
                    "multipass" => $ticket->mestre,
                    "category_id" => $ticket->category_external_id,
                    "active" => $ticket->situacao,
                    "status_id" => "1",
                    "client_sync_id" => null
                ];
            }
        }
        $data = $this->syncApi->sync->getAll($config->sync_id);
        $config->sync_id = $data->sync->lastSync;
        $this->json->createOrUpdate(['id'=>1] ,$config);
    }
    public function syncregister()
    {
        $config = $this->configModel($this->json->getFirst());
        $this->setSyncAttr($config);
        $data = $this->syncApi->sync->getRegister($config->sync_register_id);
        $this->lsync->getRegister($data->syncRegister);
        $config->sync_register_id = $data->syncRegister->lastSync;
        $this->json->createOrUpdate(['id'=>1], $config);
    }
    public function syncimage()
    {
        $config = $this->configModel($this->json->getFirst());
        $this->setSyncAttr($config);
        $data = $this->syncApi->sync->getImages($config->sync_image_id);
        $this->lsync->getImage($data->syncRegister);
        $config->sync_image_id = $data->syncRegister->lastSync;
        $this->json->createOrUpdate(['id'=>1], $config);
    }
    

    private function configModel($dbConfig = null) {
        return (object)[
            'id' => 1,
            'event_id' => is_object($dbConfig) && property_exists($dbConfig, 'event_id') ? $dbConfig->event_id : null,
            'event_hash' => is_object($dbConfig) && property_exists($dbConfig, 'event_hash') ? $dbConfig->event_hash : null,
            'clientHash' => is_object($dbConfig) && property_exists($dbConfig, 'clientHash') ? $dbConfig->clientHash : null,
            'sync_id' => is_object($dbConfig) && property_exists($dbConfig, 'sync_id') ? $dbConfig->sync_id : null,
            'sync_register_id' => is_object($dbConfig) && property_exists($dbConfig, 'sync_register_id') ? $dbConfig->sync_register_id : null,
            'sync_image_id' => is_object($dbConfig) && property_exists($dbConfig, 'sync_image_id') ? $dbConfig->sync_image_id : null,
            'host' => is_object($dbConfig) && property_exists($dbConfig, 'host') ? $dbConfig->host : 'api.ws.cloudid.com.br',
            'port' => is_object($dbConfig) && property_exists($dbConfig, 'port') ? $dbConfig->port : '9002',
        ];
    }

    private function setSyncAttr($data) {
        $this->syncApi->sync->setUrl($data->host);
        $this->syncApi->sync->setEventId($data->event_id);
        $this->syncApi->sync->setEventHash($data->event_hash);
        $this->syncApi->sync->setClientHash($data->clientHash);
    }

}