<?php

namespace App\Controllers\Event;

use App\Controllers\BaseController;
use App\Models\TicketModel;
use App\Models\EventModel;
use App\Models\RegistryModel;
use App\Models\CategoryModel;
use App\Models\PhotoModel;
use App\Models\GroupItemModel;
use App\Models\UserModel;
use App\Models\ImportModel;
use App\Models\ImportCategoryModel;

class ManageSympla extends BaseController
{
    private TicketModel $ticket;
    private EventModel $event;
    private CategoryModel $category;
    private RegistryModel $register;
    private PhotoModel $photo;
    private GroupItemModel $grupoItem;
    private UserModel $user;
    private ImportModel $import;
    private ImportCategoryModel $importCategory;

    public function __construct()
    {
        $this->ticket = new TicketModel();
        $this->event = new EventModel();
        $this->category = new CategoryModel();
        $this->register = new RegistryModel();
        $this->photo = new PhotoModel();
        $this->grupoItem = new GroupItemModel();
        $this->user = new UserModel();
        $this->import = new ImportModel();
        $this->importCategory = new ImportCategoryModel();
    }

    public function initController($request, $response, $logger)
    {
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);
        if (!$this->authUser->logged()) {
            return redirect()->route("auth/signin");
        }
    }


    public function import()
    {
        $this->addOnView('events', $this->event->findAll());
        $this->addOnView('imports', $this->import->where([
            'processado' => 'N',
            'ticketeira_id' => 1,
        ])->findAll());
        return view('sympla/import', $this->getViewData());
    }

    public function importTicket()
    {
        $input = $this->validate([
            'file' => 'uploaded[file]|max_size[file,8192]|ext_in[file,csv],'
        ]);

        if (!$input) {
            $data['validation'] = $this->validator;
            $this->authUser->setFlashdata('error', "Arquivo inválido.");
            return redirect()->to('manage/importsympla');
        }

        $file = $this->request->getFile('file');
        if ($file->isValid() && !$file->hasMoved()) {
            $newName = $file->getRandomName();
            $fileText = 'uploads/' . $newName;
            $file->move(WRITEPATH . 'uploads/', $newName);
            $import = (object) [
                'evento_id' => (int) $this->request->getPost('id_evento'),
                'processado' => 'N',
                'filetext' => $fileText,
                'datahora' => date('Y-m-d H:i:s'),
                'ticketeira_id' => 1
            ];
            $idImport = $this->import->insert($import);
            if ($idImport) {
                $this->authUser->setFlashdata('success', "Arquivo preparado.");
                return redirect()->to("manage/importsymplaproccess/{$idImport}");
            }
        } else {
            $this->authUser->setFlashdata('error', "Arquivo inválido.");
        }

        return redirect()->to('manage/importsympla');
    }

    public function removeproccess($id)
    {
        $import = $this->import->find($id);
        if (!$import) {
            $this->authUser->setFlashdata('error', "Fila inválida ({$id}).");
            return redirect()->to('manage/importsympla');
        }

        if ($import->processado == 'Y') {
            $this->authUser->setFlashdata('error', "Fila ({$id}) já processada.");
            return redirect()->to('manage/importsympla');
        }
        $this->import->delete($id);
        $fileText = WRITEPATH . '/' . $import->filetext;
        delete_files($fileText);
        $this->authUser->setFlashdata('success', "Arquivo excluido.");
        return redirect()->to('manage/importsympla');
    }

    public function process($id)
    {
        $import = $this->import->find($id);

        if (!$import) {
            $this->authUser->setFlashdata('error', "Fila inválida ({$id}).");
            return redirect()->to('manage/importsympla');
        }

        if ($import->processado == 'Y') {
            $this->authUser->setFlashdata('error', "Fila ({$id}) já processada.");
            return redirect()->to('manage/importsympla');
        }
        $fileText = WRITEPATH . '/' . $import->filetext;
        $file = fopen($fileText, "r");
        $i = 0;

        $csvImportCategoryName = array();
        while (($filedata = fgetcsv($file, 1000, ";")) !== FALSE) {
            if (
                is_array($filedata)
                && $i >= 0
                && count($filedata) >= 14
                && strcmp('ordem', strtolower($filedata[0])) != 0
                && strcmp(strtolower('Tipo de ingresso'), strtolower($filedata[4])) != 0
            ) {
                $csvImportCategoryName[$filedata[4]] = $i++;
                if ($csvImportCategoryName[$filedata[4]]) {
                    $csvImportCategoryName[$filedata[4]]++;
                } else {
                    $csvImportCategoryName[$filedata[4]] = 1;
                }
                $i++;
            }
        }
        fclose($file);
        foreach ($csvImportCategoryName as $k => $v) {
            $category_id = null;
            if ($k) {
                $category = $this->category->like('categoria', strstr($k, ' ', true))->first();
                if ($category) {
                    $category_id = $category->id;
                }
            }

            if (!$this->importCategory->where([
                'import_id' => $import->id,
                'import_name' => $k
            ])->first()) {
                $this->importCategory->insert([
                    'import_id' => $import->id,
                    'import_name' => $k,
                    'category_id' => $category_id,
                ]);
            }
        }
        return redirect()->to("manage/importsympla/{$import->id}/selcategory");
    }

    public function selectCategory($id)
    {
        $import = $this->import->find($id);

        if (!$import) {
            $this->authUser->setFlashdata('error', "Fila inválida ({$id}).");
            return redirect()->to('manage/importsympla');
        }

        if ($import->processado == 'Y') {
            $this->authUser->setFlashdata('error', "Fila ({$id}) já processada.");
            return redirect()->to('manage/importsympla');
        }

        $this->addOnView('import', $import);
        $this->addOnView('categories', $this->category->findAll());
        $this->addOnView(
            'importCategory',
            $this->importCategory
                ->where('import_id', $import->id)
                ->orderBy('category_id desc, import_name asc')
                ->findAll()
        );
        return view('sympla/importcategory', $this->getViewData());
    }

    public function processasympla($id)
    {
        $data = ($this->request->getJSON());
        $this->associaCategoria($data->data);
        return $this->response->setJSON($this->importaDados($id));
    }

    private function associaCategoria($data)
    {
        foreach ($data as $k => $item) {
            $this->importCategory->update($item->importCategoryId, [
                'category_id' => $item->category
            ]);
        }
    }

    private function importaDados($id)
    {
        $import = $this->import->find($id);

        if (!$import) {
            $this->authUser->setFlashdata('error', "Fila inválida ({$id}).");
            return redirect()->to('manage/importsympla');
        }

        if ($import->processado == 'Y') {
            $this->authUser->setFlashdata('error', "Fila ({$id}) já processada.");
            return redirect()->to('manage/importsympla');
        }

        $fileText = WRITEPATH . '/' . $import->filetext;
        $file = fopen($fileText, "r");
        $sts = (object)[
            'tickets' => 0,
            'inserted' => 0,
            'updated' => 0,
            'access' => 0,
        ];

        while (($filedata = fgetcsv($file, 1000, ";")) !== false) {
            if (
                is_array($filedata)
                && count($filedata) >= 14
                && strcmp('ordem', strtolower($filedata[0])) != 0
                && strcmp(strtolower('Tipo de ingresso'), strtolower($filedata[4])) != 0
            ) {
                $sts->tickets++;
                $csvArr = array();
                $csvArr['id_evento'] =  $import->evento_id;
                $csvArr['import_id'] =  $import->id;
                $csvArr['ticketeira_updated_at'] =  date('Y-m-d H:i:s');
                $csvArr['cartao'] =  $filedata[1];
                $csvArr['nome'] =  trim($filedata[2] . ' ').' '.trim($filedata[3] . ' ');
                $csvArr['email'] =  $filedata[8];
                $csvArr['campoextra1'] =  $filedata[4];
                $csvArr['campoextra2'] =  $filedata[7];
                $csvArr['id_categoria'] =  $this->getCategory($import->id, $filedata[4]);
                $csvArr['situacao'] =  $filedata[9] == 'Aprovado' ? 1 : 0;
                $csvArr['mestre'] = 0;
                $csvArr['ticketeira_id'] = 1;

                $ticket = $this->ticket->where([
                    'id_evento' => $csvArr['id_evento'],
                    'cartao' => $csvArr['cartao'],
                ])->first();

                if ($ticket) {
                    $this->ticket->update($ticket->id, $csvArr);
                    $sts->updated++;
                    if (strcmp($filedata[10], 'Sim') == 0) {
                        $this->setCheckin($ticket, $filedata[11]);
                        $sts->access++;
                    }
                } else {
                    $insertId = $this->ticket->insert($csvArr);
                    $sts->inserted++;
                    if ($insertId && strcmp($filedata[10], 'Sim') == 0) {
                        $ticket = $this->ticket->find($insertId);
                        $this->setCheckin($ticket, $filedata[11]);
                        $sts->access++;
                    }
                }
                
            }
        }
        fclose($file);
        $this->import->update($id, ['processado' => 'Y']);
        return $sts;
    }

    private function setCheckin($ticket, $dataHora)
    {
        $register = $this->register->where([
            'id_pessoa' => $ticket->id,
            'data_acesso' => $dataHora,
        ])->first();

        if (!$register) {
            $this->register->insert([
                'id_pessoa' => $ticket->id,
                'id_evento' => $ticket->id_evento,
                'cartao' => $ticket->cartao,
                'data_acesso' => $dataHora,
                'acao' => 'PS',
                'terminal' => 'SYMPLA',
                'giro',
                'remote_id',
                'send_on'
            ]);
        }
    }

    private function getCategory($importId, $categoryName)
    {
        $rs = $this->importCategory->where([
            'import_id' => $importId,
            'import_name' => $categoryName
        ])->first();

        if ($rs) {
            return $rs->category_id;
        }
        return null;
    }
}
