<?php

namespace App\Controllers\Event;

use App\Controllers\BaseController;
use App\Models\TicketModel;
use App\Models\EventModel;
use App\Models\RegistryModel;
use App\Models\CategoryModel;
use App\Models\PhotoModel;
use App\Models\GroupItemModel;
use App\Models\UserModel;
use App\Models\ImportModel;
use App\Models\ImportCategoryModel;

class ManageCredenciart extends BaseController
{
    private TicketModel $ticket;
    private EventModel $event;
    private CategoryModel $category;
    private RegistryModel $register;
    private PhotoModel $photo;
    private GroupItemModel $grupoItem;
    private UserModel $user;
    private ImportModel $import;
    private ImportCategoryModel $importCategory;

    public function __construct()
    {
        $this->ticket = new TicketModel();
        $this->event = new EventModel();
        $this->category = new CategoryModel();
        $this->register = new RegistryModel();
        $this->photo = new PhotoModel();
        $this->grupoItem = new GroupItemModel();
        $this->user = new UserModel();
        $this->import = new ImportModel();
        $this->importCategory = new ImportCategoryModel();
    }

    public function initController($request, $response, $logger)
    {
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);
        if (!$this->authUser->logged()) {
            return redirect()->route("auth/signin");
        }
    }


    public function import()
    {
        $this->addOnView('events', $this->event->findAll());
        $this->addOnView('imports', $this->import->where([
            'processado' => 'N',
            'ticketeira_id' => 2,
        ])->findAll());
        return view('credenciart/import', $this->getViewData());
    }

    public function importTicket()
    {
        $input = $this->validate([
            'file' => 'uploaded[file]|ext_in[file,csv]'
        ]);

        if (!$input) {
            $data['validation'] = $this->validator;
            $this->authUser->setFlashdata('error', "Arquivo inválido.");
            return redirect()->to('manage/importcredenciart');
        }

        $file = $this->request->getFile('file');
        if ($file->isValid() && !$file->hasMoved()) {
            $newName = $file->getRandomName();
            $fileText = 'uploads/' . $newName;
            $file->move(WRITEPATH . 'uploads/', $newName);
            $import = (object) [
                'evento_id' => (int) $this->request->getPost('id_evento'),
                'processado' => 'N',
                'filetext' => $fileText,
                'datahora' => date('Y-m-d H:i:s'),
                'ticketeira_id' => 2
            ];
            $idImport = $this->import->insert($import);
            if ($idImport) {
                $this->authUser->setFlashdata('success', "Arquivo preparado.");
            }
        } else {
            $this->authUser->setFlashdata('error', "Arquivo inválido.");
        }

        return redirect()->to('manage/importcredenciart');
    }

    public function removeproccess($id)
    {
        $import = $this->import->find($id);
        if (!$import) {
            $this->authUser->setFlashdata('error', "Fila inválida ({$id}).");
            return redirect()->to('manage/importcredenciart');
        }

        if ($import->processado == 'Y') {
            $this->authUser->setFlashdata('error', "Fila ({$id}) já processada.");
            return redirect()->to('manage/importcredenciart');
        }
        $this->import->delete($id);
        $fileText = WRITEPATH . '/' . $import->filetext;
        if(is_file($fileText)) {
            unlink($fileText);
        }
        // delete_files($fileText);
        $this->authUser->setFlashdata('success', "Arquivo excluido.");
        return redirect()->to('manage/importcredenciart');
    }

   
}
