<?php

namespace App\Controllers\Event;

use App\Controllers\BaseController;
use App\Models\TicketModel;
use App\Models\EventModel;
use App\Models\RegistryModel;
use App\Models\CategoryModel;
use App\Models\PhotoModel;
use App\Models\GroupItemModel;
use App\Models\ImportModel;
use App\Models\ImportCategoryModel;
use App\Models\TicketeiraEventoModel;
use App\Models\UserModel;

class Manage extends BaseController
{

    private TicketModel $ticket;
    private EventModel $event;
    private CategoryModel $category;
    private RegistryModel $register;
    private PhotoModel $photo;
    private GroupItemModel $grupoItem;
    private ImportModel $import;
    private ImportCategoryModel $importCategory;
    private TicketeiraEventoModel $ticketeiraEvent;
    private UserModel $user;
    private Array $eventList;
    private Array $categoryList;

    public function __construct()
    {
        $this->ticket = new TicketModel();
        $this->event = new EventModel();
        $this->category = new CategoryModel();
        $this->register = new RegistryModel();
        $this->photo = new PhotoModel();
        $this->grupoItem = new GroupItemModel();
        $this->user = new UserModel();
        $this->import = new ImportModel();
        $this->importCategory = new ImportCategoryModel();
        $this->ticketeiraEvent = new TicketeiraEventoModel();
        $this->eventList = [];
        $this->categoryList = [];
    }

    public function initController($request, $response, $logger)
    {
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);
        if (!$this->authUser->logged()) {
            return redirect()->route("auth/signin");
        }
    }

    public function generate()
    {
        $this->addOnView('events', $this->event->findAll());
        $this->addOnView('categories', $this->category->findAll());
        return view('manage/generate', $this->getViewData());
    }

    public function import()
    {
        $this->addOnView('events', $this->event->findAll());
        $this->addOnView('categories', $this->category->findAll());
        return view('manage/import', $this->getViewData());
    }

    public function importAlter()
    {
        $this->addOnView('events', $this->event->findAll());
        $this->addOnView('categories', $this->category->findAll());
        return view('manage/importalter', $this->getViewData());
    }

    public function export()
    {
        $this->addOnView('events', $this->event->findAll());
        $this->addOnView('categories', $this->category->findAll());
        return view('manage/export', $this->getViewData());
    }

    public function database()
    {

        $resume = (object)[
            'totalTickets' => (int) $this->ticket->get()->getNumRows(),
            'totalActiveTickets' => (int) $this->ticket->where('situacao', '1')->get()->getNumRows(),
            'totalRegister' => (int) $this->register->get()->getNumRows(),
            'totalDistinctRegister' => (int) $this->register->groupBy('id_pessoa')->distinct()->get()->getNumRows(),
        ];
        $resume->percent = (int) $resume->totalActiveTickets > 0 ? ($resume->totalActiveTickets / $resume->totalTickets) * 100 : 0;
        $this->addOnView('resume', $resume);
        $this->addOnView('events', $this->event->findAll());
        $this->addOnView('categories', $this->category->findAll());
        return view('manage/database', $this->getViewData());
    }
    public function databaseData()
    {
        $output = (object)[
            'totalTickets' => (int) $this->ticket->get()->getNumRows(),
            'totalActiveTickets' => (int) $this->ticket->where('situacao', '1')->get()->getNumRows(),
            'totalRegister' => (int) $this->register->get()->getNumRows(),
            'totalDistinctRegister' => (int) $this->register->groupBy('id_pessoa')->distinct()->get()->getNumRows(),
        ];
        $output->percent = intval($output->totalActiveTickets > 0 ? ($output->totalActiveTickets / $output->totalTickets) * 100 : 0);
        return $this->response->setJSON($output);
    }

    public function databaseProcess()
    {
        $data = (object) $this->request->getPost();
        if ($data->act == 'register') {
            $data->response = $this->clearRegister();
        }

        if ($data->act == 'changestatus') {
            $data->response = $this->changeStatus($data);
        }

        if ($data->act == 'removeticket') {
            $data->response = $this->removeTicket($data);
        }
        if ($data->act == 'removeAll') {
            $data->response = $this->removeAll($data);
        }
        return $this->response->setJSON($data);
    }
    public function createTicket()
    {
        $user = $this->authUser->getUser();
        $data = (object)[
            'id_evento' => (int) $this->request->getPost('id_evento'),
            'id_categoria' => (int) $this->request->getPost('id_categoria'),
            'situacao' => (int) $this->request->getPost('situacao') == 1 ? 1 : 0,
            'mestre' => (int) $this->request->getPost('mestre') == 1 ? 1 : 0,
            'campoextra1' => (string) $this->request->getPost('campoextra1'),
            'campoextra2' => (string) $this->request->getPost('campoextra2'),
            'user_id' => $user->id
        ];
        $qtd_ticket = (int) $this->request->getPost('qtd_ticket');
        $size = (int) $this->request->getPost('size');
        $this->ticketGenerate($data, $qtd_ticket, $size);
        $this->authUser->setFlashdata('success', "Criado {$qtd_ticket} Tickets.");
        return redirect()->to('manage/generate');
    }

    public function exportTicket()
    {
        $data = (object)[
            'id_evento' => (int) $this->request->getPost('id_evento'),
            'id_categoria' => $this->request->getPost('id_categoria'),
            'situacao' => $this->request->getPost('status'),
            'mestre' => $this->request->getPost('mestre'),
            'leitura' => $this->request->getPost('leitura'),
            'filetype' => $this->request->getPost('filetype'),
            'orders' => $this->request->getPost('order'),
        ];

        $result = $this->exportFile($data);
        if (!$result) {
            return null;
        }
        $util = \CodeIgniter\Database\Config::utils();
        $this->response->setHeader('Cache-Control', 'no-cache');
        $this->response->appendHeader('Cache-Control', 'must-revalidate');
        $this->response->appendHeader('Content-Description', 'File Transfer');
        $this->response->appendHeader('Content-Transfer-Encoding', 'binary');
        $this->response->appendHeader('Connection', 'Keep-Alive');
        $this->response->appendHeader('Expires', 'must-revalidate');
        $this->response->appendHeader('Pragma', 'public');
        $filename = 'export_' . date('YmdHis');
        if ($data->filetype == 'csv') {
            $this->response->appendHeader('Content-Disposition', "attachment; filename={$filename}.csv");
            $this->response->setContentType('text/csv; charset=utf-8');
            return $this->response->setBody($util->getCSVFromResult($result));
        } elseif ($data->filetype == 'json') {
            $this->response->appendHeader('Content-Disposition', "attachment; filename={$filename}.json");
            $this->response->setContentType('application/json; charset=UTF-8');
            return $this->response->setJSON($result->getResult());
        } elseif ($data->filetype == 'xml') {
            $this->response->appendHeader('Content-Disposition', "attachment; filename={$filename}.xml");
            $this->response->setContentType('application/xml; charset=utf-8');
            return $this->response->setBody($util->getXMLFromResult($result));
        }
    }

    public function importTicket()
    {
        $user = $this->authUser->getUser();
        $input = $this->validate([
            'file' => 'uploaded[file]|max_size[file,65536]|ext_in[file,csv],'
        ]);

        if (!$input) {
            $data['validation'] = $this->validator;
            $this->authUser->setFlashdata('error', "Arquivo inválido.");
            return view('manage/import', $this->getViewData());
        }

        $data = (object)[
            'id_evento' => (int) $this->request->getPost('id_evento'),
            'id_categoria' => (int) $this->request->getPost('id_categoria'),
            'situacao' => (int) $this->request->getPost('situacao') == 1 ? 1 : 0,
            'mestre' => (int) $this->request->getPost('mestre') == 1 ? 1 : 0,
            'user_id' => $user->id
        ];

        $file = $this->request->getFile('file');
        $count = 0;
        $ticketExceptions = [];
        if ($file->isValid() && !$file->hasMoved()) {
            $newName = $file->getRandomName();
            $file->move(WRITEPATH . 'uploads/', $newName);
            $file = fopen(WRITEPATH . 'uploads/' . $newName, "r");
            $i = 0;
            $csvArr = array();
            // Ticket, Nome, Email, RG, CPF, CE1, CE2, Status, Mestre
            while (($filedata = fgetcsv($file, 1000, ",")) !== FALSE) {
                $num = count($filedata) - 1;

                // if ($i > 0) {
                if ($filedata[0] != "name") {
                    $csvArr[$i]['id_evento'] = $data->id_evento;
                    $csvArr[$i]['id_categoria'] = $data->id_categoria;
                    $csvArr[$i]['user_id'] = $data->user_id;

                    $csvArr[$i]['cartao'] =  $filedata[0];
                    $csvArr[$i]['nome'] = $num >= 1 ? $filedata[1] : null;
                    $csvArr[$i]['email'] = $num >= 2 ? $filedata[2] : null;
                    $csvArr[$i]['rg'] = $num >= 3 ? $filedata[3] : null;
                    $csvArr[$i]['cpf'] = $num >= 4 ? $filedata[4] : null;
                    $csvArr[$i]['campoextra1'] = $num >= 5 ? $filedata[5] : null;
                    $csvArr[$i]['campoextra2'] = $num >= 6 ? $filedata[6] : null;
                    $csvArr[$i]['situacao'] = $num >= 7 ? $filedata[7] : $data->situacao;
                    $csvArr[$i]['mestre'] = $num >= 8 ? $filedata[8] : $data->mestre;
                }
                $i++;
            }
            fclose($file);
           
            foreach ($csvArr as $ticket) {
                try {
                    $this->insertTicket($ticket);
                    $count++;
                } catch (\Exception $e) {
                    $ticket['exception'] = $e->getMessage();
                    $ticketExceptions[] = $ticket;
                }
            }
        }
        $this->addOnView('event', $this->event->find($data->id_evento));
        $this->addOnView('category', $this->category->find($data->id_categoria));
        $this->addOnView('count', $count);
        $this->addOnView('ticketExceptions', $ticketExceptions);
        return view('manage/imported', $this->getViewData());
    }

    public function importAlterTicket()
    {
        set_time_limit(0);
        $user = $this->authUser->getUser();
        $input = $this->validate([
            'file' => 'uploaded[file]|max_size[file,65536]|ext_in[file,csv],'
        ]);

        $events = [];

        if (!$input) {
            $data['validation'] = $this->validator;
            $this->authUser->setFlashdata('error', "Arquivo inválido.");
            return view('manage/importalter', $this->getViewData());
        }



        $data = (object)[
            'situacao' => 1,
            'mestre' => 0,
            'user_id' => $user->id
        ];

        $file = $this->request->getFile('file');
        $count = 0;
        $ticketExceptions = [];
        if ($file->isValid() && !$file->hasMoved()) {
            $newName = $file->getRandomName();
            $file->move(WRITEPATH . 'uploads/', $newName);
            $file = fopen(WRITEPATH . 'uploads/' . $newName, "r");
            $i = 0;
            $csvArr = array();
            // Ticket, Nome, Email, RG, CPF, CE1, CE2, Status, Mestre
            while (($filedata = fgetcsv($file, 1000, ",")) !== FALSE) {
                $num = count($filedata) - 1;

                if ($i > 0) {
                    $csvArr[$i]['id_evento'] = $this->getArrEvent($filedata[3]);
                    $csvArr[$i]['id_categoria'] = $this->getArrCategory($filedata[4]);
                    $csvArr[$i]['user_id'] = $data->user_id;

                    $csvArr[$i]['cartao'] =  $filedata[2];
                    $csvArr[$i]['nome'] = $filedata[0];
                    $csvArr[$i]['campoextra1'] = $filedata[1];
                    $csvArr[$i]['campoextra2'] = $filedata[3];
                    $csvArr[$i]['situacao'] =  $data->situacao;
                    $csvArr[$i]['mestre'] = $data->mestre;
                }
                $i++;
            }
            fclose($file);
           
            foreach ($csvArr as $ticket) {
                try {
                    $this->insertTicket($ticket);
                    $count++;
                } catch (\Exception $e) {
                    $ticket['exception'] = $e->getMessage();
                    $ticketExceptions[] = $ticket;
                }
            }
        }

        $this->addOnView('count', $count);
        $this->addOnView('ticketExceptions', $ticketExceptions);
        return view('manage/imported', $this->getViewData());
    }

    private function insertTicket($data)
    {
        $rs=$this->ticket->where([
            'id_evento' => $data['id_evento'],
            'cartao' => $data['cartao']
        ])->first();
        if(!empty($rs)) {
            $card = $data['cartao'];
            return $this->ticket->update($rs->id, $data);
        }
        return $this->ticket->insert($data);
    }

    private function ticketGenerate($dataTicket, $qtd, $size = 8)
    {

        $contErros = 0;

        for ($i = 0; $i < $qtd; $i++) {
            $codigo = uniqid(rand(), true) . uniqid(rand(), true) . uniqid(rand(), true);
            $codigo = preg_replace("/[^0-9\s]/", "", $codigo);
            $codigo = substr($codigo, 0, $size);
            $data = array(
                'id_evento' => $dataTicket->id_evento,
                'id_categoria' => $dataTicket->id_categoria,
                'situacao' => $dataTicket->situacao,
                'mestre' => $dataTicket->mestre,
                'campoextra1' => $dataTicket->campoextra1,
                'campoextra2' => $dataTicket->campoextra2,
                'id_user' => $dataTicket->user_id,
                'cartao' => $codigo,
            );

            try {
                $this->ticket->insert($data);
            } catch (\Exception $e) {
                $contErros++;
            }
        }

        if ($contErros > 0) {
            $this->ticketGenerate($dataTicket, $contErros);
        }
    }

    private function exportFile($data)
    {

        $orders = $data->orders;
        $fields = [
            'cod' => 'cartoes.cartao',
            'id' => 'cartoes.id',
            'nome' => 'cartoes.nome',
            'rg' => 'cartoes.rg',
            'cpf' => 'cartoes.cpf',
            'email' => 'cartoes.email',
            'campoextra1' => 'cartoes.campoextra1',
            'campoextra2' => 'cartoes.campoextra2',
            'situacao' => 'cartoes.situacao',
            'mestre' => 'cartoes.mestre',
            'categoria' => 'categorias.categoria',
            'id_categoria' => 'categorias.id as categoria_id',
            'leitura' => 'min(marcacao.data_acesso) as data_acesso',
        ];

        $select = [];
        $headers = [];
        foreach ($orders as $k => $field) {
            if (array_key_exists($field, $fields)) {
                $select[] = $fields[$field];
                $headers[] = $k;
            }
        }

        $rs = $this->ticket->select($select)
            ->join('categorias', 'categorias.id = cartoes.id_categoria', 'left')
            ->join('marcacao', 'marcacao.id_pessoa = cartoes.id', 'left')
            ->groupBy('cartoes.id');
        $rs->where('cartoes.id_evento', $data->id_evento);

        if (!empty($data->id_categoria)) {
            $rs->where('cartoes.id_categoria', $data->id_categoria);
        }

        if (!empty($data->id_categoria)) {
            $rs->where('cartoes.id_categoria', $data->id_categoria);
        }

        if (!empty($data->leitura)) {
            if ($data->leitura == 1) {
                $rs->where('marcacao.id_pessoa is not null');
            } elseif ($data->leitura == 2) {
                $rs->where('marcacao.id_pessoa is null');
            }
        }

        if (!empty($data->situacao)) {
            if ($data->situacao == 1) {
                $rs->where('cartoes.situacao', 1);
            } elseif ($data->situacao == 2) {
                $rs->where('cartoes.situacao', 0);
            }
        }

        if (!empty($data->mestre)) {
            if ($data->mestre == 1) {
                $rs->where('cartoes.mestre', 1);
            } elseif ($data->mestre == 2) {
                $rs->where('cartoes.mestre', 0);
            }
        }

        return $rs->get();
    }

    public function clearRegister()
    {
        return $this->register->truncate();
    }
    public function changeStatus($data)
    {
        return $this->ticket->where([
            'id_evento' => $data->id_evento,
            'id_categoria' => $data->id_categoria,
        ])
            ->set(['situacao' => $data->situacao])
            ->update();
    }
    public function removeTicket($data)
    {
        return $this->ticket->where([
            'id_evento' => $data->id_evento,
            'id_categoria' => $data->id_categoria,
        ])
            ->delete();
    }
    public function removeAll($data)
    {
        $this->importCategory->truncate();
        $this->ticketeiraEvent->truncate();
        $this->import->where('id is not null')->delete();
        $this->grupoItem->removeAll();
        $this->register->truncate();
        $this->photo->truncate();
        $this->ticket->truncate();
        $this->category->where('id is not null')->delete();
        $this->user->truncate();
        $this->event->where('id is not null')->delete();
        return $this->user->autoGen();
    }

    private function getArrEvent($eventName)
    {
        $siglaEvent = '['.$eventName.']';

        if(!empty($this->eventList)) {
            foreach($this->eventList as $k=>$v) {
                if($v == $siglaEvent) {
                    return $k;
                } else {
                    $rse = $this->event->like('evento', $siglaEvent)->first();
                    if(!empty($rse)) {
                        $this->eventList[$rse->id] = $siglaEvent;
                        return $rse->id;
                    }
                }
            }
        } else {
            $rse = $this->event->like('evento', $siglaEvent)->first();
            if(!empty($rse)) {
                $this->eventList[$rse->id] = $siglaEvent;
                return $rse->id;
            }
        }
        return null;
    }

    private function getArrCategory($categoryName)
    {
        if(!empty($this->categoryList)) {
            foreach($this->categoryList as $k=>$v) {
                if($v == $categoryName) {
                    return $k;
                } else {
                    $rse = $this->category->where('categoria', $categoryName)->first();
                    if(!empty($rse)) {
                        $this->categoryList[$rse->id] = $categoryName;
                        return $rse->id;
                    }
                }
            }
        } else {
            $rse = $this->category->where('categoria', $categoryName)->first();
            if(!empty($rse)) {
                $this->categoryList[$rse->id] = $categoryName;
                return $rse->id;
            }
        }
        
        $new = $this->addCategory($categoryName);
        if(!empty($new)) {
            $this->categoryList[$new] = $categoryName;
            return $new;
        }

        return null;
    }

    private function addCategory($nmCategory)
    {
        return $this->category->insert([
            'code' => rand(101,999),
            'categoria' => $nmCategory,
            'idr_multiplo' => 1,
            'fluxo' => 0,
            'tipo' => 'TICKET',
            'external_id' => null
        ]);
    }
}
