<?php

namespace App\Controllers\Event;

use App\Controllers\BaseController;
use App\Models\EventModel;
use App\Models\TicketeiraEventoModel;
use App\Entities\EventEntity;
use App\Libraries\Sympla\Sympla;

class Event extends BaseController {

    private EventEntity $event;
    private TicketeiraEventoModel $ticketeiraEvent;

    public function __construct()
    {
        $this->model = new EventModel();
        $this->event = new EventEntity();
        $this->ticketeiraEvent = new TicketeiraEventoModel();
    }

    public function initController($request, $response, $logger)
    {
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);
        if (!$this->authUser->logged()) {
            return redirect()->route("auth/signin");
        }
    }

    public function index() {
        $this->addOnView('events', $this->model->findAll());
        return view('event/index', $this->getViewData());
    }

    public function add()
    {
        $this->addOnView('event', $this->event);
        return view('event/edit', $this->getViewData());
    }

    public function edit($id)
    {
        $url = previous_url() ?? base_url();
        $result = $this->model->find((int)$id);
        if ($result) {
            $this->event->fill((array)$result);
            $this->addOnView('event', $result);
            return view('event/edit', $this->getViewData());
        } else {
            $this->authUser->setFlashdata('error', 'Evento inválido');
            return redirect()->to($url);
        }
    }

    public function delete($id)
    {
        $url = previous_url() ?? base_url();
        $result = $this->model->find((int)$id);
        if ($result) {
            $this->model->delete($id);
            $this->authUser->setFlashdata('success', 'Evento removido com sucesso');
            return redirect()->to('/event');
        } else {
            $this->authUser->setFlashdata('error', 'Evento inválido');
            return redirect()->to($url);
        }
    }

    public function addsave()
    {
        $this->event->fill($this->request->getPost());
        $url = previous_url() ?? base_url();
        $update = $this->model->save($this->event->toArray());

        if (!empty($update)) {
            $this->authUser->setFlashdata('success', 'Evento criado com sucesso');
            return redirect()->to('/event');
        } else {
            $this->authUser->setFlashdata('error', $update->message);
            return redirect()->to($url);
        }
    }

    public function save($id)
    {
        $url = previous_url() ?? base_url();
        $this->event->fill($this->request->getPost());
        $this->event->id = $id;
        $result = $this->model->save($this->event->toArray());
        if ($result ) {
            $this->authUser->setFlashdata('success', 'Evento atualizado com sucesso');
            return redirect()->to('/event');
        } else {
            $this->authUser->setFlashdata('error', 'evento inválido');
            return redirect()->to($url);
        }
    }

    public function sympla()
    {
        $sympla = new Sympla();
        
        $token = $this->request->getPost('token');
        $eventId = (int) $this->request->getPost('eventId');
        $data = (object) [
            'eventId' => $eventId,
            'result' => null,
            'code' => null,
            'event' => null,
            'status' => null,
            'message' => null,
        ];
        if (!empty($eventId) && !empty($token)) {
            $sympla->api->setToken($token);
            $data->result = $sympla->api->getEventById($eventId);
            $data->code = $sympla->api->getStatusCode();
            if ($data->code == 200) {
                $data->event = $this->processaSympla($data->result->data, $token);
                $data->status = true;
                $data->message = false;
            } else {
                $data->status = false;
                $data->message = $data->result->message;
            }
        }
        unset($data->result);
        return $this->response->setJSON($data);
    }

    private function processaSympla($data, $token)
    {
        $eventImport =  [
            'evento' => $data->name,
            'local' => $data->address->name,
            'data_inicio' => $data->start_date,
            'data_fim' => $data->end_date,
            'campos_obri' => null,
            'campoextra1' => null,
            'campoextra2' => null,
            'idr_cadastrado' => 1,
            'idr_passagem' => null,
            'qtd_livre' => null,
            'qtd_midia1' => null,
            'qtd_midia2' => null,
            'qtd_midia3' => null,
            'qtd_midia4' => null,
        ];
        $eventId = $this->model->insert($eventImport);

        if ($eventId) {
            $eventSympla = [
                'evento_id' => $eventId,
                'ticketeira_id' => 1,
                'token' => $token,
                'identify' => $data->id,
                'params' => json_encode($data),
                'lastUpdate' => date('Y-m-d H:i:s')
            ];
            $this->ticketeiraEvent->insert($eventSympla);
            
            return $eventId;

        } else {
            return null;
        }
    }

}
