<?php

namespace App\Controllers\Event;

use App\Controllers\BaseController;
use App\Models\CategoryModel;
use App\Entities\CategoryEntity;

class Category extends BaseController {

    private CategoryEntity $category;

    public function __construct()
    {
        $this->model = new CategoryModel();
        $this->category = new CategoryEntity();
    }

    public function initController($request, $response, $logger)
    {
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);
        if (!$this->authUser->logged()) {
            return redirect()->route("auth/signin");
        }
    }

    public function index() {
        $this->addOnView('categories', $this->model->getCategories());
        $this->addOnView('categoryTypes', $this->model->getTypes());
        return view('category/index', $this->getViewData());
    }

    public function add()
    {
        $this->addOnView('category', $this->category);
        $this->addOnView('categoryTypes', $this->model->getTypes());
        return view('category/edit', $this->getViewData());
    }

    public function edit($id)
    {
        $url = previous_url() ?? base_url();
        $result = $this->model->find((int)$id);
        if ($result) {
            $this->category->fill((array)$result);
            $this->addOnView('category', $result);
            $this->addOnView('categoryTypes', $this->model->getTypes());
            return view('category/edit', $this->getViewData());
        } else {
            $this->authUser->setFlashdata('error', 'Evento inválido');
            return redirect()->to($url);
        }
    }

    public function addsave()
    {
        $this->category->fill($this->request->getPost());
        $url = previous_url() ?? base_url();
        $this->category->idr_multiplo = $this->category->idr_multiplo==1??0;
        $this->category->fluxo = $this->category->fluxo==1??0;
        $update = $this->model->save($this->category->toArray());

        if (!empty($update)) {
            $this->authUser->setFlashdata('success', 'Evento criado com sucesso');
            return redirect()->to('/category');
        } else {
            $this->authUser->setFlashdata('error', $update->message);
            return redirect()->to($url);
        }
    }

    public function delete($id)
    {
        $url = previous_url() ?? base_url();
        $result = $this->model->find((int)$id);
        if ($result) {
            $this->model->delete($id);
            $this->authUser->setFlashdata('success', 'Categoria removida com sucesso');
            return redirect()->to('/category');
        } else {
            $this->authUser->setFlashdata('error', 'Categoria inválida');
            return redirect()->to($url);
        }
    }

    public function save($id)
    {
        $url = previous_url() ?? base_url();
        $this->category->fill($this->request->getPost());
        $this->category->id = $id;
        $this->category->idr_multiplo = $this->category->idr_multiplo==1??0;
        $this->category->fluxo = $this->category->fluxo==1??0;
        $result = $this->model->save($this->category->toArray());
        if ($result ) {
            $this->authUser->setFlashdata('success', 'Evento atualizado com sucesso');
            return redirect()->to('/category');
        } else {
            $this->authUser->setFlashdata('error', 'categoryo inválido');
            return redirect()->to($url);
        }
    }

}
