<?php

namespace App\Controllers\Dashboard;

use App\Controllers\BaseController;
use App\Libraries\GraphicData;
use App\Models\EventModel;

class Dashboard extends BaseController {

    private GraphicData $graphic;
    private EventModel $event;

    public function __construct()
    {
        $this->event = new EventModel();
        $this->graphic = new GraphicData();
    }

    public function initController($request, $response, $logger)
    {
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);
    }

    public function home() {
        
        if (!$this->authUser->logged()) {
            return redirect()->route("auth/signin");
        }

        $this->addOnView('eventos',  $this->event->findAll());
        $this->addOnView('dataSynth', $this->graphic->getSynthTickets()->findAll());
        return view('dashboard/index', $this->getViewData());
    }
    public function data($id=null)
    {
        $data =(object) [
            'ticket' => $this->getTicketPerTime($id),
            'reentry' => $this->getReentryPerTime($id),
            'reentryColab' => $this->getReentryColabPerTime($id)
        ];

        return $this->response->setJSON($data);
    }

    public function quantity($id=null)
    {
        $data = (object)[
            'tickets' =>(object) [
                'lidos' => 0,
                'bloqueados' => 0,
                'qtd' => 0
            ],
            'reentry' =>(object) [
                'lidos' => 0,
                'bloqueados' => 0,
                'qtd' => 0
            ],
            'colab' =>(object) [
                'lidos' => 0,
                'bloqueados' => 0,
                'qtd' => 0
            ]
        ];
        
        $lidos = $this->graphic->getRegistryLidos();
        $quantity = $this->graphic->getTicketsTotal();

        if ($lidos) {
            $data->tickets->lidos = $lidos->tickets;
            $data->reentry->lidos = $lidos->credenciados;
            $data->colab->lidos = $lidos->colaborador;
        }

        if ($quantity) {
            $data->tickets->bloqueados = $quantity->tickets_block;
            $data->reentry->bloqueados = $quantity->credenciados_block;
            $data->colab->bloqueados = $quantity->colaborador_block;

            $data->tickets->qtd = $quantity->tickets;
            $data->reentry->qtd = $quantity->credenciados;
            $data->colab->qtd = $quantity->colaborador;
        }

        return $this->response->setJSON($data);
    }
    public function resume($id=null)
    {
        $resume = $this->graphic->getSynthTickets()->where('eventos.id', $id)->findAll();
        return $this->response->setJSON($resume);
    }

    private function getTicketPerTime($id=null)
    {
        return $this->proccessPerTimeData(
            $this->graphic->getTicketPerTime()->where('eventos.id', $id)->findAll()
        );
    }
    private function getReentryPerTime($id=null)
    {
        return $this->proccessPerTimeData(
            $this->graphic->getReentryPerTime()->where('eventos.id', $id)->findAll()
        );
    }
    private function getReentryColabPerTime($id=null)
    {
        return $this->proccessPerTimeData(
            $this->graphic->getReentryColabPerTime()->where('eventos.id', $id)->findAll()
        );
    }

    private function proccessPerTimeData($requestData)
    {
        $data = [];
        foreach ($requestData as $d) {
            $data[]=(object) [
                "x" => $d->day.' '.$d->hour.'h',
                "y" => $d->qtd
            ];
        }
        return $data;
    }

}
