<?php

namespace App\Controllers\Commandline;

use App\Controllers\BaseController;
use App\Libraries\LibCloud;
use CodeIgniter\CLI\CLI;
use stdClass;

class Sync extends BaseController
{
   
    private LibCloud $cloud;

    public function __construct()
    {
        $this->cloud = new LibCloud();
    }

    public function initController($request, $response, $logger)
    {
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);
       
    }


    public function start()
    {
        $integradores = $this->cloud->getIntegradores();
        foreach($integradores as $integrador) {
            CLI::write('--- start sinc ----');
            $this->cloud->startSync($integrador);
            CLI::write('--- start checkin ----');
            $this->cloud->checkinSinc($integrador);
            CLI::write('--- start checkin ----');
            $this->cloud->checkinSincPost($integrador);
        }

        $db = \Config\Database::connect();
        $db->query('update marcacao, cartoes set 
                    marcacao.id_pessoa = cartoes.id 
                    where marcacao.cartao = cartoes.cartao');
                    
        $db->query('update entrega, cartoes set 
                    entrega.id_pessoa = cartoes.id 
                    where entrega.cartao = cartoes.cartao');
        
        $this->start();
    }

    public function file($id)
    {
        CLI::write('--- stating at '.date('Y-m-d H:i:s', time()));
        if(!empty($id)) {
            $this->cloud->importa($id);
        } else {
            CLI::write('--- event not found ----');
        }
        
        $db = \Config\Database::connect();
        $db->query('update marcacao, cartoes set 
                    marcacao.id_pessoa = cartoes.id 
                    where marcacao.cartao = cartoes.cartao');
                    
        $db->query('update entrega, cartoes set 
                    entrega.id_pessoa = cartoes.id 
                    where entrega.cartao = cartoes.cartao');
    }

    public function checkin()
    {
        CLI::write('--- stating at '.date('Y-m-d H:i:s', time()));
        $db = \Config\Database::connect();
        $db->query('update marcacao, cartoes set 
                    marcacao.id_pessoa = cartoes.id 
                    where marcacao.cartao = cartoes.cartao');
                    
        $db->query('update entrega, cartoes set 
                    entrega.id_pessoa = cartoes.id 
                    where entrega.cartao = cartoes.cartao');
                    
        $integradores = $this->cloud->getIntegradores();
        foreach($integradores as $integrador) {
            $this->cloud->checkinSinc($integrador);
        }
        CLI::write('ok');
        
    }
   
}
