<?php

namespace App\Controllers\Commandline;

use App\Controllers\BaseController;
use App\Libraries\LibTicketeria;
use CodeIgniter\CLI\CLI;
use stdClass;

class IntegradorTicketeria extends BaseController
{
   
    private LibTicketeria $sync;
    private stdClass $prepare;

    public function __construct()
    {
        $this->sync = new LibTicketeria();

    }

    public function initController($request, $response, $logger)
    {
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);
       
    }

    public function start()
    {
        $integradores = $this->sync->getIntegradores();
        foreach($integradores as $integrador) {
            $this->sync->startSync($integrador);
        }
        CLI::write('reset');
        sleep(5);
        $this->start();
    }

    public function checkin()
    {
        $integradores = $this->sync->getIntegradores();
        
        foreach($integradores as $integrador) {
            $this->sync->checkinSinc($integrador);
        }
        CLI::write('ok');
    }
   
}
