<?php

namespace App\Controllers\Commandline;

use App\Controllers\BaseController;
use App\Libraries\LibIntegrador;
use CodeIgniter\CLI\CLI;
use stdClass;

class Integrador extends BaseController
{
   
    private LibIntegrador $sync;
    private stdClass $prepare;

    public function __construct()
    {
        $this->sync = new LibIntegrador();

    }

    public function initController($request, $response, $logger)
    {
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);
       
    }


    public function start()
    {
        CLI::write('--- stating at '.date('Y-m-d H:i:s', time()));
        $integradores = $this->sync->getIntegradores();
        foreach($integradores as $integrador) {
            $this->sync->startSync($integrador);
        }
        CLI::write('ok');
    }

    public function bora()
    {
        CLI::write('--- stating at '.date('Y-m-d H:i:s', time()));
        $db = \Config\Database::connect();
        $db->query('update marcacao, cartoes set 
                    marcacao.id_pessoa = cartoes.id 
                    where marcacao.cartao = cartoes.cartao');
                    
        $db->query('update entrega, cartoes set 
                    entrega.id_pessoa = cartoes.id 
                    where entrega.cartao = cartoes.cartao');
                    
        $this->sync->sendToBora();
        CLI::write('ok');
    }

    public function end()
    {
        $integradores = $this->sync->getIntegradores();
        foreach($integradores as $integrador) {
            $this->sync->startNewsSync($integrador);
        }
        CLI::write('ok');
    }

    public function checkin()
    {
        CLI::write('--- stating at '.date('Y-m-d H:i:s', time()));
        $integradores = $this->sync->getIntegradores();
        foreach($integradores as $integrador) {
            $this->sync->checkinSinc($integrador);
        }
        CLI::write('ok');
    }
   
}
