<?php

namespace App\Controllers\Commandline;

use App\Controllers\BaseController;
use App\Libraries\LibIhxIntegrador;
use CodeIgniter\CLI\CLI;
use stdClass;

class IhxIntegrador extends BaseController
{
   
    private LibIhxIntegrador $sync;
    private stdClass $prepare;

    public function __construct()
    {
        $this->sync = new LibIhxIntegrador();

    }

    public function initController($request, $response, $logger)
    {
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);
       
    }


    public function sinc()
    {
         $this->sync->sinc();
    }


    public function leitura()
    {
         $this->sync->leitura();
    }

    public function start()
    {
        $integradores = $this->sync->getIntegradores();
        foreach($integradores as $integrador) {
            $this->sync->startSync($integrador);
        }
        CLI::write('ok start');
        $this->start();
    }

    public function end()
    {
        $integradores = $this->sync->getIntegradores();
        foreach($integradores as $integrador) {
            $this->sync->startNewsSync($integrador);
        }
        CLI::write('ok end');
        $this->end();
    }

    public function checkin()
    {
        $integradores = $this->sync->getIntegradores();
        
        foreach($integradores as $integrador) {
            $this->sync->checkinSinc($integrador);
        }
        CLI::write('ok');
    }
   
}
