<?php

namespace App\Controllers\Commandline;

use App\Controllers\BaseController;
use App\Libraries\LibImportCredenciart;
use App\Libraries\LibSincServer;
use CodeIgniter\CLI\CLI;
use stdClass;

class Command extends BaseController
{

    private LibImportCredenciart $importCredenciart;
    private LibSincServer $sync;
    private stdClass $prepare;

    public function __construct()
    {
        $this->importCredenciart = new LibImportCredenciart();
        $this->sync = new LibSincServer();
        $this->prepare = (object)[
            'command' => '',
            'running' => false,
            'error' => null,
            'data' => null,
            'register' => null,
            'photo' => null,
            'started_at' => null
        ];

        $this->prepare->data = (object)[
            'updated_at' => null,
            'created_at' => null,
            'rows' => 200,
            'page' => 1,
            'sort' => 'updated_at',
            'order' => 'asc',
        ];

        $this->prepare->register = (object)[
            'data_maior' => null,
            'rows' => 500,
            'page' => 1,
            'sort' => 'id',
            'order' => 'asc',
        ];
    }

    public function initController($request, $response, $logger)
    {
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);
    }


    public function executeImportacaoCredenciart()
    {
        if (!$this->prepare->running) {
            $this->prepare->running = true;

            $file = $this->importCredenciart->hasFile();

            if ($file) {
                $this->prepare->started_at = time();
                $this->prepare->command = 'executeImportacaoCredenciart';
                $this->display('Preparando para importar arquivo...');

                $spl = $this->importCredenciart->importarArquivo($file);

                CLI::write("| Linhas: {$spl->index}| Ativas: {$spl->active}| Inativas: {$spl->inactive}| Processadas: {$spl->proccess}");
                sleep(10);
                $this->prepare->running = false;
            } else {
                $this->prepare->running = false;
                $this->display('Não existe arquivos para importar');
            }
        }

        sleep(5);
        $this->executeImportacaoCredenciart();
    }

    private function display($msg)
    {
        $date = date('Y-m-d H:i:s');
        CLI::clearScreen();
        CLI::write('|=====================================================================|');
        CLI::write("| Sync: Atualizacao de tickets  | em {$date}       |", 'dark_blue', 'yellow');
        CLI::write('|=====================================================================|');
        if ($msg) {
            CLI::write("| {$msg}    ", 'dark_blue', 'red');
        }
        CLI::write('|=====================================================================|');
    }

    public function serverSinc()
    {
        $this->serverSincImporta();
    }

    public function credenciamento()
    {
        $this->sync->setUrl(URL_CREDENCIAMENTO_SYNC);
        $this->serverCredencialImporta();
    }

    public function serverSincRegister()
    {
        $this->serverSincRegisterImporta();
    }

    public function serverSincPhoto()
    {

        $this->serverSincPhotoImporta();
    }

    public function credenciamentoPhoto()
    {
        $this->sync->setUrl(URL_CREDENCIAMENTO_SYNC);
        $this->serverSincPhotoImporta();
    }

    public function serverSincImporta()
    {

        if (!$this->prepare->running) {
            $this->prepare->running = true;

            $file = $this->sync->hasSync($this->prepare->data);

            if ($file && property_exists($file, 'status') && $file->status && property_exists($file, 'data') && property_exists($file->data, 'tickets')) {
                $this->prepare->started_at = time();
                $this->prepare->command = 'serverSinc';
                $this->display('Verificando atualizações');

                $spl = $this->sync->updateSync($file);

                CLI::write("| Linhas: {$spl->index}| Ativas: {$spl->active}| Inativas: {$spl->inactive}| Processadas: {$spl->proccess}| updated_at: {$spl->updated_at}");
                // $this->prepare->data->updated_at = $spl->updated_at;
                $pages = $file->data->pagination;
                if ($this->prepare->data->page < $pages->pages) {
                    $this->prepare->data->page++;
                } else {
                    $this->prepare->data->page = 1;
                }
                CLI::showProgress($this->prepare->data->page, $pages->pages);
                $this->prepare->running = false;
                sleep(3);
                $this->serverSincImporta();
            } else {
                $this->prepare->running = false;
                $this->display('Não existe dados para atualizar');
            }
        }

        sleep(5);
        $this->serverSinc();
    }

    public function serverCredencialImporta()
    {

        if (!$this->prepare->running) {
            $this->prepare->running = true;

            $file = $this->sync->hasSync($this->prepare->data);

            if ($file && property_exists($file, 'status') && $file->status && property_exists($file, 'data') && property_exists($file->data, 'tickets')) {
                $this->prepare->started_at = time();
                $this->prepare->command = 'serverSinc';
                $this->display('Verificando atualizações');

                $spl = $this->sync->updateSync($file);

                CLI::write("| Linhas: {$spl->index}| Ativas: {$spl->active}| Inativas: {$spl->inactive}| Processadas: {$spl->proccess}| updated_at: {$spl->updated_at}");
                // $this->prepare->data->updated_at = $spl->updated_at;
                $pages = $file->data->pagination;
                if ($this->prepare->data->page < $pages->pages) {
                    $this->prepare->data->page++;
                } else {
                    $this->prepare->data->page = 1;
                }
                CLI::showProgress($this->prepare->data->page, $pages->pages);
                $this->prepare->running = false;
                sleep(3);
                $this->serverCredencialImporta();
            } else {
                $this->prepare->running = false;
                $this->display('Não existe dados para atualizar');
            }
        }

        sleep(5);
        $this->credenciamento();
    }

    public function serverSincRegisterImporta()
    {
        if (!$this->prepare->running) {
            $this->prepare->running = true;

            $file = $this->sync->hasRegister($this->prepare->register);

            if ($file && property_exists($file, 'status') && $file->status && property_exists($file, 'data') && property_exists($file->data, 'register')) {
                $this->prepare->started_at = time();
                $this->prepare->command = 'serverSincRegister';
                $this->display('Verificando atualizações');

                $spl = $this->sync->updateRegisterSync($file);

                CLI::write("| Linhas: {$spl->index}| Ativas: {$spl->active}| Inativas: {$spl->inactive}| Processadas: {$spl->proccess}| updated_at: {$this->prepare->register->data_maior}");

                $pages = $file->data->pagination;

                if ($this->prepare->data->page < $pages->pages) {
                    $this->prepare->data->page++;
                } else {
                    $this->prepare->data->page = 1;
                }
                CLI::showProgress($this->prepare->data->page, $pages->pages);

                $this->prepare->running = false;
                sleep(1);
                $this->serverSincRegisterImporta();
            } else {
                $this->prepare->running = false;
                $this->display('Não existe dados para atualizar');
            }
        }

        sleep(5);
        $this->serverSincRegisterImporta();
    }

    public function serverSincPhotoImporta()
    {
        if (!$this->prepare->running) {
            $this->prepare->running = true;

            $file = $this->sync->hasPhoto($this->prepare->data);
            
            if ($file && property_exists($file, 'status') && $file->status && property_exists($file, 'data') && property_exists($file->data, 'photo')) {
                $this->prepare->started_at = time();
                $this->prepare->command = 'serverSincPhoto';
                $this->display('Verificando atualizações');

                $spl = $this->sync->updatePhotoSync($file);

                CLI::write("| Linhas: {$spl->index}| Ativas: {$spl->active}| Inativas: {$spl->inactive}| Processadas: {$spl->proccess}| created_at: {$spl->created_at}");

                $pages = $file->data->pagination;

                if (!empty($spl->data_acesso)) {
                    $this->prepare->data->created_at = $spl->created_at;
                }

                if ($pages->current >= $pages->pages) {
                    $this->prepare->data->page = 1;
                } else {
                    $this->prepare->data->page = $this->prepare->data->page + 1;
                }
                //CLI::write('np: '.$np);
                CLI::showProgress($pages->current, $pages->pages);

                $this->prepare->running = false;
               
                $this->serverSincPhotoImporta();
            } else {
                $this->prepare->running = false;
                $this->display('Não existe dados para atualizar');
            }
        }

        sleep(3);
        $this->serverSincPhoto();
    }

    public function uploadSinc()
    {
        $limit = 300;
        $register = $this->sync->getUnsendedRegister($limit);
        $dateNow = date('d/m/Y H:i:s');
        if (!empty($register)) {
            $qtd = count($register);
            CLI::clearScreen();
            CLI::write('|=====================================================================|');
            CLI::write("| Linhas: $qtd | em {$dateNow}|", 'dark_blue', 'yellow');
            $this->sync->sendRegister($register);
        } else {
            CLI::clearScreen();
            CLI::write('|=====================================================================|');
            CLI::write("Sem registro de tickets em {$dateNow}|", 'purple', 'yellow');
        }
        sleep(2);
        $this->uploadSinc();
    }

    public function uploadSincTicket()
    {
        $limit = 300;
        $tickets = $this->sync->getUnsendedTicket($limit);
        $dateNow = date('d/m/Y H:i:s');
        if (!empty($tickets)) {
            $qtd = count($tickets);
            CLI::clearScreen();
            CLI::write('|=====================================================================|');
            CLI::write("| Linhas: $qtd | em {$dateNow}|", 'dark_blue', 'yellow');
            $this->sync->sendTickets($tickets);
        } else {
            CLI::clearScreen();
            CLI::write('|=====================================================================|');
            CLI::write("Sem registro de marcações em {$dateNow}|", 'purple', 'yellow');
        }
        sleep(2);
        $this->uploadSincTicket();
    }

    public function uploadSincPhoto()
    {
        $limit = 5;
        $photo = $this->sync->getUnsendedPhoto($limit);

        $dateNow = date('d/m/Y H:i:s');
        if (!empty($photo)) {
            $qtd = count($photo);
            CLI::clearScreen();
            CLI::write('|=====================================================================|');
            CLI::write("| Linhas: $qtd | em {$dateNow}|", 'dark_blue', 'yellow');
            $this->sync->sendPhotos($photo);
        } else {
            CLI::clearScreen();
            CLI::write('|=====================================================================|');
            CLI::write("Sem registro de marcações em {$dateNow}|", 'purple', 'yellow');
        }
        sleep(2);
        $this->uploadSincPhoto();
    }
}
