<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\HTTP\IncomingRequest;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;
use App\Libraries\SystemMenu;

/**
 * Class BaseController
 *
 * BaseController provides a convenient place for loading components
 * and performing functions that are needed by all your controllers.
 * Extend this class in any new controllers:
 *     class Home extends BaseController
 *
 * For security be sure to declare any new methods as protected or private.
 */
class BaseController extends Controller {

    /**
     * Instance of the main Request object.
     *
     * @var IncomingRequest|CLIRequest
     */
    protected $request;

    /**
     * An array of helpers to be loaded automatically upon
     * class instantiation. These helpers will be available
     * to all other controllers that extend BaseController.
     *
     * @var array
     */
    protected $helpers = ['form', 'url', 'cookie', 'my_helper', 'filesystem'];
    protected $authUser;
    protected $ci_erro;
    protected $viewData;
    private $version;
    private $template;
    protected $model;
    

    /**
     * Constructor.
     *
     * @param RequestInterface  $request
     * @param ResponseInterface $response
     * @param LoggerInterface   $logger
     */
    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger) {
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);
        $this->ci_erro = [];
        $this->authUser = new \App\Libraries\AuthUser();
        $this->loadEnv();
        $this->initViewData();
        
        //--------------------------------------------------------------------
        // Preload any models, libraries, etc, here.
        //--------------------------------------------------------------------
        // E.g.: $this->session = \Config\Services::session();
    }

    protected function setError($msg) {
        $this->ci_erro[] = $msg;
    }

    protected function selectedMenu($val) {
        SystemMenu::setSelected($val);
    }

    protected function getError() {
        if (is_array($this->ci_erro)) {
            return reset($this->ci_erro);
        } else {
            return $this->ci_erro;
        }
    }

    protected function hasError() {
        if (!empty($this->ci_erro)) {
            return true;
        }
        return false;
    }

    public function addOnView($name, $data) {
        if (is_array($name)) {
            foreach ($name as $key => $value) {
                $this->viewData[$key] = $value;
            }
        } else {
            $this->viewData[$name] = $data;
        }
    }

    public function getViewData() {
        return $this->viewData;
    }

    public function clearAllCache() {
        $this->libCache->clearAll();
    }

    public function getViewPath() {
        return $this->template;
    }

    protected function loadEnv() {
        $this->template = getenv('app.template');
        $this->version = getenv('app.version');
    }
    
    protected function parmissionValidate(string $method, string $route){
        return $this->authUser->validPermission($method, $route);
    }

    private function initViewData() {

        $this->viewData = [
            'activemenu' => null,
            'stView' => getenv('app.view'),
            'template' => $this->template,
            'version' => $this->version,
            'user' => $this->authUser->getUser(),
        ];
    }

}
