<?php

namespace App\Controllers\Auth;

use App\Controllers\BaseController;

class Auth extends BaseController {

    private $user;

    public function __construct() {
        //$this->user = $this->api->auth;
    }

    public function signin() {
        return view( '/auth/signin', $this->getViewData());
    }
    

    public function auth() {
        $login = $this->request->getPost('account_user');
        $pass = $this->request->getPost('account_passwd');
        $auth = $this->authUser->login($login, $pass);
        $url = previous_url() ?? base_url();
        if ($auth ) {
            return redirect()->to('/');
        } else {
            $this->authUser->setFlashdata('error', 'Usuário e/ou senha inválida');
            return redirect()->to($url);
        }
    }
    
    public function passwordrecovery() {
        return view('/auth/passwordrecovery', $this->getViewData());
    }

    public function sendpasswordrecovery() {
        $email = $this->request->getPost('reset_email');
        $auth = $this->user->resetpassword($email);
        $url = previous_url() ?? base_url();
        if ($auth && property_exists($auth, 'user')) {
            $this->authUser->setFlashdata('success', 'Enviamos um email com as instruções para que você possa criar uma nova senha!');
            return redirect()->to('auth/signin');
        } else {
            $this->authUser->setFlashdata('error', 'Usuário inválido');
            return redirect()->to($url);
        }
    }

    public function resetpassword($hash) {
        $auth = $this->user->verify($hash);
        $verify = null;
        $url = previous_url() ?? base_url();
        if ($auth && property_exists($auth, 'user')) {
            $verify = $auth->user;
            $this->addOnView('verify', $verify);
            $this->addOnView('hash', $hash);
            return view('/auth/verify', $this->getViewData());
        } else {
            $this->authUser->setFlashdata('error', 'Link inválido ou expirado');
            return redirect()->to($url);
        }
    }

    public function changepassword() {
        $error = null;
        $hash = $this->request->getPost('account_hash');
        $account_password = $this->request->getPost('account_password');
        $retry_account_password = $this->request->getPost('retry_account_password');
        $auth = $this->user->verify($hash);
        $url = previous_url() ?? base_url();
        if ($account_password != $retry_account_password) {
            $error = 'Senhas não são iguais';
        }

        if (empty($error) && strlen($account_password) <= 5) {
            $error = 'Senha muito curta';
        }
        if (empty($error) && $auth && property_exists($auth, 'user')) {
            $response = $this->user->recovery($auth->user->email, $hash, $account_password);
            // var_dump($response);exit();
            if ($response && property_exists($response, 'user')) {
                
                $this->authUser->setUser($response->message);
                $this->authUser->setFlashdata('success', 'Senha alterada com sucesso!');
                return redirect()->to('auth/signin');
            } else {
                $error = $response->message;
            }
        }
        $this->authUser->setFlashdata('error', $error);
        return redirect()->to($url);
    }

    public function logout() {
        $this->authUser->clearUser();
        return redirect()->to('/');
    }

}
