<?php

namespace App\Controllers\Api\v2;

use App\Controllers\Api\BaseResourceController;
use App\Libraries\LibPaginate;
use App\Models\TicketModel;


class Ticket  extends BaseResourceController
{
    public LibPaginate $pagination;

    public function __construct()
    {
        $this->model = new TicketModel();
    }

    public function index()
    {
        $data = $this->getComp();
        $pagination = new LibPaginate($data, $this->request, 'tickets');
        $pagination->addFilter('cartoes.id', 'id', '=');
        $pagination->addFilter('cartoes.cartao', 'ticket_number', '=');
        $pagination->addFilter('cartoes.serial_id', 'serial_id', '>=');
        $pagination->addFilter('eventos.evento', 'name', 'like');
        $pagination->addFilter('eventos.id', 'event_id', '=');
        $pagination->addFilter('eventos.code', 'code', '=');
        $pagination->setRows($this->request->getGet('rows'));
        $pagination->setPage($this->request->getGet('page'));
        $pagination->setSort($this->request->getGet('sort'));
        $pagination->setOrder($this->request->getGet('order'));
        $this->apiResponse->setResult($pagination->get(), 'data');
        return $this->respond($this->apiResponse->getApiResult(), 200, 'OK');
    }

    public function show($id = null)
    {
        $rs = $this->getComp()->where(['cartoes.id' => $id])->first();

        if (!empty($rs)) {
            $this->apiResponse->setResult($rs, 'ticket');
            return $this->respond($this->apiResponse->getApiResult(), 200, 'OK');
        } else {
            return $this->failNotFound('Ticket not found');
        }
    }

    private function getComp()
    {
        return $this->model->select(
            'cartoes.id,
                cartoes.serial_id,
                eventos.code as eventCode,
                categorias.categoria as category,
                categorias.code as categoryCode,
                categorias.tipo as category_type,
                categorias.fluxo as category_fluxo,
                categorias.idr_multiplo as category_idr_multiplo,
                eventos.evento as event,
                eventos.local as event_local,
                eventos.data_inicio as event_start,
                eventos.data_fim as event_end,
                eventos.campoextra1 as event_extra1,
                eventos.campoextra2 as event_extra2,
                cartoes.id_categoria as category_id,
                cartoes.cartao as ticket_number,
                cartoes.nome as name,
                cartoes.email as email,
                cartoes.rg as document_rg,
                cartoes.cpf as document_cpf,
                cartoes.situacao as status,
                cartoes.campoextra1 as extrafield_1,
                cartoes.campoextra2 as extrafield_2,
                cartoes.updated_at,
                cartoes.mestre as master
            '
        )->join('categorias', 'categorias.id = cartoes.id_categoria', 'left')
            ->join('eventos', 'eventos.id = cartoes.id_evento', 'left');
    }
}
