<?php

namespace App\Controllers\Api\v2;

use App\Controllers\Api\BaseResourceController;
use App\Libraries\LibPaginate;
use App\Models\RegistryModel;
use App\Models\EventModel;
use App\Models\TicketModel;


class Registry  extends BaseResourceController
{
    public LibPaginate $pagination;
    public EventModel $event;
    public TicketModel $ticket;

    public function __construct()
    {
        $this->event = new EventModel();
        $this->model = new RegistryModel();
        $this->ticket = new TicketModel();
    }

    public function index()
    {
        $data = $this->getComp();
        $pagination = new LibPaginate($data, $this->request, 'registers');
        $pagination->addFilter('marcacao.id', 'id', '=');
        $pagination->addFilter('marcacao.data_acesso', 'access_date', '=');
        $pagination->addFilter('marcacao.acao', 'action', '=');
        $pagination->addFilter('marcacao.terminal', 'terminal', '=');
        $pagination->addFilter('marcacao.send_on', 'send_on', '=');
        $pagination->addFilter('marcacao.serial_id', 'serial_id', '>=');
        $pagination->addFilter('marcacao.data_acesso', 'data_maior', 'maior');
        $pagination->addFilter('marcacao.cartao', 'ticket_number', '=');
        $pagination->addFilter('marcacao.id_evento', 'event_id', '=');
        $pagination->addFilter('eventos.code', 'code', '>=');
        $pagination->setRows($this->request->getGet('rows'));
        $pagination->setPage($this->request->getGet('page'));
        $pagination->setSort($this->request->getGet('sort'));
        $pagination->setOrder($this->request->getGet('order'));
        $this->apiResponse->setResult($pagination->get(), 'data');
        return $this->respond($this->apiResponse->getApiResult(), 200, 'OK');
    }

    public function show($id = null)
    {
        $rs = $this->getComp()->where(['marcacao.id' => $id])->first();

        if (!empty($rs)) {
            $this->apiResponse->setResult($rs, 'register');
            return $this->respond($this->apiResponse->getApiResult(), 200, 'OK');
        } else {
            return $this->failNotFound('register not found');
        }
    }

    public function save()
    {
        $listTicket = $this->request->getVar();
        $retorno = [];
        $serialId = time();
        foreach ($listTicket as $marc) {
            $event = $this->event->where('code', $marc->code)->first();
            $marc->server_id = null;
            $marc->remote_id = $marc->id;
            $marc->error = null;
            if (empty($event)) {
                $marc->error = 'evento inválido';
                $retorno[] = $marc;
                continue;
            }

            $ticket = $this->ticket->where([
                'id_evento' => $event->id,
                'cartao' => $marc->ticket_number,
            ])->first();

            if (empty($ticket)) {
                $marc->error = 'Ticket inválido';
                $retorno[] = $marc;
                continue;
            }

            $rs = $this->model->where([
                'cartao' => $marc->ticket_number,
                'id_evento' => $event->id,
                'data_acesso' => $marc->access_date,
                'acao' => $marc->action
            ])->first();

            if (empty($rs)) {
                $registry = [
                    'serial_id' => $serialId,
                    'id_pessoa' => $ticket->id,
                    'id_evento' => $event->id,
                    'cartao' => $marc->ticket_number,
                    'data_acesso' => $marc->access_date,
                    'acao' => $marc->action,
                    'remote_id' => $marc->id,
                    'send_on' => date('Y-m-d H:i:s', time()),
                    'terminal' => $marc->terminal
                ];

                $marc->server_id = $this->model->insert($registry);
                $retorno[] = $marc;
            } else {
                $marc->error = 'Marcação duplicada';
                $retorno[] = $marc;
                continue;
            }
        }
        return $this->respond($retorno, 200, 'OK');
    }

    private function getComp()
    {
        return $this->model->select(
            'marcacao.id,
            marcacao.serial_id,
            eventos.code,
            marcacao.id_pessoa as ticket_id,
            marcacao.id_evento as event_id,
            marcacao.cartao as ticket_number,
            marcacao.data_acesso as access_date,
            marcacao.acao as action,
            marcacao.terminal,
            marcacao.giro,
            marcacao.remote_id,
            marcacao.send_on
            '
        )->join('eventos', 'eventos.id = marcacao.id_evento', 'left');
    }
}
