<?php

namespace App\Controllers\Api\v2;

use App\Controllers\Api\BaseResourceController;
use App\Libraries\LibPaginate;
use App\Models\EventModel;
use App\Models\CategoryModel;

class Event  extends BaseResourceController
{

    public $apiResult;
    public $event;
    public CategoryModel $category;
    public $inputJson;
    public LibPaginate $pagination;

    public function __construct()
    {
        $this->model = new EventModel();
        $this->category = new CategoryModel();
    }
    
    public function index()
    {
        $data = $this->getComp();
        $pagination = new LibPaginate($data, $this->request, 'events');
        $pagination->addFilter('id', 'id', '=');
        $pagination->addFilter('data_inicio', 'start_date', '=');
        $pagination->addFilter('data_fim', 'end_date', '=');
        $pagination->addFilter('evento', 'name', 'like');
        $pagination->addFilter('code', 'code', '=');
        $pagination->setRows($this->request->getGet('rows'));
        $pagination->setPage($this->request->getGet('page'));
        $pagination->setSort($this->request->getGet('sort'));
        $pagination->setOrder($this->request->getGet('order'));
        $this->apiResponse->setResult($pagination->get(), 'data');
        return $this->respond($this->apiResponse->getApiResult(), 200, 'OK');
    }

    public function show($id = null)
    {
        $rs = $this->getComp()->where(['code' => $id])->first();


        if (!empty($rs)) {
            $this->apiResponse->setResult($rs, 'event');
            return $this->respond($this->apiResponse->getApiResult(), 200, 'OK');
        } else {
            return $this->failNotFound('Event not found');
        }
    }

    public function categoryIndex()
    {
        $data = $this->category;
        $pagination = new LibPaginate($data, $this->request, 'categories');
        $pagination->addFilter('id', 'id', '=');
        $pagination->addFilter('code', 'code', '=');
        $pagination->setRows($this->request->getGet('rows'));
        $pagination->setPage($this->request->getGet('page'));
        $pagination->setSort($this->request->getGet('sort'));
        $pagination->setOrder($this->request->getGet('order'));
        $this->apiResponse->setResult($pagination->get(), 'data');
        return $this->respond($this->apiResponse->getApiResult(), 200, 'OK');
    }

    public function categoryShow($id = null)
    {
        $rs = $this->category->where(['id' => $id])->first();


        if (!empty($rs)) {
            $this->apiResponse->setResult($rs, 'category');
            return $this->respond($this->apiResponse->getApiResult(), 200, 'OK');
        } else {
            return $this->failNotFound('Category not found');
        }
    }


    private function getComp()
    {
        return $this->model->select(
            '   id,
                evento as name,
                local,
                code,
                data_inicio as start_date,
                data_fim as end_date,
                campoextra1 as extrafield_1,
                campoextra2 as extrafield_2
            '
        );
    }
}
