<?php

namespace App\Controllers\Api\v2;

use App\Controllers\Api\BaseResourceController;
use App\Libraries\LibPaginate;
use App\Models\DeliveryModel;
use App\Models\EventModel;
use App\Models\TicketModel;


class Delivery  extends BaseResourceController
{
    public LibPaginate $pagination;
    public EventModel $event;
    public TicketModel $ticket;

    public function __construct()
    {
        $this->event = new EventModel();
        $this->model = new DeliveryModel();
        $this->ticket = new TicketModel();
    }

    public function index()
    {
        $data = $this->getComp();
        $pagination = new LibPaginate($data, $this->request, 'delivery');
        $pagination->addFilter('entrega.id', 'id', '=');
        $pagination->addFilter('entrega.data_acesso', 'access_date', '=');
        $pagination->addFilter('entrega.acao', 'action', '=');
        $pagination->addFilter('entrega.terminal', 'terminal', '=');
        $pagination->addFilter('entrega.send_on', 'send_on', '=');
        $pagination->addFilter('entrega.serial_id', 'serial_id', '>=');
        $pagination->addFilter('entrega.data_acesso', 'data_maior', 'maior');
        $pagination->addFilter('entrega.cartao', 'ticket_number', '=');
        $pagination->addFilter('entrega.id_evento', 'event_id', '=');
        $pagination->addFilter('eventos.code', 'code', '>=');
        $pagination->setRows($this->request->getGet('rows'));
        $pagination->setPage($this->request->getGet('page'));
        $pagination->setSort($this->request->getGet('sort'));
        $pagination->setOrder($this->request->getGet('order'));
        $this->apiResponse->setResult($pagination->get(), 'data');
        return $this->respond($this->apiResponse->getApiResult(), 200, 'OK');
    }

    public function show($id = null)
    {
        $rs = $this->getComp()->where(['entrega.id' => $id])->first();

        if (!empty($rs)) {
            $this->apiResponse->setResult($rs, 'delivery');
            return $this->respond($this->apiResponse->getApiResult(), 200, 'OK');
        } else {
            return $this->failNotFound('delivery not found');
        }
    }

    public function save()
    {
        $listTicket = $this->request->getVar();
        $retorno = [];
        $serialId = time();
        foreach ($listTicket as $marc) {
            $event = $this->event->where('code', $marc->code)->first();
            $marc->server_id = null;
            $marc->remote_id = $marc->id;
            $marc->error = null;
            if (empty($event)) {
                $marc->error = 'evento inválido';
                $retorno[] = $marc;
                continue;
            }

            $ticket = $this->ticket->where([
                'id_evento' => $event->id,
                'cartao' => $marc->ticket_number,
            ])->first();

            if (empty($ticket)) {
                $marc->error = 'Ticket inválido';
                $retorno[] = $marc;
                continue;
            }

            $rs = $this->model->where([
                'cartao' => $marc->ticket_number,
                'id_evento' => $event->id,
                'data_acesso' => $marc->access_date,
                'acao' => $marc->action
            ])->first();

            if (empty($rs)) {
                $delivery = [
                    'serial_id' => $serialId,
                    'id_pessoa' => $ticket->id,
                    'id_evento' => $event->id,
                    'cartao' => $marc->ticket_number,
                    'data_acesso' => $marc->access_date,
                    'acao' => $marc->action,
                    'remote_id' => $marc->id,
                    'send_on' => date('Y-m-d H:i:s', time()),
                    'terminal' => $marc->terminal
                ];

                $marc->server_id = $this->model->insert($delivery);
                $retorno[] = $marc;
            } else {
                $marc->error = 'Marcação duplicada';
                $retorno[] = $marc;
                continue;
            }
        }
        return $this->respond($retorno, 200, 'OK');
    }

    private function getComp()
    {
        return $this->model->select(
            'entrega.id,
            entrega.serial_id,
            eventos.code,
            entrega.id_pessoa as ticket_id,
            entrega.id_evento as event_id,
            entrega.cartao as ticket_number,
            entrega.data_acesso as access_date,
            entrega.acao as action,
            entrega.terminal,
            entrega.giro,
            entrega.remote_id,
            entrega.send_on
            '
        )->join('eventos', 'eventos.id = entrega.id_evento', 'left');
    }
}
