<?php

namespace App\Controllers\Api;

use App\Controllers\Api\BaseResourceController;
use App\Libraries\LibPaginate;
use App\Libraries\LibImage;
use App\Models\TicketModel;
use App\RequestValidation\TicketValidation;

class Ticket  extends BaseResourceController
{

    public LibPaginate $pagination;
    public LibImage $libImage;

    public function __construct()
    {
        $this->model = new TicketModel();
        $this->libImage = new LibImage();
    }
    
    public function index()
    {
        $data = $this->getComp();
        $pagination = new LibPaginate($data, $this->request, 'tickets');
        $pagination->addFilter('id', 'id', '=');
        $pagination->addFilter('cartao', 'ticket_number', '=');
        $pagination->addFilter('nome', 'name', '=');
        $pagination->addFilter('email', 'email', '=');
        $pagination->addFilter('rg', 'document_rg', '=');
        $pagination->addFilter('cpf', 'document_cpf', '=');
        $pagination->addFilter('id_evento', 'event_id', '=');
        $pagination->addFilter('id_categoria', 'category_id', '=');
        $pagination->addFilter('updated_at', 'updated_at', '>=');
        $pagination->setRows($this->request->getGet('rows'));
        $pagination->setPage($this->request->getGet('page'));
        $pagination->setSort($this->request->getGet('sort'));
        $pagination->setOrder($this->request->getGet('order'));
        $this->apiResponse->setResult($pagination->get(), 'data');
        return $this->respond($this->apiResponse->getApiResult(), 200, 'OK');
    }

    public function show($id = null)
    {
        $rs = $this->getComp()->where(['id' => $id])->first();


        if (!empty($rs)) {
            $this->apiResponse->setResult($rs, 'ticket');
            return $this->respond($this->apiResponse->getApiResult(), 200, 'OK');
        } else {
            return $this->failNotFound('Ticket not found');
        }
    }

    public function create()
    {
        $this->validation->setRules(TicketValidation::CREATE);
        $this->validation->withRequest($this->request)->run();
        $erros = $this->validation->getErrors();

        if (!empty($erros)) {
            return $this->fail($erros);
        }

        $data = $this->getInput();

        $fill = (object)[
            'id_evento' => $data['event_id'],
            'id_categoria' => $data['category_id'],
            'cartao' => $data['ticket_number'],
            'nome' => $data['name']??'',
            'email' => $data['email']??'',
            'rg' => $data['document_rg']??'',
            'cpf' => $data['document_cpf']??'',
            'situacao' => $data['status'],
            'campoextra1' => $data['extrafield_1']??'',
            'campoextra2' => $data['extrafield_2']??'',
            'mestre' => $data['master'],
        ];
        
        $itemId = $this->model->insert($fill);
        if ($itemId) {
            $fill->updatedImage = $this->updateImage($itemId);
            $fill->id = $itemId;
            $this->apiResponse->setResult($fill, 'ticket');
        } else {
            return $this->fail($this->model->errors());
        }

        return $this->respondCreated($this->apiResponse->getApiResult(), 'ticket created');
    }

    public function update($id = null)
    {
        $this->validation->setRules(TicketValidation::UPDATE);
        $data = $this->getInput();

        $this->validation->run($data);
        $erros = $this->validation->getErrors();

        if (!empty($erros)) {
            return $this->fail($erros);
        }

        $where = ['id' => $id];


        $rs = $this->model->where($where)->find($id);

        if (empty($rs)) {
            return $this->fail('invalid Ticket');
        }
     
        $fill = (object)[
            'id' => $id,
            'id_evento' => $data['event_id'],
            'id_categoria' => $data['category_id'],
            'cartao' => $data['ticket_number'],
            'nome' => $data['name']??'',
            'email' => $data['email']??'',
            'rg' => $data['document_rg']??'',
            'cpf' => $data['document_cpf']??'',
            'situacao' => $data['status'],
            'campoextra1' => $data['extrafield_1']??'',
            'campoextra2' => $data['extrafield_2']??'',
            'mestre' => $data['master'],
        ];

        if ($this->model->save($fill) === false) {
            return $this->fail($this->model->errors());
        } else {
            $fill->updatedImage = $this->updateImage($id);
            $this->apiResponse->setResult($fill, 'ticket');
        }

        return $this->respondUpdated($this->apiResponse->getApiResult(), 'ticket updated');
    }

    public function getImage($id)
    {
        $this->apiResponse->setResult([
            'base64Content'=> $this->libImage->getImage($id)
        ], 'image');
        return $this->respond($this->apiResponse->getApiResult(), 200, 'OK');
    }

    private function updateImage($id)
    {
        $data = $this->getInput();

        if (array_key_exists('image', $data) && !empty($data['image'])) {
            return $this->libImage->saveBase64Image($id, $data['image']);
        }

        if (array_key_exists('urlimage', $data) && !empty($data['urlimage'])) {
            return $this->libImage->saveUrlImage($id, $data['urlimage']);
        }

        return false;
        
    }

    private function getComp()
    {
        return $this->model->select(
            'id,
                id_evento as event_id,
                id_categoria as category_id,
                cartao as ticket_number,
                nome as name,
                email as email,
                rg as document_rg,
                cpf as document_cpf,
                situacao as status,
                campoextra1 as extrafield_1,
                campoextra2 as extrafield_2,
                mestre as master
            '
        );
    }
}
