<?php

namespace App\Controllers\Api;

use App\Controllers\Api\BaseResourceController;
use App\Libraries\LibPaginate;
use App\Libraries\LibImage;
use App\Models\TicketModel;
use App\Models\RegistryModel;
use App\Models\CategoryModel;
use App\Models\DeviceModel;
use App\Models\EventModel;
use App\Models\PhotoModel;


class Sync  extends BaseResourceController
{

    public LibPaginate $pagination;
    public LibImage $libImage;
    public RegistryModel $register;
    public CategoryModel $category;
    public DeviceModel $device;
    public EventModel $event;
    public PhotoModel $photo;

    public function __construct()
    {
        $this->model = new TicketModel();
        $this->libImage = new LibImage();
        $this->register = new RegistryModel();
        $this->category = new CategoryModel();
        $this->device = new DeviceModel();
        $this->event = new EventModel();
        $this->photo = new PhotoModel();
    }

    public function syncTicket()
    {
        $data = $this->getComp();
        $pagination = new LibPaginate($data, $this->request, 'tickets');
        $pagination->addFilter('cartoes.id', 'id', '=');
        $pagination->addFilter('cartoes.updated_at', 'updated_at', 'maior');
        $pagination->addFilter('cartoes.cartao', 'ticket_number', '=');
        $pagination->addFilter('cartoes.nome', 'name', '=');
        $pagination->addFilter('cartoes.email', 'email', '=');
        $pagination->addFilter('cartoes.rg', 'document_rg', '=');
        $pagination->addFilter('cartoes.cpf', 'document_cpf', '=');
        $pagination->addFilter('cartoes.id_evento', 'event_id', '=');
        $pagination->addFilter('cartoes.id_categoria', 'category_id', '=');

        $pagination->setRows($this->request->getGet('rows'));
        $pagination->setPage($this->request->getGet('page'));
        $pagination->setSort($this->request->getGet('sort'));
        $pagination->setOrder($this->request->getGet('order'));
        $this->apiResponse->setResult($pagination->get(), 'data');
        return $this->respond($this->apiResponse->getApiResult(), 200, 'OK');
    }

    public function syncRegister()
    {
        $data = $this->register;
        $pagination = new LibPaginate($data, $this->request, 'register');
        $pagination->addFilter('id', 'id', '=');
        $pagination->addFilter('data_acesso', 'data_acesso', '=');
        $pagination->addFilter('acao', 'action', '=');
        $pagination->addFilter('terminal', 'terminal', '=');
        $pagination->addFilter('send_on', 'send_on', '=');
        $pagination->addFilter('data_acesso', 'data_maior', 'maior');
        $pagination->addFilter('cartao', 'ticket_number', '=');
        $pagination->addFilter('id_evento', 'event_id', '=');
        $pagination->setRows($this->request->getGet('rows'));
        $pagination->setPage($this->request->getGet('page'));
        $pagination->setSort($this->request->getGet('sort'));
        $pagination->setOrder($this->request->getGet('order'));
        $this->apiResponse->setResult($pagination->get(), 'data');
        return $this->respond($this->apiResponse->getApiResult(), 200, 'OK');
    }

    public function syncEnv()
    {
        $data = (object)[
            'category' => $this->category->findAll(),
            'event' => $this->event->findAll(),
            'device' => $this->device->findAll(),
        ];
        $this->apiResponse->setResult($data, 'data');
        return $this->respond($this->apiResponse->getApiResult(), 200, 'OK');
    }

    public function syncCategory()
    {
        $data = $this->category;
        $pagination = new LibPaginate($data, $this->request, 'category');
        $pagination->addFilter('id', 'id', '=');
        $pagination->addFilter('categoria', 'category', 'like');
        $pagination->addFilter('idr_multiplo', 'multiplo', '=');
        $pagination->addFilter('tipo', 'type', '=');
        $pagination->setRows($this->request->getGet('rows'));
        $pagination->setPage($this->request->getGet('page'));
        $pagination->setSort($this->request->getGet('sort'));
        $pagination->setOrder($this->request->getGet('order'));
        $this->apiResponse->setResult($pagination->get(), 'data');
        return $this->respond($this->apiResponse->getApiResult(), 200, 'OK');
    }

    public function syncPhoto()
    {

        $model = $this->photo->select(
            'fotos.id,
                fotos.id_pessoas,
                fotos.foto,
                fotos.send_on,
                cartoes.id_evento as event_id,
                cartoes.cartao as ticket,
                fotos.criado_em'
        )
            ->join('cartoes', 'cartoes.id = fotos.id_pessoas', 'left');
        $pagination = new LibPaginate($this->photo, $this->request, 'photo');
        $pagination->addFilter('fotos.id', 'id', '=');
        $pagination->addFilter('fotos.id_pessoas', 'ticket_id', '=');
        $pagination->addFilter('fotos.send_on', 'sendon', '=');
        $pagination->addFilter('fotos.criado_em', 'created_at', 'maior');
        $pagination->addFilter('fotos.criado_em', 'data_maior', 'maior');
        $pagination->addFilter('cartoes.cartao', 'ticket', '=');
        $pagination->setRows($this->request->getGet('rows') ?? 5);
        $pagination->setPage($this->request->getGet('page'));
        $pagination->setSort($this->request->getGet('sort'));
        $pagination->setOrder($this->request->getGet('order'));

        $page = (object) $pagination->get();
        $rest = (object)[
            "pagination" => $page->pagination,
            "filter" => $page->filter,
            "photo" => []
        ];

        foreach ($page->photo as $photo) {
            $add = [
                'id' => $photo->id,
                'ticket_id' => $photo->id_pessoas,
                'send_on' => $photo->send_on,
                'created_at' => $photo->criado_em,
                'ticketNumber' => $photo->ticket,
                'event_id' => $photo->event_id,
                'image' => null,
            ];
       
            if(!empty( (string) $photo->foto)) {
                $add['image'] = base64_encode($photo->foto);
            } else {
                continue;
            }

            $rest->photo[] = (object)$add;
            
        }

        $this->apiResponse->setResult($rest, 'data');
        return $this->respond($this->apiResponse->getApiResult(), 200, 'OK');
    }

    public function syncPostTicket()
    {
        $response = (object)[
            'new' => [],
            'update' => [],
            'error' => []
        ];

        $listTicket = $this->request->getVar();

        if (!empty($listTicket)) {
            foreach ($listTicket as $card) {
                $data = [
                    'nome' => $card->nome,
                    'campoextra1' => $card->campoextra1,
                    'campoextra2' => $card->campoextra2,
                    'updated_at' => $card->updated_at,
                    'send_on' => $card->send_on,
                    'rg' => $card->rg,
                    'cpf' => $card->cpf,
                    'situacao' => $card->situacao,
                    'id_categoria' => $card->id_categoria,
                    'cartao' => $card->cartao,
                ];

                $ticket = $this->model->where([
                    'cartao' => $card->cartao
                ])->first();

                if (empty($ticket)) {
                    $data['id_evento'] = $card->id_evento;
                    try {
                        $this->model->insert($data);
                        $data['id'] = $card->id;
                        $response->new[] = $data;
                    } catch (\Exception $e) {
                        $data['id'] = $card->id;
                        $response->error[] = $data;
                    }
                } else {
                    try {
                        $this->model->update($ticket->id, $data);
                        $data['id'] = $card->id;
                        $response->update[] = $data;
                    } catch (\Exception $e) {
                        $data['id'] = $card->id;
                        $response->error[] = $data;
                    }
                }
            }
        }

        $this->apiResponse->setResult($response, 'data');
        return $this->respond($this->apiResponse->getApiResult(), 200, 'OK');
    }

    public function syncPostRegister()
    {
        $response = (object)[
            'valid' => [],
            'invalid' => [],
            'error' => []
        ];

        $listRegister = $this->request->getVar();

        if (!empty($listRegister)) {
            foreach ($listRegister as $register) {

                $ret = [
                    'id' => $register->id,
                    'cartao' => $register->cartao,
                    'data_acesso' => $register->data_acesso,
                    'acao' => $register->acao,
                    'send_on' => $register->send_on,
                ];

                $ticket = $this->model->where([
                    'cartao' => $register->cartao
                ])->first();

                $localRegister = $this->register->where([
                    'cartao' => $register->cartao,
                    'data_acesso' => $register->data_acesso,
                    'acao' => $register->acao,
                ])->first();

                if (empty($localRegister) && !empty($ticket)) {

                    $data = [
                        'id_pessoa' => $ticket->id,
                        'id_evento' => $ticket->id_evento,
                        'cartao' => $register->cartao,
                        'data_acesso' => $register->data_acesso,
                        'hora_acesso' => $register->data_acesso,
                        'acao' => $register->acao,
                        'terminal' => $register->terminal,
                        'giro' => $register->giro,
                        'send_on' => $register->send_on
                    ];

                    try {
                        $this->register->insert($data);
                        $response->valid[] = $ret;
                    } catch (\Exception $e) {
                        $response->error[] = $ret;
                    }
                } else {
                    $response->invalid[] = $ret;
                }
            }
        }

        $this->apiResponse->setResult($response, 'data');
        return $this->respond($this->apiResponse->getApiResult(), 200, 'OK');
    }

    public function syncPostPhoto()
    {
        $response = (object)[
            'valid' => [],
            'invalid' => [],
            'error' => []
        ];

        $listPhoto = $this->request->getVar();

        if (!empty($listPhoto)) {
            foreach ($listPhoto as $photo) {

                $ret = [
                    'id' => $photo->id,
                    'cartao' => $photo->cartao,
                    'criado_em' => $photo->criado_em,
                    'send_on' => $photo->send_on,
                ];

                $ticket = $this->model->where([
                    'cartao' => $photo->cartao
                ])->first();

                if (!empty($ticket)) {

                    $localPhoto = $this->photo->where([
                        'id_pessoas' => $ticket->id,
                    ])->first();

                    $data = [
                        'id_pessoas' => $ticket->id,
                        'foto' => null,
                        'send_on' => $photo->send_on,
                        'criado_em' => $photo->criado_em
                    ];

                    if(!empty($photo->foto)) {
                        $data['foto'] = base64_decode((string) $photo->foto);
                    }

                    if (!empty($localPhoto)) {
                        // update
                        try {
                            $this->photo->update($localPhoto->id, $data);
                            $response->valid[] = $ret;
                        } catch (\Exception $e) {
                            $response->error[] = $ret;
                        }
                    } else {
                        // add
                        try {
                            $this->photo->insert($data);
                            $response->valid[] = $ret;
                        } catch (\Exception $e) {
                            $response->error[] = $ret;
                        }
                    }
                } else {
                    $response->invalid[] = $ret;
                }
            }
        }

        $this->apiResponse->setResult($response, 'data');
        return $this->respond($this->apiResponse->getApiResult(), 200, 'OK');
    }


    private function getComp()
    {
        return $this->model->select(
            'cartoes.id,
                cartoes.id_evento as event_id,
                categorias.categoria as category,
                categorias.tipo as category_type,
                categorias.fluxo as category_fluxo,
                categorias.idr_multiplo as category_idr_multiplo,
                eventos.evento as event,
                eventos.local as event_local,
                eventos.data_inicio as event_start,
                eventos.data_fim as event_end,
                eventos.campoextra1 as event_extra1,
                eventos.campoextra2 as event_extra2,
                cartoes.id_categoria as category_id,
                cartoes.cartao as ticket_number,
                cartoes.nome as name,
                cartoes.email as email,
                cartoes.rg as document_rg,
                cartoes.cpf as document_cpf,
                cartoes.situacao as status,
                cartoes.campoextra1 as extrafield_1,
                cartoes.campoextra2 as extrafield_2,
                cartoes.updated_at,
                cartoes.mestre as master
            '
        )->join('categorias', 'categorias.id = cartoes.id_categoria', 'left')
            ->join('eventos', 'eventos.id = cartoes.id_evento', 'left');
    }
}
