<?php

namespace App\Controllers\Api;

use App\Controllers\Api\BaseResourceController;
use App\Libraries\LibPaginate;
use App\Models\EventModel;
use App\RequestValidation\EventValidation;

class Event  extends BaseResourceController
{

    public $apiResult;
    public $event;
    public $inputJson;
    public LibPaginate $pagination;

    public function __construct()
    {
        $this->model = new EventModel();
    }
    
    public function index()
    {
        $data = $this->getComp();
        $pagination = new LibPaginate($data, $this->request, 'events');
        $pagination->addFilter('id', 'id', '=');
        $pagination->addFilter('data_inicio', 'start_date', '=');
        $pagination->addFilter('data_fim', 'end_date', '=');
        $pagination->addFilter('evento', 'name', 'like');
        $pagination->setRows($this->request->getGet('rows'));
        $pagination->setPage($this->request->getGet('page'));
        $pagination->setSort($this->request->getGet('sort'));
        $pagination->setOrder($this->request->getGet('order'));
        $this->apiResponse->setResult($pagination->get(), 'data');
        return $this->respond($this->apiResponse->getApiResult(), 200, 'OK');
    }

    public function show($id = null)
    {
        $rs = $this->getComp()->where(['id' => $id])->first();


        if (!empty($rs)) {
            $this->apiResponse->setResult($rs, 'event');
            return $this->respond($this->apiResponse->getApiResult(), 200, 'OK');
        } else {
            return $this->failNotFound('Event not found');
        }
    }

    public function create()
    {
        $this->validation->setRules(EventValidation::CREATE);
        $this->validation->withRequest($this->request)->run();
        $erros = $this->validation->getErrors();

        if (!empty($erros)) {
            return $this->fail($erros);
        }

        $data = $this->getInput();

        $fill = (object)[
            'evento' => $data['name'],
            'local' => $data['local'],
            'data_inicio' => $data['start_date'],
            'data_fim' => $data['end_date'],
            'campoextra1' => $data['extrafield_1'],
            'campoextra2' => $data['extrafield_2']
        ];
        
        $eventId = $this->model->insert($fill);
        if ($eventId) {
            $fill->id = $eventId;
            $this->apiResponse->setResult($fill, 'event');
        } else {
            return $this->fail($this->model->errors());
        }

        return $this->respondCreated($this->apiResponse->getApiResult(), 'event created');
    }

    public function update($id = null)
    {
        $this->validation->setRules(EventValidation::UPDATE);
        $data = $this->getInput();

        $this->validation->run($data);
        $erros = $this->validation->getErrors();

        if (!empty($erros)) {
            return $this->fail($erros);
        }

        $where = ['id' => $id];


        $rs = $this->model->where($where)->find($id);

        if (empty($rs)) {
            return $this->fail('invalid Event');
        }
     
        $fill = (object)[
            'id' => $id,
            'evento' => $data['name'],
            'local' => $data['local'],
            'data_inicio' => $data['start_date'],
            'data_fim' => $data['end_date'],
            'campoextra1' => $data['extrafield_1'],
            'campoextra2' => $data['extrafield_2']
        ];

        if ($this->model->save($fill) === false) {
            return $this->fail($this->model->errors());
        } else {
            $this->apiResponse->setResult($fill, 'event');
        }

        return $this->respondUpdated($this->apiResponse->getApiResult(), 'event updated');
    }

    



    private function getComp()
    {
        return $this->model->select(
            '   id,
                evento as name,
                local,
                data_inicio as start_date,
                data_fim as end_date,
                campoextra1 as extrafield_1,
                campoextra2 as extrafield_2
            '
        );
    }
}
