<?php

namespace App\Controllers\Api;

use App\Models\TicketModel;
use App\Models\CategoryModel;
use App\Models\EventModel;
use App\Models\DeviceModel;
use App\Models\RegistryModel;

use CodeIgniter\RESTful\ResourceController;

class Collector  extends ResourceController
{

    public $apiResult;
    public $event;
    public $ticket;
    public $category;
    public $device;
    public $registry;
    public $inputJson;

    public function __construct()
    {
        $this->apiResult = (object) [
            "status" => true,
            "data" => null,
            "message" => null,
        ];
        $this->ticket = new TicketModel();
        $this->event = new EventModel();
        $this->category = new CategoryModel();
        $this->device = new DeviceModel();
        $this->registry = new RegistryModel();
        
    }
    /**
     * Return an array of resource objects, themselves in array format
     *
     * @return mixed
     */
    public function index()
    {
        $data=(object)[
            'ticket' =>null,
            // 'event' =>null,
            'category' =>null,
            'registry' =>null,
            'device' =>null,
        ];
        $dataJson = $this->getInput('pin');
        $data->device = $this->getPin($dataJson->pin);
        if ($data->device) {
            $lastTicketId = (int) $dataJson->lastTicketId;
            $tickets = $this->ticket->where('id >=', $lastTicketId)->orderBy('id')->findAll();
            $data->ticket = $this->formatTicket($tickets);
            $data->category = $this->category->findAll();
            $this->apiResult->data = $data;
        } else {
            $this->apiResult->status = false;
            $this->apiResult->message = 'Ticket não encontrado';
        }

        return $this->respond($this->apiResult, 200);
    }

    private function getPin($pin)
    {
        return $this->device->where([
            'terminal_pin' => $pin,
            'ativo' => 1,
            'terminal_model' => 'APP',
        ])->first();
    }

    private function formatTicket($rs)
    {
        $data = [];
        foreach ($rs as $ticket) {
            $data[]=(object) [
                'id' => $ticket->id,
                'cod' => str_replace('-', '', $ticket->cartao),
                'active' => empty($ticket->situacao)?0:1,
                'lastPass' => null,
                'lastRegister' => null
            ];
        }
        return $data;
    }

    protected function getInput($name = null)
    {
        $this->inputJson = $this->request->getJSON();
        if (!empty($name) && is_array($this->inputJson)) {
            if (array_key_exists($name, $this->inputJson)) {
                return $this->inputJson[$name];
            } else {
                return null;
            }
        } else {
            return $this->inputJson;
        }
    }
}
