<?php

namespace App\Controllers\Api;

use App\Controllers\Api\BaseResourceController;
use App\Libraries\LibPaginate;
use App\Models\CategoryModel;
use App\RequestValidation\CategoryValidation;

class Category  extends BaseResourceController
{

    public $apiResult;
    public $event;
    public $inputJson;
    public LibPaginate $pagination;

    public function __construct()
    {
        $this->model = new CategoryModel();
    }
    
    public function index()
    {
        $data = $this->getComp();
        $pagination = new LibPaginate($data, $this->request, 'categories');
        $pagination->addFilter('id', 'id', '=');
        $pagination->addFilter('categoria', 'category', '=');
        $pagination->addFilter('tipo', 'type', '=');
        $pagination->setRows($this->request->getGet('rows'));
        $pagination->setPage($this->request->getGet('page'));
        $pagination->setSort($this->request->getGet('sort'));
        $pagination->setOrder($this->request->getGet('order'));
        $this->apiResponse->setResult($pagination->get(), 'data');
        return $this->respond($this->apiResponse->getApiResult(), 200, 'OK');
    }

    public function show($id = null)
    {
        $rs = $this->getComp()->where(['id' => $id])->first();


        if (!empty($rs)) {
            $this->apiResponse->setResult($rs, 'category');
            return $this->respond($this->apiResponse->getApiResult(), 200, 'OK');
        } else {
            return $this->failNotFound('Category not found');
        }
    }

    public function create()
    {
        $this->validation->setRules(CategoryValidation::CREATE);
        $this->validation->withRequest($this->request)->run();
        $erros = $this->validation->getErrors();

        if (!empty($erros)) {
            return $this->fail($erros);
        }

        $data = $this->getInput();

        $fill = (object)[
            'categoria' => $data['name'],
            'idr_multiplo' => $data['multi_access'],
            'tipo' => $data['type'],
        ];
        
        $eventId = $this->model->insert($fill);
        if ($eventId) {
            $fill->id = $eventId;
            $this->apiResponse->setResult($fill, 'category');
        } else {
            return $this->fail($this->model->errors());
        }

        return $this->respondCreated($this->apiResponse->getApiResult(), 'category created');
    }

    public function update($id = null)
    {
        $this->validation->setRules(CategoryValidation::UPDATE);
        $data = $this->getInput();

        $this->validation->run($data);
        $erros = $this->validation->getErrors();

        if (!empty($erros)) {
            return $this->fail($erros);
        }

        $where = ['id' => $id];


        $rs = $this->model->where($where)->find($id);

        if (empty($rs)) {
            return $this->fail('invalid Category');
        }
     
        $fill = (object)[
            'id' => $id,
            'categoria' => $data['name'],
            'idr_multiplo' => $data['multi_access'],
            'tipo' => $data['type'],
        ];

        if ($this->model->save($fill) === false) {
            return $this->fail($this->model->errors());
        } else {
            $this->apiResponse->setResult($fill, 'category');
        }

        return $this->respondUpdated($this->apiResponse->getApiResult(), 'category updated');
    }

    



    private function getComp()
    {
        return $this->model->select(
            'id,
                categoria as name,
                idr_multiplo as multi_access,
                tipo as type
            '
        );
    }
}
