<?php

namespace App\Controllers\Api;

use App\Libraries\LibResponseJson;
use CodeIgniter\RESTful\ResourceController;


class BaseResourceController extends ResourceController
{
    protected LibResponseJson $apiResponse;
    protected $validation;
    protected $inputJson;
    protected $auth;
    protected $eventAuth;
    protected $clientAuth;
    protected $helpers = ['url', 'file', 'my_helper'];

    public function initController(
        \CodeIgniter\HTTP\RequestInterface $request,
        \CodeIgniter\HTTP\ResponseInterface $response,
        \Psr\Log\LoggerInterface $logger
        )
    {
        parent::initController($request, $response, $logger);
        $this->inputJson = $this->request->getJSON(true);
        $this->apiResponse = new LibResponseJson();
        $this->validation =  \Config\Services::validation();
    }

    protected function getInput($name = null)
    {
        if (!empty($name)) {
            if (array_key_exists($name, $this->inputJson)) {
                return $this->inputJson[$name];
            } else {
                return null;
            }
        } else {
            return $this->inputJson;
        }
    }
}
