<?php

namespace App\Controllers\Api;

use CodeIgniter\RESTful\ResourceController;
use App\Libraries\LibAuth;

class Auth  extends ResourceController
{

    public function __construct()
    {

    }
    /**
     * Return an array of resource objects, themselves in array format
     *
     * @return mixed
     */
    public function login()
    {
        $user = LibAuth::$user;
        if (!empty($user)) {
            $response = (object) [
                "token_type" => "Bearer",
                "expires_in" => $user->expireAt,
                "access_token" => $user->usertoken,
                "user" => [
                    'id' => $user->id,
                    'name' => $user->nome_completo,
                    'login' => $user->login,
                ]
            ];
            return $this->respond($response, 200);
        } else {
            return $this->fail('Invalid User/Password', 401);
        }
    }

    public function list() {
        return $this->respond(['list'], 200);
    }
}
