<?php

namespace App\Controllers\Api;

use App\Models\DeviceModel;
use App\Models\GroupModel;
use App\Libraries\TicketValidation;

use CodeIgniter\RESTful\ResourceController;

class Acesso extends ResourceController
{
    public $apiResult;
    public $inputJson;
    private GroupModel $grupo;
    private TicketValidation $ticketValidation;

    public function __construct()
    {
        $this->apiResult = (object) [
            "status" => true,
            "data" => null,
            "message" => null,
        ];
        $this->model = new DeviceModel();
        $this->grupo = new GroupModel();
        $this->ticketValidation = new TicketValidation();
    }

    public function login()
    {
        $output = (object) [
            'status' => false,
            'id' => null,
            'nome' => null,
            'group' => null,
        ];
        $pin = $this->request->getJsonVar('pin');
        $rs = $this->model->where([
            'terminal_pin' => $pin,
            'ativo' => 1,
        ])->whereIn('terminal_model', ['APP','IHX-APP', 'ENTREGA'])
		->first();

        if ($rs) {
            $output->status = true;
            $output->id = $rs->id;
            $output->nome = $rs->terminal_nome;
            $output->group = $this->grupo->find($rs->grupo_categoria_id);
            return $this->respond($output, 200, 'OK');
        } else {
            return $this->respond(null, 401);
        }
    }

    public function register()
    {
        $ticket = $this->request->getJsonVar('ticket');
        $pin = $this->request->getJsonVar('pin');
        $viewImage = (bool) $this->request->getJsonVar('viewImage') ?? 0;
        return $this->response->setJSON($this->ticketValidation->validate($ticket, $pin, $viewImage));
    }
}
