<?php

namespace App\Controllers\Api;

use App\Models\TicketModel;
use App\Models\CategoryModel;
use App\Models\EventModel;
use App\Models\PhotoModel;
use App\Models\RegistryModel;

use App\Entities\TicketEntity;

use CodeIgniter\RESTful\ResourceController;

class Accreditation  extends ResourceController
{

    public $apiResult;
    public $event;
    public $category;
    public $photo;
    public $registry;
    public $inputJson;
    private TicketEntity $ticket;

    public function __construct()
    {
        $this->apiResult = (object) [
            "status" => true,
            "data" => null,
            "message" => null,
        ];
        $this->ticket = new TicketEntity();
        $this->model = new TicketModel();
        $this->event = new EventModel();
        $this->category = new CategoryModel();
        $this->photo = new PhotoModel();
        $this->registry = new RegistryModel();
        
    }
    /**
     * Return an array of resource objects, themselves in array format
     *
     * @return mixed
     */
    public function ticket()
    {
        $data=(object)[
            'ticket' =>null,
            'event' =>null,
            'category' =>null,
            'registry' =>null,
            'photo' =>null,
        ];

        $ticket = $this->request->getGet('ticket');
        $rs = $this->model->getCredenciado($ticket);
        if ($rs) {
            $this->apiResult->status = true;
            $data->ticket = $rs;
            $data->event = $this->event->find($rs->id_evento);
            $data->category = $this->category->find($rs->id_categoria);
            $data->registry = $this->registry->where('id_pessoa', $rs->id)->limit(30)->orderBy('id', 'desc')->findAll();
            $data->photo = $this->getImage($rs->id);
            $this->apiResult->data = $data;
        } else {
            $this->apiResult->status = false;
            $this->apiResult->message = 'Ticket não encontrado';
        }

        return $this->respond($this->apiResult, 200);
    }

    public function update($id = null)
    {
        $result = $this->model->find((int)$id);
        if ($result) {
            $data = [
                'id_categoria' => $this->request->getJsonVar('id_categoria'),
                'nome' => $this->request->getJsonVar('nome'),
                'email' => $this->request->getJsonVar('email'),
                'rg' => $this->request->getJsonVar('rg'),
                'cpf' => $this->request->getJsonVar('cpf'),
                'situacao' => $this->request->getJsonVar('situacao'),
                'campoextra1' => $this->request->getJsonVar('campoextra1'),
                'campoextra2' => $this->request->getJsonVar('campoextra2'),
                'remote_id' => $this->request->getJsonVar('remote_id'),
                'send_on'=>null
            ];

            if(empty($result->credenciado_em)) {
                $data['credenciado_em'] = date('Y-m-d H:i:s');
            }
       
            if($this->model->update($id, $data)) {
                $this->apiResult->status = true;
                $this->apiResult->message = 'Ticket atualizado com sucesso';
            } else {
                $this->apiResult->status = false;
                $this->apiResult->message = 'Ticket não encontrado';
            }
        } else {
            $this->apiResult->status = false;
            $this->apiResult->message = 'Ticket não encontrado';
        }

        return $this->respondUpdated($this->apiResult, $this->apiResult->message);
    }

    public function changestatus($id)
    {
        $result = $this->model->find((int)$id);
        if ($result) {
            $data = [
                'situacao' => (int) $this->request->getJsonVar('situacao'),
                'send_on'=>null
            ];

            if(empty($result->credenciado_em)) {
                $data['credenciado_em'] = date('Y-m-d H:i:s');
            }
       
            if($this->model->update($id, $data)) {
                $this->apiResult->status = true;
                $this->apiResult->message = 'Ticket atualizado com sucesso';
            } else {
                $this->apiResult->status = false;
                $this->apiResult->message = 'Ticket não encontrado';
            }
        } else {
            $this->apiResult->status = false;
            $this->apiResult->message = 'Ticket não encontrado';
        }

        return $this->respondUpdated($this->apiResult, $this->apiResult->message);
    }

    public function image($id)
    {
        $result = $this->model->find((int)$id);
        
        if ($result) {
            $image = str_replace('data:image/jpeg;base64,', '', $this->request->getJsonVar('photo'));
            $data = [
                'id_pessoas'=> $result->id,
                'foto' => base64_decode($image),
                'criado_em'=> date('Y-m-d H:i:s'),
                'send_on'=>null
            ];
            $image = $this->photo->where('id_pessoas', $result->id)->first();
            if($image){
                $this->photo->update($image->id, $data);
            } else {
                $this->photo->save($data);
            }
            $this->apiResult->status = true;
            $this->apiResult->message = 'Imagem atualizada';
        } else {
            $this->apiResult->status = false;
            $this->apiResult->message = 'Imagem não encontrado';
        }

        return $this->respondUpdated($this->apiResult, 'image');
    }

    public function getImage($ticketId) {
        $rs = $this->photo->where('id_pessoas', $ticketId)->first();
        if($rs) {
            return 'data:image/jpeg;base64,'.base64_encode($rs->foto);
        }
        return null;
    }

    protected function getInput($name = null)
    {
        $this->inputJson = $this->request->getJSON();
        if (!empty($name) && is_array($this->inputJson)) {
            if (array_key_exists($name, $this->inputJson)) {
                return $this->inputJson[$name];
            } else {
                return null;
            }
        } else {
            return $this->inputJson;
        }
    }
}
